/*
 * Decompiled with CFR 0.152.
 */
package com.trs.util.dbcp.impl;

import com.trs.util.dbcp.impl.CacheImpl;
import com.trs.util.dbcp.impl.ConnectionQueue;
import com.trs.util.dbcp.impl.DebugImplConnection;
import com.trs.util.dbcp.impl.HookConnection;
import com.trs.util.dbcp.impl.ImplConnection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import org.apache.log4j.Logger;

class ConnectionWrapper
extends ConnectionQueue.Node {
    private static final Logger LOG;
    static final boolean zProxyEnabled;
    static final boolean zDebugImplConnection;
    static final boolean zProxySupport;
    static final boolean zProxyWrapper;
    Connection m_connLogicals;
    Connection m_connPhysical;
    int m_iAssignCount;
    CacheImpl m_objCacheImpl;
    Throwable m_tAssignStack;
    long m_tmAccessTime;
    long m_tmAssignTime;
    long m_tmCreateTime;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.util.dbcp.impl.ConnectionWrapper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
        zProxyEnabled = Boolean.getBoolean("com.trs.util.dbcp.impl.proxy.enable");
        zDebugImplConnection = Boolean.getBoolean("com.trs.util.dbcp.impl.debug.enable");
        zProxySupport = ConnectionWrapper.getJavaVersion() >= 1.3f;
        zProxyWrapper = zProxyEnabled && zProxySupport && !zDebugImplConnection;
    }

    static final float getJavaVersion() {
        StringBuffer sVersion = new StringBuffer();
        String strJavaVersion = System.getProperty("java.version");
        sVersion.append(strJavaVersion.charAt(0));
        sVersion.append(strJavaVersion.charAt(2));
        if (strJavaVersion.length() >= 5) {
            sVersion.append(strJavaVersion.charAt(4));
        }
        return Float.parseFloat(sVersion.toString());
    }

    ConnectionWrapper(CacheImpl cci) {
        this.m_objCacheImpl = cci;
        this.m_tAssignStack = new Throwable();
    }

    Connection getConnection() {
        return this.m_connPhysical;
    }

    Connection getLogical() {
        return this.m_connLogicals;
    }

    boolean isUsing() {
        return this.m_connLogicals != null;
    }

    boolean isValid() {
        return this.m_connPhysical != null;
    }

    Connection newLogical() {
        if (zProxyWrapper) {
            this.m_connLogicals = (Connection)Proxy.newProxyInstance(this.m_connPhysical.getClass().getClassLoader(), this.m_connPhysical.getClass().getInterfaces(), (InvocationHandler)new HookConnection(this));
            return this.m_connLogicals;
        }
        this.m_connLogicals = zDebugImplConnection || LOG.isDebugEnabled() ? new DebugImplConnection(this) : new ImplConnection(this);
        return this.m_connLogicals;
    }

    Connection newProxy() {
        if (zProxyWrapper) {
            return (Connection)Proxy.newProxyInstance(this.m_connPhysical.getClass().getClassLoader(), this.m_connPhysical.getClass().getInterfaces(), (InvocationHandler)new HookConnection(this.m_connPhysical));
        }
        return zDebugImplConnection ? new DebugImplConnection(this.m_connPhysical) : new ImplConnection(this.m_connPhysical);
    }

    void recycle() {
        if (this.m_connLogicals != null) {
            this.m_connLogicals = null;
            this.m_objCacheImpl.recycle(this);
        }
    }

    void release() {
        try {
            Connection conn = this.m_connPhysical;
            this.m_connPhysical = null;
            this.m_iAssignCount = 0;
            this.m_tmCreateTime = 0L;
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void revoke() {
        try {
            this.m_connLogicals.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setConnection(Connection conn) {
        this.m_connPhysical = conn;
        this.m_iAssignCount = 0;
        this.m_tmCreateTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append(',');
        if (this.isValid()) {
            sb.append(this.m_connPhysical.toString()).append(',');
            sb.append("Using:").append(this.isUsing());
            sb.append("CreateTime:").append(this.m_tmCreateTime);
            sb.append("AssignCount:").append(this.m_iAssignCount);
        } else {
            sb.append("invalid");
        }
        return sb.toString();
    }
}

