/*
 * Decompiled with CFR 0.152.
 */
package com.trs.util.dbcp.impl;

import com.trs.util.dbcp.impl.ConnectionWrapper;
import org.apache.log4j.Logger;

final class ConnectionQueue {
    private static final Logger s_logger;
    private final Node pole = new Node();
    private int size = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.util.dbcp.impl.ConnectionQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    ConnectionQueue() {
        this.pole.next = this.pole;
        this.pole.prev = this.pole;
    }

    synchronized boolean cut(Node node) {
        if (node.queue == null) {
            s_logger.warn((Object)("The node '" + node + "' is orphan."));
            return false;
        }
        if (node.queue != this) {
            s_logger.error((Object)("The node '" + node + "' is part of '" + node.queue + "'."));
            return false;
        }
        if (this.size == 0) {
            s_logger.error((Object)("Be to cut node '" + node + "' from empty queue."));
            return false;
        }
        node.next.prev = node.prev;
        node.prev.next = node.next;
        node.prev = null;
        node.next = null;
        node.queue = null;
        --this.size;
        return true;
    }

    synchronized ConnectionWrapper get() {
        Node head = this.pole.next;
        if (head == this.pole) {
            return null;
        }
        head.prev.next = head.next;
        head.next.prev = head.prev;
        head.prev = null;
        head.next = null;
        head.queue = null;
        --this.size;
        return (ConnectionWrapper)head;
    }

    synchronized void put(Node node) {
        if (node.queue != null) {
            if (node.queue == this) {
                s_logger.warn((Object)("The node '" + node + "' duplicated in queue '" + this + "'."));
            } else {
                s_logger.error((Object)("The node '" + node + "' conflicted in '" + this + "' and '" + node.queue + "'."));
            }
            return;
        }
        Node tail = this.pole.prev;
        tail.next = node;
        node.prev = tail;
        node.next = this.pole;
        this.pole.prev = node;
        node.queue = this;
        ++this.size;
    }

    int size() {
        return this.size;
    }

    static class Node {
        private Node next = null;
        private Node prev = null;
        private ConnectionQueue queue = null;

        Node() {
        }
    }
}

