/*
 * Decompiled with CFR 0.152.
 */
package trs.org.objectweb.asm.util.attrs;

import java.util.List;
import java.util.Map;
import trs.org.objectweb.asm.Attribute;
import trs.org.objectweb.asm.ClassReader;
import trs.org.objectweb.asm.Label;
import trs.org.objectweb.asm.attrs.StackMapFrame;
import trs.org.objectweb.asm.attrs.StackMapTableAttribute;
import trs.org.objectweb.asm.attrs.StackMapType;
import trs.org.objectweb.asm.util.attrs.ASMifiable;
import trs.org.objectweb.asm.util.attrs.Traceable;

public class ASMStackMapTableAttribute
extends StackMapTableAttribute
implements ASMifiable,
Traceable {
    private int len;

    public ASMStackMapTableAttribute() {
    }

    public ASMStackMapTableAttribute(List frames, int len) {
        super(frames);
        this.len = len;
    }

    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        StackMapTableAttribute attr = (StackMapTableAttribute)super.read(cr, off, len, buf, codeOff, labels);
        return new ASMStackMapTableAttribute(attr.getFrames(), len);
    }

    public void asmify(StringBuffer buf, String varName, Map labelNames) {
        List frames = this.getFrames();
        if (frames.size() == 0) {
            buf.append("List frames = Collections.EMPTY_LIST;\n");
        } else {
            buf.append("List frames = new ArrayList();\n");
            int i = 0;
            while (i < frames.size()) {
                buf.append("{\n");
                StackMapFrame f = (StackMapFrame)frames.get(i);
                ASMStackMapTableAttribute.declareLabel(buf, labelNames, f.label);
                String frameVar = String.valueOf(varName) + "frame" + i;
                this.asmifyTypeInfo(buf, frameVar, labelNames, f.locals, "locals");
                this.asmifyTypeInfo(buf, frameVar, labelNames, f.stack, "stack");
                buf.append("StackMapFrame ").append(frameVar).append(" = new StackMapFrame(").append(labelNames.get(f.label)).append(", locals, stack);\n");
                buf.append("frames.add(").append(frameVar).append(");\n");
                buf.append("}\n");
                ++i;
            }
        }
        buf.append("StackMapTableAttribute ").append(varName);
        buf.append(" = new StackMapTableAttribute(frames);\n");
    }

    void asmifyTypeInfo(StringBuffer buf, String varName, Map labelNames, List infos, String field) {
        if (infos.size() == 0) {
            buf.append("List ").append(field).append(" = Collections.EMPTY_LIST;\n");
        } else {
            buf.append("List ").append(field).append(" = new ArrayList();\n");
            buf.append("{\n");
            int i = 0;
            while (i < infos.size()) {
                StackMapType typeInfo = (StackMapType)infos.get(i);
                String localName = String.valueOf(varName) + "Info" + i;
                int type = typeInfo.getType();
                buf.append("StackMapType ").append(localName).append(" = StackMapType.getTypeInfo( StackMapType.ITEM_").append(StackMapType.ITEM_NAMES[type]).append(");\n");
                switch (type) {
                    case 7: {
                        buf.append(localName).append(".setObject(\"").append(typeInfo.getObject()).append("\");\n");
                        break;
                    }
                    case 8: {
                        ASMStackMapTableAttribute.declareLabel(buf, labelNames, typeInfo.getLabel());
                        buf.append(localName).append(".setLabel(").append(labelNames.get(typeInfo.getLabel())).append(");\n");
                    }
                }
                buf.append(field).append(".add(").append(localName).append(");\n");
                ++i;
            }
            buf.append("}\n");
        }
    }

    static void declareLabel(StringBuffer buf, Map labelNames, Label l) {
        String name = (String)labelNames.get(l);
        if (name == null) {
            name = "l" + labelNames.size();
            labelNames.put(l, name);
            buf.append("Label ").append(name).append(" = new Label();\n");
        }
    }

    public void trace(StringBuffer buf, Map labelNames) {
        List frames = this.getFrames();
        buf.append("[\n");
        int i = 0;
        while (i < frames.size()) {
            StackMapFrame f = (StackMapFrame)frames.get(i);
            buf.append("    Frame:");
            this.appendLabel(buf, labelNames, f.label);
            buf.append(" locals[");
            this.traceTypeInfo(buf, labelNames, f.locals);
            buf.append("]");
            buf.append(" stack[");
            this.traceTypeInfo(buf, labelNames, f.stack);
            buf.append("]\n");
            ++i;
        }
        buf.append("  ] length:").append(this.len).append("\n");
    }

    private void traceTypeInfo(StringBuffer buf, Map labelNames, List infos) {
        String sep = "";
        int i = 0;
        while (i < infos.size()) {
            StackMapType t = (StackMapType)infos.get(i);
            buf.append(sep).append(StackMapType.ITEM_NAMES[t.getType()]);
            sep = ", ";
            if (t.getType() == 7) {
                buf.append(":").append(t.getObject());
            }
            if (t.getType() == 8) {
                buf.append(":");
                this.appendLabel(buf, labelNames, t.getLabel());
            }
            ++i;
        }
    }

    protected void appendLabel(StringBuffer buf, Map labelNames, Label l) {
        String name = (String)labelNames.get(l);
        if (name == null) {
            name = "L" + labelNames.size();
            labelNames.put(l, name);
        }
        buf.append(name);
    }
}

