/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.FileNotFoundException;
import javax.servlet.ServletContext;
import org.springframework.util.Log4jConfigurer;
import org.springframework.web.util.WebUtils;

public abstract class Log4jWebConfigurer {
    public static final String CONFIG_LOCATION_PARAM = "log4jConfigLocation";
    public static final String REFRESH_INTERVAL_PARAM = "log4jRefreshInterval";

    public static void initLogging(ServletContext servletContext) {
        WebUtils.setWebAppRootSystemProperty(servletContext);
        String location = servletContext.getInitParameter(CONFIG_LOCATION_PARAM);
        if (location != null) {
            if (location.charAt(0) != '/') {
                location = "/" + location;
            }
            location = servletContext.getRealPath(location);
            long refreshInterval = 60000L;
            String intervalString = servletContext.getInitParameter(REFRESH_INTERVAL_PARAM);
            if (intervalString != null) {
                refreshInterval = Long.parseLong(intervalString);
            }
            servletContext.log("Initializing Log4J from [" + location + "]");
            try {
                Log4jConfigurer.initLogging(location, refreshInterval);
            }
            catch (FileNotFoundException ex) {
                throw new IllegalArgumentException("Invalid log4jConfigLocation parameter: " + ex.getMessage());
            }
        }
    }

    public static void shutdownLogging(ServletContext servletContext) {
        servletContext.log("Shutting down Log4J");
        Log4jConfigurer.shutdownLogging();
    }
}

