/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.rmi;

import java.lang.reflect.InvocationTargetException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.rmi.RmiInvocationWrapper;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationBasedExporter;

public class RmiServiceExporter
extends RemoteInvocationBasedExporter
implements InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String serviceName;
    private int servicePort = 0;
    private int registryPort = 1099;
    private RMIClientSocketFactory clientSocketFactory;
    private RMIServerSocketFactory serverSocketFactory;
    private Remote exportedObject;
    static /* synthetic */ Class class$java$rmi$Remote;

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setServicePort(int servicePort) {
        this.servicePort = servicePort;
    }

    public void setRegistryPort(int registryPort) {
        this.registryPort = registryPort;
    }

    public void setClientSocketFactory(RMIClientSocketFactory clientSocketFactory) {
        this.clientSocketFactory = clientSocketFactory;
    }

    public void setServerSocketFactory(RMIServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.serviceName == null) {
            throw new IllegalArgumentException("serviceName is required");
        }
        if (this.clientSocketFactory instanceof RMIServerSocketFactory) {
            this.serverSocketFactory = (RMIServerSocketFactory)((Object)this.clientSocketFactory);
        }
        if (this.clientSocketFactory != null && this.serverSocketFactory == null || this.clientSocketFactory == null && this.serverSocketFactory != null) {
            throw new IllegalArgumentException("Both RMIClientSocketFactory and RMIServerSocketFactory or none required");
        }
        Registry registry = null;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Looking for RMI registry at port '" + this.registryPort + "'"));
        }
        try {
            registry = LocateRegistry.getRegistry(this.registryPort);
            registry.list();
        }
        catch (RemoteException ex) {
            this.logger.debug((Object)"RMI registry access threw exception", (Throwable)ex);
            this.logger.warn((Object)"Could not detect RMI registry - creating new one");
            registry = LocateRegistry.createRegistry(this.registryPort);
        }
        if (this.getService() instanceof Remote && (class$java$rmi$Remote == null ? (class$java$rmi$Remote = RmiServiceExporter.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(this.getServiceInterface())) {
            this.exportedObject = (Remote)this.getService();
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("RMI object '" + this.serviceName + "' is an RMI invoker"));
            }
            this.exportedObject = new RmiInvocationWrapper(this.getProxyForService(), this);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Binding RMI service '" + this.serviceName + "' to registry at port '" + this.registryPort + "'"));
        }
        if (this.clientSocketFactory != null) {
            UnicastRemoteObject.exportObject(this.exportedObject, this.servicePort, this.clientSocketFactory, this.serverSocketFactory);
        } else {
            UnicastRemoteObject.exportObject(this.exportedObject, this.servicePort);
        }
        registry.rebind(this.serviceName, this.exportedObject);
    }

    protected Object invoke(RemoteInvocation invocation, Object targetObject) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return super.invoke(invocation, targetObject);
    }

    public void destroy() throws RemoteException, NotBoundException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Unbinding RMI service '" + this.serviceName + "' from registry at port '" + this.registryPort + "'"));
        }
        Registry registry = LocateRegistry.getRegistry(this.registryPort);
        registry.unbind(this.serviceName);
        UnicastRemoteObject.unexportObject(this.exportedObject, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

