/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.support.SQLExceptionTranslator;

public class SQLStateSQLExceptionTranslator
implements SQLExceptionTranslator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static Set BAD_SQL_CODES = new HashSet();
    private static Set INTEGRITY_VIOLATION_CODES = new HashSet();

    public DataAccessException translate(String task, String sql, SQLException sqlex) {
        SQLException nestedEx;
        String sqlState;
        if (task == null) {
            task = "";
        }
        if (sql == null) {
            sql = "";
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Translating SQLException with SQLState '" + sqlex.getSQLState() + "' and errorCode '" + sqlex.getErrorCode() + "' and message [" + sqlex.getMessage() + "]; SQL was [" + sql + "] for task [" + task + "]"));
        }
        if ((sqlState = sqlex.getSQLState()) == null && (nestedEx = sqlex.getNextException()) != null) {
            sqlState = nestedEx.getSQLState();
        }
        if (sqlState != null && sqlState.length() >= 2) {
            String classCode = sqlState.substring(0, 2);
            if (BAD_SQL_CODES.contains(classCode)) {
                return new BadSqlGrammarException(task, sql, sqlex);
            }
            if (INTEGRITY_VIOLATION_CODES.contains(classCode)) {
                return new DataIntegrityViolationException("(" + task + "): data integrity violated by SQL '" + sql + "'", sqlex);
            }
        }
        return new UncategorizedSQLException("(" + task + "): encountered SQLException [" + sqlex.getMessage() + "]", sql, sqlex);
    }

    static {
        BAD_SQL_CODES.add("07");
        BAD_SQL_CODES.add("42");
        BAD_SQL_CODES.add("65");
        BAD_SQL_CODES.add("S0");
        INTEGRITY_VIOLATION_CODES.add("22");
        INTEGRITY_VIOLATION_CODES.add("23");
        INTEGRITY_VIOLATION_CODES.add("27");
        INTEGRITY_VIOLATION_CODES.add("44");
    }
}

