/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlProvider;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;

public class PreparedStatementCreatorFactory {
    private final String sql;
    private final List declaredParameters;
    private int resultSetType = 1003;
    private boolean updatableResults = false;
    private boolean returnGeneratedKeys = false;
    private String[] generatedKeysColumnNames = null;
    private NativeJdbcExtractor nativeJdbcExtractor;

    public PreparedStatementCreatorFactory(String sql) {
        this.sql = sql;
        this.declaredParameters = new LinkedList();
    }

    public PreparedStatementCreatorFactory(String sql, int[] types) {
        this.sql = sql;
        this.declaredParameters = SqlParameter.sqlTypesToAnonymousParameterList(types);
    }

    public PreparedStatementCreatorFactory(String sql, List declaredParameters) {
        this.sql = sql;
        this.declaredParameters = declaredParameters;
    }

    public void addParameter(SqlParameter param) {
        this.declaredParameters.add(param);
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public void setUpdatableResults(boolean updatableResults) {
        this.updatableResults = updatableResults;
    }

    public void setReturnGeneratedKeys(boolean returnGeneratedKeys) {
        this.returnGeneratedKeys = returnGeneratedKeys;
    }

    public void setGeneratedKeysColumnNames(String[] names) {
        this.generatedKeysColumnNames = names;
    }

    public void setNativeJdbcExtractor(NativeJdbcExtractor nativeJdbcExtractor) {
        this.nativeJdbcExtractor = nativeJdbcExtractor;
    }

    public PreparedStatementCreator newPreparedStatementCreator(Object[] params) {
        return new PreparedStatementCreatorImpl(params != null ? Arrays.asList(params) : Collections.EMPTY_LIST);
    }

    public PreparedStatementCreator newPreparedStatementCreator(List params) {
        return new PreparedStatementCreatorImpl(params != null ? params : Collections.EMPTY_LIST);
    }

    public PreparedStatementSetter newPreparedStatementSetter(Object[] params) {
        return new PreparedStatementCreatorImpl(params != null ? Arrays.asList(params) : Collections.EMPTY_LIST);
    }

    public PreparedStatementSetter newPreparedStatementSetter(List params) {
        return new PreparedStatementCreatorImpl(params != null ? params : Collections.EMPTY_LIST);
    }

    private class PreparedStatementCreatorImpl
    implements PreparedStatementCreator,
    PreparedStatementSetter,
    SqlProvider,
    ParameterDisposer {
        private final List parameters;

        public PreparedStatementCreatorImpl(List parameters) {
            this.parameters = parameters;
            if (this.parameters.size() != PreparedStatementCreatorFactory.this.declaredParameters.size()) {
                throw new InvalidDataAccessApiUsageException("SQL=[" + PreparedStatementCreatorFactory.this.sql + "]: given " + this.parameters.size() + " parameter but expected " + PreparedStatementCreatorFactory.this.declaredParameters.size());
            }
        }

        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            PreparedStatement ps = null;
            if (PreparedStatementCreatorFactory.this.returnGeneratedKeys) {
                try {
                    if (PreparedStatementCreatorFactory.this.generatedKeysColumnNames == null) {
                        ps = con.prepareStatement(PreparedStatementCreatorFactory.this.sql, 1);
                    }
                    ps = con.prepareStatement(PreparedStatementCreatorFactory.this.sql, PreparedStatementCreatorFactory.this.generatedKeysColumnNames);
                }
                catch (AbstractMethodError ex) {
                    throw new InvalidDataAccessResourceUsageException("The JDBC driver is not compliant to JDBC 3.0 and thus does not support retrieval of auto generated keys", ex);
                }
            } else {
                ps = PreparedStatementCreatorFactory.this.resultSetType == 1003 && !PreparedStatementCreatorFactory.this.updatableResults ? con.prepareStatement(PreparedStatementCreatorFactory.this.sql) : con.prepareStatement(PreparedStatementCreatorFactory.this.sql, PreparedStatementCreatorFactory.this.resultSetType, PreparedStatementCreatorFactory.this.updatableResults ? 1008 : 1007);
            }
            this.setValues(ps);
            return ps;
        }

        public void setValues(PreparedStatement ps) throws SQLException {
            PreparedStatement psToUse = ps;
            if (PreparedStatementCreatorFactory.this.nativeJdbcExtractor != null) {
                psToUse = PreparedStatementCreatorFactory.this.nativeJdbcExtractor.getNativePreparedStatement(ps);
            }
            for (int i = 0; i < this.parameters.size(); ++i) {
                SqlParameter declaredParameter = (SqlParameter)PreparedStatementCreatorFactory.this.declaredParameters.get(i);
                Object in = this.parameters.get(i);
                int sqlColIndx = i + 1;
                StatementCreatorUtils.setParameterValue(psToUse, sqlColIndx, declaredParameter, in);
            }
        }

        public String getSql() {
            return PreparedStatementCreatorFactory.this.sql;
        }

        public void cleanupParameters() {
            StatementCreatorUtils.cleanupParameters(this.parameters);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("PreparedStatementCreatorFactory.PreparedStatementCreatorImpl: sql=[");
            buf.append(PreparedStatementCreatorFactory.this.sql);
            buf.append("]: params=[");
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(this.parameters.get(i));
            }
            return buf.toString() + "]";
        }
    }
}

