/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;
import org.dbunit.dataset.RowOutOfBoundsException;

public abstract class AbstractTable
implements ITable {
    protected void assertValidRowIndex(int row) throws DataSetException {
        this.assertValidRowIndex(row, this.getRowCount());
    }

    protected void assertValidRowIndex(int row, int rowCount) throws DataSetException {
        if (row < 0) {
            throw new RowOutOfBoundsException(row + " < 0");
        }
        if (row >= rowCount) {
            throw new RowOutOfBoundsException(row + " > " + rowCount);
        }
    }

    protected void assertValidColumn(String columnName) throws DataSetException {
        ITableMetaData metaData = this.getTableMetaData();
        if (DataSetUtils.getColumn(columnName, metaData.getColumns()) == null) {
            throw new NoSuchColumnException(metaData.getTableName() + "." + columnName);
        }
    }

    protected int getColumnIndex(String columnName) throws DataSetException {
        ITableMetaData metaData = this.getTableMetaData();
        Column[] columns = metaData.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (!column.getColumnName().equalsIgnoreCase(columnName)) continue;
            return i;
        }
        throw new NoSuchColumnException(metaData.getTableName() + "." + columnName);
    }

    public abstract /* synthetic */ Object getValue(int var1, String var2) throws DataSetException;

    public abstract /* synthetic */ int getRowCount();

    public abstract /* synthetic */ ITableMetaData getTableMetaData();
}

