/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import org.dbunit.database.IResultSetTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;

public class DatabaseTableIterator
implements ITableIterator {
    private final String[] _tableNames;
    private final IDataSet _dataSet;
    private IResultSetTable _currentTable;
    private int _index = -1;

    public DatabaseTableIterator(String[] tableNames, IDataSet dataSet) {
        this._tableNames = tableNames;
        this._dataSet = dataSet;
        this._currentTable = null;
    }

    public boolean next() throws DataSetException {
        ++this._index;
        if (this._currentTable != null) {
            this._currentTable.close();
            this._currentTable = null;
        }
        return this._index < this._tableNames.length;
    }

    public ITableMetaData getTableMetaData() throws DataSetException {
        return this._dataSet.getTableMetaData(this._tableNames[this._index]);
    }

    public ITable getTable() throws DataSetException {
        if (this._currentTable == null) {
            this._currentTable = (IResultSetTable)this._dataSet.getTable(this._tableNames[this._index]);
        }
        return this._currentTable;
    }
}

