/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Hashtable;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DescriptorHandler
extends HandlerBase {
    private static final String HOME_INTERFACE = "home";
    private static final String REMOTE_INTERFACE = "remote";
    private static final String BEAN_CLASS = "ejb-class";
    private static final String PK_CLASS = "prim-key-class";
    private String currentElement = null;
    private String currentText = null;
    private Hashtable ejbFiles = null;
    private Hashtable fileDTDs = new Hashtable();
    private Hashtable resourceDTDs = new Hashtable();
    private File srcDir;

    public DescriptorHandler(File srcDir) {
        this.srcDir = srcDir;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentText = String.valueOf(this.currentText) + new String(ch, start, length);
    }

    public void endElement(String name) throws SAXException {
        this.processElement();
        this.currentText = "";
        this.currentElement = "";
    }

    public Hashtable getFiles() {
        return this.ejbFiles == null ? new Hashtable() : this.ejbFiles;
    }

    private void processElement() {
        if (this.currentElement.equals(HOME_INTERFACE) || this.currentElement.equals(REMOTE_INTERFACE) || this.currentElement.equals(BEAN_CLASS) || this.currentElement.equals(PK_CLASS)) {
            File classFile = null;
            String className = this.currentText;
            if (!className.startsWith("java.lang")) {
                className = className.replace('.', File.separatorChar);
                className = String.valueOf(className) + ".class";
                classFile = new File(this.srcDir, className);
                this.ejbFiles.put(className, classFile);
            }
        }
    }

    public void registerFileDTD(String publicId, File dtdFile) {
        this.fileDTDs.put(publicId, dtdFile);
    }

    public void registerResourceDTD(String publicId, String resourceName) {
        this.resourceDTDs.put(publicId, resourceName);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputStream is;
        String dtdResourceName;
        File dtdFile = (File)this.fileDTDs.get(publicId);
        if (dtdFile != null && dtdFile.exists()) {
            try {
                return new InputSource(new FileInputStream(dtdFile));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        if ((dtdResourceName = (String)this.resourceDTDs.get(publicId)) != null && (is = this.getClass().getResourceAsStream(dtdResourceName)) != null) {
            return new InputSource(is);
        }
        return null;
    }

    public void startDocument() throws SAXException {
        this.ejbFiles = new Hashtable(10, 1.0f);
        this.currentElement = null;
    }

    public void startElement(String name, AttributeList attrs) throws SAXException {
        this.currentElement = name;
        this.currentText = "";
    }
}

