/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

public class Tar
extends MatchingTask {
    File tarFile;
    File baseDir;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        if (this.tarFile == null) {
            throw new BuildException("tarfile attribute must be set!", this.location);
        }
        if (this.baseDir == null) {
            throw new BuildException("basedir attribute must be set!", this.location);
        }
        if (!this.baseDir.exists()) {
            throw new BuildException("basedir does not exist!", this.location);
        }
        this.log("Building tar: " + this.tarFile.getAbsolutePath());
        DirectoryScanner ds = super.getDirectoryScanner(this.baseDir);
        String[] files = ds.getIncludedFiles();
        TarOutputStream tOut = null;
        try {
            try {
                tOut = new TarOutputStream(new FileOutputStream(this.tarFile));
                tOut.setDebug(true);
                int i = 0;
                while (i < files.length) {
                    File f = new File(this.baseDir, files[i]);
                    String name = files[i].replace(File.separatorChar, '/');
                    this.tarFile(f, tOut, name);
                    ++i;
                }
            }
            catch (IOException ioe) {
                String msg = "Problem creating TAR: " + ioe.getMessage();
                throw new BuildException(msg, ioe, this.location);
            }
            Object var5_9 = null;
            if (tOut == null) return;
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            if (tOut == null) throw throwable;
            try {
                tOut.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            tOut.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void setBasedir(String baseDirname) {
        this.baseDir = this.project.resolveFile(baseDirname);
    }

    public void setTarfile(String tarFilename) {
        this.tarFile = this.project.resolveFile(tarFilename);
    }

    protected void tarFile(File file, TarOutputStream tOut, String vPath) throws IOException {
        FileInputStream fIn = new FileInputStream(file);
        try {
            TarEntry te = new TarEntry(vPath);
            te.setSize(file.length());
            te.setModTime(file.lastModified());
            tOut.putNextEntry(te);
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                tOut.write(buffer, 0, count);
            } while ((count = fIn.read(buffer, 0, buffer.length)) != -1);
            tOut.closeEntry();
        }
        finally {
            Object var6_8 = null;
            fIn.close();
        }
    }
}

