/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.config;

import com.trs.infra.I18NMessage;
import com.trs.webframework.config.LoadingErrorReport;
import com.trs.webframework.config.ServiceListenerConfig;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ServiceListenerConfigs {
    protected static Logger logger = Logger.getLogger(ServiceListenerConfigs.class);
    private Map m_mapLiseners = null;
    private LoadingErrorReport m_oLoadingErrorReport = null;

    public ServiceListenerConfig[] findServiceListenerConfigs(String _sServiceId, String _sMethodName) {
        ArrayList arConfigsForCurrMethod;
        if (this.m_mapLiseners == null) {
            return new ServiceListenerConfig[0];
        }
        String sKey = (_sServiceId + ".*").toUpperCase();
        ArrayList arConfigsForAllMethod = (ArrayList)this.m_mapLiseners.get(sKey);
        int nSize = (arConfigsForAllMethod == null ? 0 : arConfigsForAllMethod.size()) + ((arConfigsForCurrMethod = (ArrayList)this.m_mapLiseners.get(sKey = (_sServiceId + "." + _sMethodName).toUpperCase())) == null ? 0 : arConfigsForCurrMethod.size());
        if (nSize == 0) {
            return new ServiceListenerConfig[0];
        }
        ServiceListenerConfig[] pConfigs = new ServiceListenerConfig[nSize];
        int nDestPos = 0;
        if (arConfigsForAllMethod != null) {
            System.arraycopy(arConfigsForAllMethod.toArray(), 0, pConfigs, nDestPos, arConfigsForAllMethod.size());
            nDestPos = arConfigsForAllMethod.size();
        }
        if (arConfigsForCurrMethod != null) {
            System.arraycopy(arConfigsForCurrMethod.toArray(), 0, pConfigs, nDestPos, arConfigsForCurrMethod.size());
        }
        return pConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFromFile(String _sServiceIdPre, String _sConfigFile) {
        if (this.m_mapLiseners == null) {
            ServiceListenerConfigs serviceListenerConfigs = this;
            synchronized (serviceListenerConfigs) {
                if (this.m_mapLiseners == null) {
                    this.m_mapLiseners = new Hashtable(4);
                }
            }
        }
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(_sConfigFile);
            Element root = document.getRootElement();
            Iterator i = root.elementIterator("service-listener");
            while (i.hasNext()) {
                String sMethodName;
                Element elListener = (Element)i.next();
                String sServiceId = elListener.attributeValue("service");
                if (sServiceId == null || (sServiceId = sServiceId.trim()).length() == 0) continue;
                if (sServiceId.indexOf(95) < 0) {
                    sServiceId = _sServiceIdPre + "_" + sServiceId;
                }
                if ((sMethodName = elListener.attributeValue("method")) == null || (sMethodName = sMethodName.trim()).length() == 0) {
                    sMethodName = "*";
                }
                try {
                    ServiceListenerConfig serviceListenerConfig = new ServiceListenerConfig(sServiceId, sMethodName, elListener.attributeValue("class"));
                    String sKey = (sServiceId + "." + sMethodName).toUpperCase();
                    ArrayList<ServiceListenerConfig> arListeners = (ArrayList<ServiceListenerConfig>)this.m_mapLiseners.get(sKey);
                    if (arListeners == null) {
                        arListeners = new ArrayList<ServiceListenerConfig>(1);
                        this.m_mapLiseners.put(sKey, arListeners);
                    }
                    arListeners.add(serviceListenerConfig);
                    List lAttributes = elListener.attributes();
                    int nSize = lAttributes.size();
                    for (int j = 0; j < nSize; ++j) {
                        Attribute attr = (Attribute)lAttributes.get(j);
                        if (attr == null) continue;
                        serviceListenerConfig.setParameter(attr.getName(), attr.getValue());
                    }
                }
                catch (Throwable ex) {
                    String sErrorInfo = I18NMessage.get(ServiceListenerConfigs.class, "ServiceListenerConfigs.label1", "\u6587\u4ef6[") + _sConfigFile + I18NMessage.get(ServiceListenerConfigs.class, "ServiceListenerConfigs.label2", "]\u4e2dListener\u7684\u914d\u7f6e\u4fe1\u606f\u8bbe\u7f6e\u9519\u8bef\uff01\u5185\u5bb9\u4e3a\uff1a") + elListener.asXML();
                    logger.error((Object)sErrorInfo, ex);
                    if (this.m_oLoadingErrorReport == null) {
                        this.m_oLoadingErrorReport = new LoadingErrorReport();
                    }
                    this.m_oLoadingErrorReport.add(sErrorInfo, ex);
                }
            }
        }
        catch (DocumentException ex) {
            logger.error((Object)(I18NMessage.get(ServiceListenerConfigs.class, "ServiceListenerConfigs.label3", "\u89e3\u6790ServiceListener\u914d\u7f6e\u6587\u4ef6[") + _sConfigFile + I18NMessage.get(ServiceListenerConfigs.class, "ServiceListenerConfigs.label4", "]\u5931\u8d25!")), (Throwable)ex);
            this.m_oLoadingErrorReport = new LoadingErrorReport(I18NMessage.get(ServiceListenerConfigs.class, "ServiceListenerConfigs.label3", "\u89e3\u6790ServiceListener\u914d\u7f6e\u6587\u4ef6[") + _sConfigFile + I18NMessage.get(ServiceListenerConfigs.class, "ServiceListenerConfigs.label4", "]\u5931\u8d25!"), ex);
        }
    }

    public LoadingErrorReport getLoadingErrorReport() {
        return this.m_oLoadingErrorReport;
    }
}

