/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;
import com.trs.webframework.AbstractLogger;
import com.trs.webframework.DefaultSaveLogger;
import com.trs.webframework.ServiceExcuteLogger;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.context.MethodContext;
import org.apache.log4j.Logger;

public class DefaultDeleteLogger
extends AbstractLogger
implements ServiceExcuteLogger {
    private static final Logger LOG = Logger.getLogger(DefaultSaveLogger.class);
    private static final int COUNT_PER_SAVE = 5;

    @Override
    public int startLog(MethodConfig _methodConf, MethodContext _methodContext) {
        try {
            String sKlassName = _methodConf.getLogObjClassName();
            if (CMyString.isEmpty(sKlassName)) {
                LOG.warn((Object)"no objklass provide ,execute log fail!");
                return 0;
            }
            Class<?> clazz = Class.forName(sKlassName);
            if (!CMSOBJS_KLASS.isAssignableFrom(clazz) && !CMSOBJS_KLASS.isAssignableFrom(clazz = Class.forName(sKlassName + "s"))) {
                LOG.warn((Object)"only log cmsobjs delete execute default");
                return 0;
            }
            String sIds = _methodContext.getValue("ObjectIds");
            if (CMyString.isEmpty(sIds)) {
                sIds = _methodContext.getValue("ObjectId");
            }
            if (CMyString.isEmpty(sIds)) {
                LOG.warn((Object)"Not default delete execute.");
                return 0;
            }
            User user = ContextHelper.getLoginUser();
            CMSBaseObjs logobjs = CMSBaseObjs.findWCMObjsByIds(user, clazz, sIds);
            if (logobjs.isEmpty()) {
                return 0;
            }
            StringBuffer buff = new StringBuffer(128);
            int size = logobjs.size();
            BaseObj logobj = null;
            for (int i = 0; logobj == null && i < size; ++i) {
                logobj = logobjs.getAt(i);
            }
            if (logobj == null) {
                return 0;
            }
            if (size > 1) {
                buff.append("\u6279\u91cf");
            }
            if (_methodContext.getValue("Drop", false)) {
                buff.append(I18NMessage.get(DefaultDeleteLogger.class, "DefaultDeleteLogger.label2", "\u5f7b\u5e95"));
            }
            buff.append(I18NMessage.get(DefaultDeleteLogger.class, "DefaultDeleteLogger.label3", "\u5220\u9664"));
            if (size > 1) {
                buff.append(WCMTypes.getObjName(logobj.getWCMType(), true));
                buff.append("Ids=").append(sIds);
            } else {
                buff.append(logobj);
            }
            return this.log(_methodConf, buff.toString(), logobj);
        }
        catch (Exception e) {
            LOG.error((Object)"execute log fail", (Throwable)e);
            return 0;
        }
    }

    @Override
    public String getClassDesc() {
        return "\u7cfb\u7edf\u9ed8\u8ba4\u5220\u9664\u64cd\u4f5c\u65e5\u5fd7\u7c7b";
    }
}

