/*
 * Decompiled with CFR 0.152.
 */
package com.trs.template.service.impl;

import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.persistent.template.TempAppendix;
import com.trs.components.common.publish.persistent.template.TempAppendixes;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.jazzlib.DeflaterOutputStream;
import com.trs.infra.util.jazzlib.ZipEntry;
import com.trs.infra.util.jazzlib.ZipOutputStream;
import com.trs.infra.util.store.FileService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;

class Exporter {
    private static final String IMG_DIR = "images/";
    private static final int BUFFER_LENGTH = 10240;
    private User user = null;

    public Exporter(User loginUser) {
        this.user = loginUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] export(Template template) throws Exception {
        DeflaterOutputStream zos = null;
        FileOutputStream fos = null;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream(10240);
            zos = new ZipOutputStream(baos);
            ((ZipOutputStream)zos).setEncoding("GBK");
            ((ZipOutputStream)zos).setMethod(8);
            String dir = this.makeDir(template);
            String imgpre = "./images/";
            String content = template.getTextWithImgFilter(imgpre, true, false);
            String filename = template.getName();
            String ext = template.getOutputFileExt();
            if (!CMyString.isEmpty(ext)) {
                filename = filename + "." + ext;
            }
            ZipEntry ze = new ZipEntry(dir + filename);
            ze.setMethod(8);
            byte[] data = content.getBytes(template.getCharSet());
            ze.setSize(data.length);
            ((ZipOutputStream)zos).putNextEntry(ze);
            zos.write(data);
            TempAppendixes appendixes = template.getAppendixes(this.user);
            if (appendixes != null && !appendixes.isEmpty()) {
                String imgdir = dir + IMG_DIR;
                ze = new ZipEntry(imgdir);
                ze.setMethod(8);
                ze.setSize(0L);
                ((ZipOutputStream)zos).putNextEntry(ze);
                FilesMan fileman = FilesMan.getFilesMan();
                String localPath = fileman.getTemplateAppendixPath(template.getRootType(), template.getRootId(), 0, true);
                for (int i = 0; i < appendixes.size(); ++i) {
                    FileService file;
                    TempAppendix appendix = (TempAppendix)appendixes.getAt(i);
                    if (appendix == null || !(file = new FileService(localPath, appendix.getFile())).exists()) continue;
                    ze = new ZipEntry(imgdir + appendix.getFile());
                    ze.setMethod(8);
                    ze.setSize(file.length());
                    ((ZipOutputStream)zos).putNextEntry(ze);
                    InputStream fins = null;
                    try {
                        fins = file.getInputStream();
                        byte[] buff = new byte[10240];
                        int len = -1;
                        while ((len = fins.read(buff)) != -1) {
                            ((ZipOutputStream)zos).write(buff, 0, len);
                        }
                        zos.flush();
                        continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    finally {
                        if (fins != null) {
                            try {
                                fins.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
            zos.flush();
            ((ZipOutputStream)zos).finish();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String makeDir(Template template) throws WCMException {
        int folderType = template.getFolderType();
        if (folderType == 103) {
            return "";
        }
        ArrayList<String> names = new ArrayList<String>(4);
        Channel channel = Channel.findById(template.getFolderId());
        names.add(channel.getName());
        for (Channel parent = channel.getParent(); parent != null; parent = parent.getParent()) {
            names.add(parent.getName());
        }
        StringBuffer buff = new StringBuffer(128);
        for (int i = names.size() - 1; i >= 0; --i) {
            buff.append(names.get(i));
            buff.append(File.separator);
        }
        names.clear();
        return buff.toString();
    }
}

