/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.service.ISearcherService;
import com.trs.service.impl.SearcherTool;
import com.trs.webframework.context.MethodContext;
import java.util.ArrayList;

public class SearchBySqlService
implements ISearcherService {
    @Override
    public ViewDocuments search(MethodContext _methContext) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        boolean bInChannelsHost = _methContext.getValue("bInChannelsHost", false);
        CMSBaseObjs objects = (CMSBaseObjs)_methContext.getObjectValue("objects");
        Channels oQueryChannels = (Channels)_methContext.getObjectValue("oQueryChannels");
        ViewDocuments viewDocuments = new ViewDocuments(loginUser, 1, 1);
        try {
            WCMFilter filter = SearcherTool.getFilterFromList(_methContext, objects);
            WCMFilter extendFilter = SearcherTool.getFilterForCopyOnly(_methContext);
            filter.mergeWith(extendFilter);
            SearcherTool.filterForUser(_methContext, loginUser, extendFilter, oQueryChannels);
            if (oQueryChannels == null) {
                return null;
            }
            String sChannelId = _methContext.getValue("ChannelId");
            String sDBFields = "";
            if (!CMyString.isEmpty(sChannelId)) {
                sDBFields = SearcherTool.makeSelectFields(_methContext);
            }
            if (CMyString.isEmpty(sDBFields)) {
                viewDocuments.setSelectFields(_methContext.getValue("ChnlDocSelectFields"), _methContext.getValue("DocumentSelectFields"));
            } else {
                ArrayList<String> aChnldocList = new ArrayList<String>();
                ArrayList<String> aDocList = new ArrayList<String>();
                String[] sFields = sDBFields.split(",");
                for (int i = 0; i < sFields.length; ++i) {
                    if (sFields[i].toUpperCase().indexOf("WCMCHNLDOC.") > -1) {
                        aChnldocList.add(sFields[i]);
                        continue;
                    }
                    if (sFields[i].toUpperCase().indexOf("WCMDOCUMENT.") <= -1) continue;
                    aDocList.add(sFields[i]);
                }
                String sChnlDocFields = aChnldocList.toString();
                sChnlDocFields = sChnlDocFields.substring(1, sChnlDocFields.length() - 1);
                String sDocFields = aDocList.toString();
                sDocFields = sDocFields.substring(1, sDocFields.length() - 1);
                viewDocuments.setSelectFields(sChnlDocFields, sDocFields);
            }
            viewDocuments.setPageSize(_methContext.getPageSize());
            viewDocuments.setCurrPage(_methContext.getPageIndex());
            viewDocuments.setRightIndex(64);
            viewDocuments.setNeedWithAuthFilter(loginUser, true);
            if (bInChannelsHost) {
                viewDocuments.open(oQueryChannels, filter);
            } else if (loginUser.isAdministrator()) {
                viewDocuments.open(objects, filter);
            } else {
                viewDocuments.open(oQueryChannels, filter);
            }
            return viewDocuments;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("NumberFormatException\uff0c\u6570\u5b57\u7c7b\u578b\u8f6c\u5316\u9519\u8bef" + e.getMessage());
        }
        catch (WCMException e) {
            throw new WCMException("viewDocuments\uff0c\u5f00\u96c6\u5408\u5f02\u5e38", e);
        }
        catch (Exception e) {
            throw new WCMException("\u83b7\u53d6filter\u8fc7\u6ee4\u4fe1\u606f\u6709\u8bef", e);
        }
    }
}

