/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scene.tools;

import com.trs.scene.tools.SceneNode;
import java.util.ArrayList;

public class SceneNodeAction {
    private ArrayList m_arrLeafNodes = new ArrayList();
    private ArrayList m_arrAllNodes = new ArrayList();

    public SceneNodeAction(SceneNode _root) {
        this.getTraverseNodes(_root);
        this.getNodes(_root);
        this.confirmPosition(_root);
    }

    public ArrayList getAllNodes() {
        return this.m_arrAllNodes;
    }

    public void confirmPosition(SceneNode _root) {
        this.confirmPositionX(_root);
        this.confirmPositionY(_root);
    }

    public void confirmPositionX(SceneNode _root) {
        int i;
        for (i = 0; i < this.m_arrLeafNodes.size(); ++i) {
            SceneNode oNode = (SceneNode)this.m_arrLeafNodes.get(i);
            oNode.setPositionX(i * 100);
        }
        for (i = this.m_arrAllNodes.size() - 2; i >= 0; --i) {
            ArrayList arrList = (ArrayList)this.m_arrAllNodes.get(i);
            for (int j = 0; j < arrList.size(); ++j) {
                SceneNode oChildNode = (SceneNode)arrList.get(j);
                int nPositionX = this.getParentX(oChildNode);
                oChildNode.setPositionX(nPositionX);
            }
        }
    }

    public int getParentX(SceneNode _parentNode) {
        ArrayList arrList = _parentNode.getChildren();
        if (arrList == null) {
            return _parentNode.getPositionX();
        }
        int nLen = arrList.size();
        int nPositionX = 0;
        SceneNode oFirstChildNode = (SceneNode)arrList.get(0);
        SceneNode oLastChildNode = (SceneNode)arrList.get(nLen - 1);
        nPositionX = (oFirstChildNode.getPositionX() + oLastChildNode.getPositionX()) / 2;
        return nPositionX;
    }

    public void confirmPositionY(SceneNode _root) {
        if (this.m_arrAllNodes == null) {
            return;
        }
        for (int i = 0; i < this.m_arrAllNodes.size(); ++i) {
            ArrayList arrList = (ArrayList)this.m_arrAllNodes.get(i);
            for (int j = 0; j < arrList.size(); ++j) {
                SceneNode oNode = (SceneNode)arrList.get(j);
                if (oNode.getType() == 3) {
                    oNode.setPositionY(120 * (i + 1) / 2);
                    continue;
                }
                oNode.setPositionY(120 * i / 2);
            }
        }
    }

    public void getTraverseNodes(SceneNode _root) {
        if (_root == null) {
            return;
        }
        ArrayList arrList = _root.getChildren();
        if (arrList == null) {
            this.m_arrLeafNodes.add(_root);
            return;
        }
        for (int i = 0; i < arrList.size(); ++i) {
            this.getTraverseNodes((SceneNode)arrList.get(i));
        }
    }

    public void getNodes(SceneNode _root) {
        this.m_arrAllNodes.clear();
        if (_root == null) {
            return;
        }
        ArrayList arrLevelNodes = new ArrayList();
        arrLevelNodes.add(_root);
        this.m_arrAllNodes.add(arrLevelNodes);
        ArrayList arrChildrenNodes = this.getChilrenNodes(arrLevelNodes);
        while (!arrChildrenNodes.isEmpty()) {
            arrLevelNodes = arrChildrenNodes;
            this.m_arrAllNodes.add(arrLevelNodes);
            arrChildrenNodes = this.getChilrenNodes(arrLevelNodes);
        }
    }

    public ArrayList getChilrenNodes(ArrayList _arrLevelNodes) {
        ArrayList arrLevelList = new ArrayList();
        for (int i = 0; i < _arrLevelNodes.size(); ++i) {
            SceneNode node = (SceneNode)_arrLevelNodes.get(i);
            if (node.getChildren() == null) continue;
            arrLevelList.addAll(node.getChildren());
        }
        return arrLevelList;
    }
}

