/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.dbcompare;

import com.trs.infra.util.upgrade.dbcompare.Column;
import com.trs.infra.util.upgrade.dbcompare.Table;
import com.trs.infra.util.upgrade.dbcompare.TypeInfoMap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetaDataLoader {
    private Map tables;
    private List indexes;
    private String schema;
    private Connection conn;
    private boolean loaded;

    public MetaDataLoader(Connection conn, String schema) {
        this.schema = schema;
        this.conn = conn;
        this.tables = new HashMap(160, 0.1f);
    }

    public Map getTables() {
        return this.tables;
    }

    public void setTables(Map tables) {
        this.tables = tables;
    }

    public List getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List indexes) {
        this.indexes = indexes;
    }

    public void load() throws SQLException {
        if (!this.loaded) {
            this.loadTypeInfos();
            this.loadTables();
            this.loaded = true;
        }
    }

    protected void loadTypeInfos() throws SQLException {
        String dbtype = this.conn.getMetaData().getDatabaseProductName();
        dbtype = (dbtype = dbtype.toLowerCase()).indexOf("microsoft") != -1 ? "mssql" : (dbtype.indexOf("oracle") != -1 ? "oracle" : (dbtype.indexOf("db2") != -1 ? "db2" : "sybase"));
        TypeInfoMap.load(dbtype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadTables() throws SQLException {
        DatabaseMetaData dbMetaData = this.conn.getMetaData();
        try (ResultSet rstabs = null;){
            rstabs = dbMetaData.getTables(null, this.schema, null, new String[]{"TABLE"});
            int order = 1;
            while (rstabs.next()) {
                String tableName = rstabs.getString(3).toUpperCase();
                Table table = new Table(tableName);
                ResultSet columns = dbMetaData.getColumns(null, this.schema, tableName, null);
                while (columns.next()) {
                    String name = columns.getString("COLUMN_NAME");
                    String typeName = columns.getString("TYPE_NAME");
                    int type = columns.getInt("DATA_TYPE");
                    Column column = new Column(name, type, typeName);
                    column.length = columns.getInt("COLUMN_SIZE");
                    if (1 == columns.getInt("NULLABLE")) {
                        column.nullAble = true;
                    }
                    column.defaultValue = columns.getString("COLUMN_DEF");
                    column.scale = columns.getInt("DECIMAL_DIGITS");
                    column.order = order++;
                    table.addColumn(column);
                }
                columns.close();
                ResultSet pks = dbMetaData.getPrimaryKeys(null, this.schema, tableName);
                StringBuffer buff = new StringBuffer(128);
                while (pks.next()) {
                    buff.append(',');
                    buff.append(pks.getString("COLUMN_NAME"));
                }
                if (buff.length() > 1) {
                    table.setPrimaryKey(buff.substring(1).split(","));
                }
                this.tables.put(tableName, table);
            }
        }
    }
}

