/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.email;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.email.CMyEmail;
import com.trs.infra.util.email.CMyMailException;
import com.trs.infra.util.email.CMyMailLog;
import com.trs.infra.util.email.CMySMTPServer;
import com.trs.infra.util.email.MIMEBase64;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.soap.encoding.soapenc.Base64;

public class TRSMailer {
    private static Logger s_logger = Logger.getLogger(TRSMailer.class);
    private static final int DISABLE_SOCKET_TIME_OUT = -1;
    private int m_nSocketTimeOut = -1;
    private CMyMailLog mailLog = new CMyMailLog();

    public TRSMailer() {
        this.disableSocketTimeOut();
    }

    public void setSocketTimeOut(int socketTimeOut) {
        this.m_nSocketTimeOut = socketTimeOut;
    }

    public void disableSocketTimeOut() {
        this.setSocketTimeOut(-1);
    }

    public int getSocketTimeOut() {
        return this.m_nSocketTimeOut;
    }

    public CMyMailLog getMailLog() {
        return this.mailLog;
    }

    public String getMailLogString() {
        return this.mailLog.getLog();
    }

    public boolean send(CMyEmail _currMail) throws CMyMailException {
        return this.send(_currMail, CMySMTPServer.getDefaultSMTPServer());
    }

    public boolean send(final CMyEmail _currMail, final CMySMTPServer _currSmtpServer) {
        new Thread(){

            @Override
            public void run() {
                try {
                    TRSMailer.this.send0(_currMail, _currSmtpServer);
                }
                catch (CMyMailException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        return true;
    }

    public boolean send0(CMyEmail _currMail, CMySMTPServer _currSmtpServer) throws CMyMailException {
        if (_currSmtpServer == null) {
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label1", "\u90ae\u4ef6\u670d\u52a1\u5668\u6ca1\u6709\u8bbe\u7f6e\uff08\u4e3a\u7a7a\uff09\uff0c\u65e0\u6cd5\u53d1\u9001\u90ae\u4ef6\uff01"));
        }
        _currSmtpServer.validate();
        if (_currMail == null) {
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label2", "\u90ae\u4ef6\u6ca1\u6709\u8bbe\u7f6e\uff08\u4e3a\u7a7a\uff09\uff0c\u65e0\u6cd5\u53d1\u9001\uff01"));
        }
        _currMail.validate();
        this.mailLog.appendSendLogs("---- TRS Mailer: send begin@" + CMyDateTime.now().toString() + " ----");
        Socket socket = null;
        BufferedWriter out = null;
        BufferedReader in = null;
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label3", "---- \u5f00\u59cb\u5efa\u7acb\u8fde\u63a5 ----"));
        try {
            socket = _currSmtpServer.createSocket();
            out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "GBK"));
            in = new BufferedReader(new InputStreamReader(socket.getInputStream(), "GBK"));
            this.mailLog.recordSendLogs(this.getResponse(in), 2);
        }
        catch (Exception ex) {
            this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label4", "\u8fde\u63a5\u90ae\u4ef6\u670d\u52a1\u5668") + _currSmtpServer.toString() + I18NMessage.get(TRSMailer.class, "TRSMailer.label5", "\u65f6\u53d1\u751f\u9519\u8bef\uff01") + ex.toString());
            this.closeSocket(socket, out, in);
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label4", "\u8fde\u63a5\u90ae\u4ef6\u670d\u52a1\u5668") + _currSmtpServer.toString() + I18NMessage.get(TRSMailer.class, "TRSMailer.label5", "\u65f6\u53d1\u751f\u9519\u8bef\uff01") + ex.toString());
        }
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label6", "---- \u8fde\u63a5\u6210\u529f ----"));
        this.setSocketTimeOut(socket, this.getSocketTimeOut());
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label7", "---- \u5f00\u59cb\u9a8c\u8bc1\u90ae\u4ef6\u670d\u52a1\u5668 ----"));
        try {
            if (_currSmtpServer.needAuth()) {
                if (!_currSmtpServer.canAuth()) {
                    this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label8", "\u90ae\u4ef6\u670d\u52a1\u5668\u9700\u8981\u8eab\u4efd\u9a8c\u8bc1\uff0c\u4f46\u662f\u9a8c\u8bc1\u53c2\u6570\u4e0d\u8db3\uff0c\u65e0\u6cd5\u9a8c\u8bc1\uff01"));
                    return false;
                }
                this.sendMailBuffer(in, out, "EHLO " + _currSmtpServer.getServerName(), I18NMessage.get(TRSMailer.class, "TRSMailer.label9", "\u9a8c\u8bc1\u670d\u52a1\u5668EHLO\u63e1\u624b\u65f6\u5931\u8d25\uff01"));
                this.sendMailBuffer(in, out, "AUTH LOGIN", I18NMessage.get(TRSMailer.class, "TRSMailer.label10", "\u9a8c\u8bc1\u670d\u52a1\u5668\u53d1\u9001\u8ba4\u8bc1\u8bf7\u6c42AUTH LOGIN\u547d\u4ee4\u65f6\u5931\u8d25\uff01"));
                this.sendMailBuffer(in, out, new String(Base64.encode((byte[])_currSmtpServer.getUserName().getBytes())), I18NMessage.get(TRSMailer.class, "TRSMailer.label11", "\u9a8c\u8bc1\u670d\u52a1\u5668\u53d1\u9001\u9a8c\u8bc1\u7528\u6237\u540d\u65f6\u5931\u8d25\uff01"));
                this.sendMailBuffer(in, out, new String(Base64.encode((byte[])_currSmtpServer.getPassword().getBytes())), I18NMessage.get(TRSMailer.class, "TRSMailer.label12", "\u9a8c\u8bc1\u7528\u6237\u5bc6\u7801\u65f6\u5931\u8d25\uff01"));
            } else {
                this.sendMailBuffer(in, out, "HELO " + _currSmtpServer.getServerName(), I18NMessage.get(TRSMailer.class, "TRSMailer.label13", "\u9a8c\u8bc1\u670d\u52a1\u5668HELO\u63e1\u624b\u65f6\u5931\u8d25"));
            }
        }
        catch (Exception ex) {
            this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label14", "\u9a8c\u8bc1\u90ae\u4ef6\u670d\u52a1\u5668") + _currSmtpServer.toString() + I18NMessage.get(TRSMailer.class, "TRSMailer.label5", "\u65f6\u53d1\u751f\u9519\u8bef\uff01") + ex.toString());
            this.closeSocket(socket, out, in);
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label14", "\u9a8c\u8bc1\u90ae\u4ef6\u670d\u52a1\u5668") + _currSmtpServer.toString() + I18NMessage.get(TRSMailer.class, "TRSMailer.label5", "\u65f6\u53d1\u751f\u9519\u8bef\uff01") + ex.toString());
        }
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label15", "---- \u9a8c\u8bc1\u90ae\u4ef6\u670d\u52a1\u5668\u6210\u529f ----"));
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label16", "---- \u5f00\u59cb\u53d1\u9001\u90ae\u4ef6\u53d1\u4ef6\u4eba\u548c\u6536\u4ef6\u4eba\u4fe1\u606f ----"));
        try {
            String sOneUser;
            try {
                this.sendMailBuffer(in, out, "MAIL FROM: <" + _currMail.getFrom() + ">", I18NMessage.get(TRSMailer.class, "TRSMailer.label17", "\u53d1\u9001\u90ae\u4ef6\u65f6\u53d1\u4ef6\u4eba\uff08") + _currMail.getFrom() + I18NMessage.get(TRSMailer.class, "TRSMailer.label18", "\uff09\u65e0\u6548\uff01"));
            }
            catch (CMyMailException ex) {
                s_logger.debug((Object)I18NMessage.get(TRSMailer.class, "TRSMailer.label19", "\u53d1\u9001\u90ae\u4ef6\u65f6\u53d1\u4ef6\u4eba\u65e0\u6548\uff0c\u5c1d\u8bd5\u91c7\u7528\u7cfb\u7edf\u7528\u6237\u53d1\u9001\uff01"));
                String sMailUser = _currSmtpServer.getUserName() + "@" + _currSmtpServer.getServerName();
                try {
                    this.sendMailBuffer(in, out, "MAIL FROM: <" + sMailUser + ">", I18NMessage.get(TRSMailer.class, "TRSMailer.label20", "\u53d1\u9001\u90ae\u4ef6\u65f6\u7cfb\u7edf\u9ed8\u8ba4\u53d1\u4ef6\u4eba\uff08") + sMailUser + I18NMessage.get(TRSMailer.class, "TRSMailer.label18", "\uff09\u65e0\u6548\uff01"));
                }
                catch (CMyMailException ex2) {
                    s_logger.debug((Object)I18NMessage.get(TRSMailer.class, "TRSMailer.label21", "\u5c1d\u8bd5\u7b2c\u4e00\u79cd\u7cfb\u7edf\u9ed8\u8ba4\u53d1\u4ef6\u4eba\u65e0\u6548\uff0c\u5c1d\u8bd5\u91c7\u7528\u7b2c\u4e8c\u79cd\u7cfb\u7edf\u9ed8\u8ba4\u53d1\u4ef6\u4eba\u53d1\u9001\uff01"));
                    sMailUser = _currSmtpServer.getUserName();
                    this.sendMailBuffer(in, out, "MAIL FROM: <" + sMailUser + ">", I18NMessage.get(TRSMailer.class, "TRSMailer.label22", "\u518d\u6b21\u53d1\u9001\u90ae\u4ef6\u65f6\u7cfb\u7edf\u9ed8\u8ba4\u53d1\u4ef6\u4eba\uff08") + sMailUser + I18NMessage.get(TRSMailer.class, "TRSMailer.label18", "\uff09\u65e0\u6548\uff01"));
                }
            }
            String sReceivers = _currMail.getTo();
            StringTokenizer stReceivers = new StringTokenizer(sReceivers, ";");
            while (stReceivers.hasMoreTokens()) {
                sOneUser = stReceivers.nextToken();
                try {
                    this.sendMailBuffer(in, out, "RCPT TO: <" + sOneUser + ">", I18NMessage.get(TRSMailer.class, "TRSMailer.label23", "\u53d1\u9001\u4eba\u3010") + sOneUser + I18NMessage.get(TRSMailer.class, "TRSMailer.label24", "\u3011\u65e0\u6548"));
                }
                catch (CMyMailException ex) {
                    s_logger.error((Object)(I18NMessage.get(TRSMailer.class, "TRSMailer.label25", "\u53d1\u9001\u90ae\u4ef6\u65f6\uff0c\u6709\u4e00\u4e2a\u6536\u4ef6\u4eba\u3010") + sOneUser + I18NMessage.get(TRSMailer.class, "TRSMailer.label24", "\u3011\u65e0\u6548")));
                }
            }
            sReceivers = _currMail.getCc();
            if (sReceivers != null && sReceivers.trim().length() > 0) {
                stReceivers = new StringTokenizer(sReceivers, ";");
                while (stReceivers.hasMoreTokens()) {
                    sOneUser = stReceivers.nextToken();
                    try {
                        this.sendMailBuffer(in, out, "RCPT TO: <" + sOneUser + ">", I18NMessage.get(TRSMailer.class, "TRSMailer.label26", "\u8f6c\u53d1\u4eba\u3010") + sOneUser + I18NMessage.get(TRSMailer.class, "TRSMailer.label24", "\u3011\u65e0\u6548"));
                    }
                    catch (CMyMailException ex) {
                        ex.printStackTrace();
                        s_logger.error((Object)(I18NMessage.get(TRSMailer.class, "TRSMailer.label27", "\u53d1\u9001\u90ae\u4ef6\u65f6\uff0c\u6709\u4e00\u4e2a\u8f6c\u53d1\u4eba\u3010") + sOneUser + I18NMessage.get(TRSMailer.class, "TRSMailer.label24", "\u3011\u65e0\u6548")));
                    }
                }
            }
            if ((sReceivers = _currMail.getBcc()) != null && sReceivers.length() > 0) {
                stReceivers = new StringTokenizer(sReceivers, ";");
                while (stReceivers.hasMoreTokens()) {
                    sOneUser = stReceivers.nextToken();
                    try {
                        this.sendMailBuffer(in, out, "RCPT TO: <" + sOneUser + ">", I18NMessage.get(TRSMailer.class, "TRSMailer.label28", "\u5bc6\u9001\u4eba\u3010") + sOneUser + I18NMessage.get(TRSMailer.class, "TRSMailer.label24", "\u3011\u65e0\u6548"));
                    }
                    catch (CMyMailException ex) {
                        s_logger.error((Object)I18NMessage.get(TRSMailer.class, "TRSMailer.label29", "\u53d1\u9001\u90ae\u4ef6\u65f6\uff0c\u6709\u4e00\u4e2a\u5bc6\u9001\u4eba\u65e0\u6548"));
                    }
                }
            }
        }
        catch (Exception ex) {
            this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label30", "\u53d1\u9001\u90ae\u4ef6\u53d1\u4ef6\u4eba\u548c\u6536\u4ef6\u4eba\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef\uff01") + ex.toString());
            this.closeSocket(socket, out, in);
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label30", "\u53d1\u9001\u90ae\u4ef6\u53d1\u4ef6\u4eba\u548c\u6536\u4ef6\u4eba\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef\uff01") + ex.toString());
        }
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label31", "---- \u53d1\u9001\u90ae\u4ef6\u53d1\u4ef6\u4eba\u548c\u6536\u4ef6\u4eba\u4fe1\u606f\u6210\u529f ----"));
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label32", "---- \u5f00\u59cb\u53d1\u9001\u90ae\u4ef6\u6b63\u6587 ----"));
        try {
            this.sendMailBuffer(in, out, "DATA", I18NMessage.get(TRSMailer.class, "TRSMailer.label33", "\u53d1\u9001\u90ae\u4ef6\u6b63\u6587\u65f6\uff0c\u547d\u4ee4DATA\u65e0\u6548\uff01"));
            this.setSocketTimeOut(socket, 0);
            this.sendBuffer(out, _currMail.composeMail());
            HashMap hAttachedFileList = _currMail.getAttatchedFileList();
            if (hAttachedFileList != null && hAttachedFileList.size() > 0) {
                for (String sSrcFileName : hAttachedFileList.keySet()) {
                    this.sendFiles(sSrcFileName, (String)hAttachedFileList.get(sSrcFileName), out);
                }
                this.sendBuffer(out, CMyEmail.getMailEnd());
            }
        }
        catch (CMyMailException ex) {
            this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label34", "\u53d1\u9001\u90ae\u4ef6\u6b63\u6587\u65f6\u53d1\u751f\u9519\u8bef\uff01") + ex.toString());
            this.closeSocket(socket, out, in);
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label34", "\u53d1\u9001\u90ae\u4ef6\u6b63\u6587\u65f6\u53d1\u751f\u9519\u8bef\uff01") + ex.toString());
        }
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label35", "---- \u53d1\u9001\u90ae\u4ef6\u6b63\u6587\u6210\u529f ----"));
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label36", "---- \u5f00\u59cb\u53d1\u9001\u90ae\u4ef6\u7ed3\u675f\u6807\u5fd7 ----"));
        try {
            this.setSocketTimeOut(this.getSocketTimeOut());
            this.sendBuffer(out, "");
            this.sendMailBuffer(in, out, ".", I18NMessage.get(TRSMailer.class, "TRSMailer.label37", "\u53d1\u9001\u6b63\u6587\u7ed3\u675f\u7b26.\u65f6\u53d1\u751f\u9519\u8bef\uff01"));
            this.sendMailBuffer(in, out, "QUIT", I18NMessage.get(TRSMailer.class, "TRSMailer.label38", "\u53d1\u9001\u90ae\u4ef6\u7ed3\u675f\u6807\u5fd7\u547d\u4ee4QUIT\u65f6\u53d1\u751f\u9519\u8bef\uff01"));
        }
        catch (CMyMailException ex) {
            ex.printStackTrace();
            this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label39", "\u53d1\u9001\u90ae\u4ef6\u7ed3\u675f\u6807\u5fd7\u65f6\u53d1\u751f\u9519\u8bef\uff01") + ex.toString());
            this.closeSocket(socket, out, in);
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label39", "\u53d1\u9001\u90ae\u4ef6\u7ed3\u675f\u6807\u5fd7\u65f6\u53d1\u751f\u9519\u8bef\uff01") + ex.toString());
        }
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label40", "---- \u53d1\u9001\u90ae\u4ef6\u7ed3\u675f\u6807\u5fd7\u6210\u529f----"));
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label41", "---- \u5f00\u59cb\u5173\u95ed\u8fde\u63a5 ----"));
        this.closeSocket(socket, out, in);
        this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label42", "---- \u5173\u95ed\u8fde\u63a5\u6210\u529f ----"));
        this.mailLog.appendSendLogs("---- TRS Mailer: send end@" + CMyDateTime.now().toString() + " ----");
        return true;
    }

    private String getResponse(BufferedReader _in) {
        String sResponse = "";
        try {
            String sOneLine = _in.readLine();
            while (!this.isResponseEof(sOneLine)) {
                sResponse = sResponse + sOneLine + "\r\n";
                sOneLine = _in.readLine();
            }
            sResponse = sResponse + sOneLine;
        }
        catch (Exception e) {
            sResponse = sResponse + I18NMessage.get(TRSMailer.class, "TRSMailer.label43", "\u8bfb\u8d85\u65f6...\u3010") + e.toString() + "\u3011\r\n";
        }
        return sResponse;
    }

    private boolean isResponseEof(String _sResponseLine) {
        if (_sResponseLine == null || _sResponseLine.trim().length() < 4) {
            s_logger.debug((Object)I18NMessage.get(TRSMailer.class, "TRSMailer.label44", "\u63a5\u6536\u5230\u672a\u77e5\u7684\u56de\u7b54\uff0c\u7ed3\u675f\u5904\u7406\u3002"));
            return true;
        }
        String sCode = _sResponseLine.substring(0, 3);
        int nCode = this.parseCode(sCode);
        String sMark = _sResponseLine.substring(3, 4);
        if (nCode == 0) {
            s_logger.debug((Object)(I18NMessage.get(TRSMailer.class, "TRSMailer.label44", "\u63a5\u6536\u5230\u672a\u77e5\u7684\u56de\u7b54\uff0c\u7ed3\u675f\u5904\u7406\u3002") + _sResponseLine));
            return true;
        }
        if (sMark.equals("-")) {
            return false;
        }
        if (sMark.equals(" ")) {
            return true;
        }
        s_logger.debug((Object)(I18NMessage.get(TRSMailer.class, "TRSMailer.label44", "\u63a5\u6536\u5230\u672a\u77e5\u7684\u56de\u7b54\uff0c\u7ed3\u675f\u5904\u7406\u3002") + _sResponseLine));
        return true;
    }

    private int parseCode(String _sCode) {
        try {
            int nCode = Integer.parseInt(_sCode);
            return nCode;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private void setSocketTimeOut(Socket _socket, int _nSocketTimeOut) {
        if (this.getSocketTimeOut() != -1) {
            try {
                _socket.setSoTimeout(_nSocketTimeOut);
                this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label45", "---- Socket\u8fde\u63a5\u8d85\u65f6\u4e3a\uff1a") + _nSocketTimeOut);
                s_logger.debug((Object)("Server Timeout: " + _nSocketTimeOut));
            }
            catch (Exception ex) {
                this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label46", "---- \u670d\u52a1\u5668\u8bbe\u7f6e\u8d85\u65f6(") + _nSocketTimeOut + I18NMessage.get(TRSMailer.class, "TRSMailer.label47", ")\u5931\u8d25\uff01 ----"));
                s_logger.error((Object)I18NMessage.get(TRSMailer.class, "TRSMailer.label48", "---- \u670d\u52a1\u5668\u8bbe\u7f6e\u8d85\u65f6\u5931\u8d25\uff01 ----"));
            }
        }
    }

    private String sendBuffer(BufferedReader _in, BufferedWriter _out, String _sRequest) throws CMyMailException {
        try {
            _out.write(_sRequest + "\r\n");
            _out.flush();
            this.mailLog.recordSendLogs(_sRequest, 1);
            String sResponse = this.getResponse(_in);
            this.mailLog.recordSendLogs(sResponse, 2);
            return sResponse;
        }
        catch (Exception e) {
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label49", "\u4ece\u90ae\u4ef6\u670d\u52a1\u5668\u8bfb\u5199\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef\uff01") + e.toString());
        }
    }

    private void sendFiles(String _sSrcFileName, String _sAbsoluteFileName, BufferedWriter _out) {
        if (_sAbsoluteFileName == null || _sAbsoluteFileName.length() <= 0) {
            return;
        }
        if (!CMyFile.fileExists(_sAbsoluteFileName)) {
            s_logger.info((Object)("not file[" + _sAbsoluteFileName + "]"));
            return;
        }
        String sMailBody = "------TRS_Email_Maker\r\n";
        sMailBody = sMailBody + "Content-Type: application/octet-stream; name=\"" + _sSrcFileName + "\"\r\n";
        sMailBody = sMailBody + "Content-Disposition: attachment; filename=\"" + _sSrcFileName + "\"\r\n";
        sMailBody = sMailBody + "Content-Transfer-Encoding: base64\r\n";
        sMailBody = sMailBody + "\r\n";
        try {
            _out.write(sMailBody);
            _out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        MIMEBase64.encode(_sAbsoluteFileName, _out);
        sMailBody = "\r\n";
        try {
            _out.write(sMailBody);
            _out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendBuffer(BufferedWriter out, String sRequest) throws CMyMailException {
        try {
            int iBufferBlock = 2048;
            int iBlocks = sRequest.length() / iBufferBlock;
            String sReqBuffer = "";
            for (int i = 0; i < iBlocks; ++i) {
                sReqBuffer = sRequest.substring(i * iBufferBlock, (i + 1) * iBufferBlock);
                out.write(sReqBuffer);
                out.flush();
            }
            sReqBuffer = sRequest.substring(iBlocks * iBufferBlock, sRequest.length());
            out.write(sReqBuffer + "\r\n");
            out.flush();
            this.mailLog.recordSendLogs(sRequest, 1);
        }
        catch (Exception e) {
            throw new CMyMailException(I18NMessage.get(TRSMailer.class, "TRSMailer.label50", "\u4ece\u90ae\u4ef6\u670d\u52a1\u5668\u8bfb\u5199\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef\u3002") + e.toString());
        }
    }

    private void sendMailBuffer(BufferedReader _in, BufferedWriter _out, String _sRequest, String _sErrorMsg) throws CMyMailException {
        String sResponse = this.sendBuffer(_in, _out, _sRequest);
        if (this.isResponseError(sResponse)) {
            throw new CMyMailException(_sErrorMsg + "\uff08" + sResponse + "\uff09");
        }
    }

    private boolean isResponseError(String _sResponse) {
        if (_sResponse == null || _sResponse.trim().length() < 3) {
            s_logger.error((Object)I18NMessage.get(TRSMailer.class, "TRSMailer.label51", "\u65e0\u6cd5\u8bc6\u522b\u90ae\u4ef6\u670d\u52a1\u5668\u7684\u54cd\u5e94\uff0c\u8ba4\u4e3a\u662f\u9519\u8bef\u3002"));
            return true;
        }
        String sCode = _sResponse.substring(0, 3);
        int nCode = this.parseCode(sCode);
        return nCode >= 500 && nCode < 600;
    }

    private void closeSocket(Socket _socket, BufferedWriter _out, BufferedReader _in) {
        try {
            if (_in != null) {
                _in.close();
            }
            if (_out != null) {
                _out.close();
            }
            if (_socket != null) {
                _socket.close();
            }
        }
        catch (Exception ex) {
            this.mailLog.appendSendLogs(I18NMessage.get(TRSMailer.class, "TRSMailer.label52", "---- \u5173\u95ed\u8fde\u63a5\u5931\u8d25\uff01 ----"));
        }
    }
}

