/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.database.DataType;
import com.trs.infra.util.database.SQLServerDB;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class KingBaseDB
extends SQLServerDB {
    private static final int TYPES_NVARCHAR = -9;
    private static final String SQL_QUERY_COLS = "select TABLE_NAME,ORDINAL_POSITION COLUMN_ID,COLUMN_NAME,REPLACE(data_type, 'CHARACTER VARYING', 'VARCHAR') DATA_TYPE,character_maximum_length DATA_LENGTH,substr(is_nullable,1,1) NULLABLE,column_default DATA_DEFAULT,numeric_scale DATA_SCALE from information_schema.COLUMNS where TABLE_NAME = '";
    public static final DataType TINYINT = new DataType("TINYINT", -6, 1);
    public static final DataType DATE = new DataType("DATE", 93, 8);
    public static final DataType TIME = new DataType("TIME", 93, 8);
    public static final DataType TIMESTAMP = new DataType("TIMESTAMP", 93, 8);
    public static final DataType INTEGER = new DataType("INTEGER", 4, 4);
    public static final DataType VARCHAR = new DataType("VARCHAR", 12, -4000);
    public static final DataType NVARCHAR = new DataType("NVARCHAR", 12, -4000);
    public static final DataType VARCHAR2 = new DataType("VARCHAR2", 12, -4000);
    public static final DataType DOUBLE = new DataType("DOUBLE", 8);
    public static final DataType DOUBLE2 = new DataType("DOUBLE PRECISION", 8);
    public static final DataType CLOB = new DataType("CLOB", 2005);
    private static final DataType[] m_allDataTypes = new DataType[]{CHAR, VARCHAR, NUMBER, DATE, TEXT, IMAGE, INT, FLOAT, DATETIME, SMALLINT, TIMESTAMP, INTEGER, NUMERIC, BIGINT, TINYINT, DECIMAL, NVARCHAR, CLOB, VARCHAR2, DOUBLE, DOUBLE2};
    static final DataType[] m_supportedDataTypes = new DataType[]{SMALLINT, TINYINT, INT, TEXT, TIMESTAMP, VARCHAR, NVARCHAR};

    public KingBaseDB() {
        super("KingBase", "com.kingbase.Driver");
    }

    public KingBaseDB(String _sName, String _sDriverClass) {
        super("KingBase", "com.kingbase.Driver");
    }

    @Override
    public String sqlGetNextId() {
        return null;
    }

    @Override
    protected String keywordsModifyField() {
        return "alter column";
    }

    @Override
    protected void registerDBInfo() {
        this.registerColumnType(-7, "tinyint");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(4, "int");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "timestamp");
        this.registerColumnType(92, "timestamp");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
        this.registerColumnType(-3, "blob");
        this.registerColumnType(-3, 8000, "varbinary($l)");
    }

    @Override
    public String sqlAddField(String tableName, String fieldName, String fieldType, int maxLength, boolean nullable, String defaultValue, int scale) {
        DataType dataType = this.getDataType(fieldType);
        if (dataType == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("alter table ");
        sql.append(tableName.toUpperCase());
        sql.append(" add ").append(fieldName.toUpperCase());
        int nMaxLength = maxLength;
        switch (dataType.getType()) {
            case 2: 
            case 4: {
                sql.append(" int ");
                nMaxLength = dataType.getMaxLength();
                break;
            }
            case 6: {
                sql.append(" float ");
                nMaxLength = dataType.getMaxLength();
                break;
            }
            case 91: 
            case 93: {
                sql.append(" timestamp ");
                break;
            }
            case -9: 
            case 12: {
                sql.append(" varchar ");
                break;
            }
        }
        if (dataType.isLengthDefinedByUser()) {
            sql.append('(').append(nMaxLength);
            if (scale > 0) {
                sql.append(',').append(scale);
            }
            sql.append(')');
        }
        return sql.toString();
    }

    @Override
    public String sqlAddField(String _sTableName, String _sFieldName, int _nFieldType, int _nLengthOrPrecision, boolean _sNullable, String _sDefaultValue, int _nScale) throws WCMException {
        StringBuffer buff = new StringBuffer(128);
        buff.append("alter table ");
        buff.append(_sTableName.toUpperCase());
        buff.append(" add ");
        buff.append(_sFieldName.toUpperCase());
        buff.append(' ');
        buff.append(this.getTypeName(_nFieldType, _nLengthOrPrecision, _nLengthOrPrecision, _nScale));
        return buff.toString();
    }

    @Override
    public String sqlConcatStr(String str1, String str2, String str3) {
        return this.sqlConcatStr(new String[]{str1, str2, str3});
    }

    @Override
    public String sqlConcatStr(String str1, String str2) {
        return this.sqlConcatStr(new String[]{str1, str2});
    }

    @Override
    public String sqlConcatStr(String[] ls) {
        StringBuffer sql = new StringBuffer(128);
        sql.append(ls[0]);
        int len = ls.length;
        for (int i = 1; i < len; ++i) {
            sql.append("||").append(ls[i]);
        }
        return sql.toString();
    }

    @Override
    public String sqlDate(String dateTime) {
        return this.sqlDateTime(dateTime, "YYYY-MM-DD HH24:MI:SS");
    }

    @Override
    public String sqlDateField(String dateField) {
        return dateField;
    }

    @Override
    public String sqlDateTime(String dateTime, String format) {
        StringBuffer sql = new StringBuffer(128);
        sql.append("TO_TIMESTAMP('");
        sql.append(dateTime);
        sql.append("','");
        sql.append(format);
        sql.append("')");
        return sql.toString();
    }

    @Override
    public String sqlFilterForClob(String fieldName, String value) {
        return "";
    }

    @Override
    public String sqlFilterOneDay(String fieldName, String dateTime, String format) {
        StringBuffer sql = new StringBuffer(128);
        sql.append("datediff('day',");
        sql.append(fieldName);
        sql.append(", cast('");
        sql.append(dateTime);
        sql.append("' as timestamp))=0");
        return sql.toString();
    }

    @Override
    public String sqlGetSysDate() {
        return "current_timestamp";
    }

    @Override
    public String sqlRenameField(String tableName, String oldFieldName, String newFieldName) {
        StringBuffer sql = new StringBuffer(128);
        sql.append("alter table ");
        sql.append(tableName.toUpperCase());
        sql.append(" rename ");
        sql.append(oldFieldName.toUpperCase());
        sql.append(" to ");
        sql.append(newFieldName.toUpperCase());
        return sql.toString();
    }

    @Override
    public String sqlRenameTable(String oldTableName, String newTableName) {
        StringBuffer sql = new StringBuffer(128);
        sql.append("alter table ");
        sql.append(oldTableName.toUpperCase());
        sql.append(" rename to");
        sql.append(newTableName.toUpperCase());
        return sql.toString();
    }

    @Override
    public String sqlQueryTableInfo(String ownerUser, String tableName) {
        return SQL_QUERY_COLS + tableName.toUpperCase() + "'";
    }

    @Override
    public String sqlQueryTableInfos(String ownerUser) {
        return null;
    }

    @Override
    public String sqlModifyField(String _sTableName, String _sFieldName, int _nFieldType, int _nLengthOrPrecision, boolean _bNullable, int _nScale) throws WCMException {
        StringBuffer buff = new StringBuffer(128);
        buff.append("alter table ");
        buff.append(_sTableName);
        buff.append(" alter column ");
        buff.append(_sFieldName);
        buff.append(" TYPE ");
        buff.append(this.getTypeName(_nFieldType, _nLengthOrPrecision, _nLengthOrPrecision, _nScale));
        return buff.toString();
    }

    @Override
    public DataType[] getAllDataTypes() {
        return m_allDataTypes;
    }

    @Override
    public boolean canWriteTextDirectly() {
        return false;
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, int p_nFieldIndex) throws CMyException {
        try {
            return p_rsData.getString(p_nFieldIndex);
        }
        catch (SQLException e) {
            throw new CMyException(40, "\u8bfb\u53d6\u5927\u5b57\u6bb5\u5185\u5bb9\u5931\u8d25.");
        }
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, String p_sFieldName) throws CMyException {
        try {
            return p_rsData.getString(p_sFieldName);
        }
        catch (SQLException e) {
            throw new CMyException(40, "\u8bfb\u53d6\u5927\u5b57\u6bb5\u5185\u5bb9\u5931\u8d25.");
        }
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String p_sClobFieldName, String p_sValue) throws CMyException {
        if (p_sClobFieldName.length() < 1 || p_sTableName.length() < 1 || p_sWhere.length() < 1 || p_sIdFieldName.length() < 1) {
            throw new CMyException(10, "\u53c2\u6570\u65e0\u6548");
        }
        if (p_sValue == null) {
            return true;
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("select ").append(p_sClobFieldName);
        sql.append(" from ").append(p_sTableName);
        sql.append(" where ").append(p_sWhere);
        PreparedStatement pstmt = null;
        ResultSet rsData = null;
        try {
            pstmt = p_oConn.prepareStatement(sql.toString());
            rsData = pstmt.executeQuery();
            if (rsData.next()) {
                Clob clob = rsData.getClob(1);
                clob.setString(1L, p_sValue);
            }
            boolean clob = true;
            return clob;
        }
        catch (SQLException ex) {
            throw new CMyException(40, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String[] p_asFieldsAndValues) throws CMyException {
        int length = p_asFieldsAndValues.length;
        if ((length & 1) != 0) {
            throw new CMyException(10, "CLOB\u5b57\u6bb5\u540d\u548c\u5b57\u6bb5\u503c\u6570\u7ec4\u53c2\u6570\u65e0\u6548");
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("select ");
        sql.append(p_asFieldsAndValues[0]);
        for (int i = 2; i < length; i += 2) {
            sql.append(',').append(p_asFieldsAndValues[i]);
        }
        sql.append(" from ");
        sql.append(p_sTableName);
        sql.append(" where ").append(p_sWhere);
        PreparedStatement pstmt = null;
        ResultSet rsData = null;
        try {
            int colIndex;
            pstmt = p_oConn.prepareStatement(sql.toString());
            rsData = pstmt.executeQuery();
            if (rsData.next()) {
                colIndex = 1;
                for (int i = 1; i < length; i += 2) {
                    String value = p_asFieldsAndValues[i];
                    if (value == null) {
                        value = "";
                    }
                    Clob clob = rsData.getClob(colIndex++);
                    clob.setString(1L, value);
                }
            }
            colIndex = 1;
            return colIndex != 0;
        }
        catch (SQLException ex) {
            throw new CMyException(40, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sIdFieldName, int nObjId, String[] p_asFieldsAndValues) throws CMyException {
        int length = p_asFieldsAndValues.length;
        if ((length & 1) != 0) {
            throw new CMyException(10, "CLOB\u5b57\u6bb5\u540d\u548c\u5b57\u6bb5\u503c\u6570\u7ec4\u53c2\u6570\u65e0\u6548");
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("select ");
        sql.append(p_asFieldsAndValues[0]);
        for (int i = 2; i < length; i += 2) {
            sql.append(',').append(p_asFieldsAndValues[i]);
        }
        sql.append(" from ");
        sql.append(p_sTableName);
        sql.append(" where ").append(p_sIdFieldName);
        sql.append("=?");
        PreparedStatement pstmt = null;
        ResultSet rsData = null;
        try {
            int colIndex;
            pstmt = p_oConn.prepareStatement(sql.toString());
            pstmt.setInt(1, nObjId);
            rsData = pstmt.executeQuery();
            if (rsData.next()) {
                colIndex = 1;
                for (int i = 1; i < length; i += 2) {
                    String value = p_asFieldsAndValues[i];
                    if (value == null) {
                        value = "";
                    }
                    Clob clob = rsData.getClob(colIndex++);
                    clob.setString(1L, value);
                }
            }
            colIndex = 1;
            return colIndex != 0;
        }
        catch (SQLException ex) {
            throw new CMyException(40, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public int getType() {
        return 9;
    }
}

