/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CMysqlText;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DataType;
import com.trs.infra.util.database.FieldInfo;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

public class GBaseDB
extends DBType {
    public static final DataType BIT = new DataType("BIT", -7, 1);
    public static final DataType BOOLEAN = new DataType("BOOLEAN", 16, 1);
    public static final DataType TINYINT = new DataType("TINYINT", -6, 1);
    public static final DataType SMALLINT = new DataType("SMALLINT", 5, 2);
    public static final DataType INTEGER = new DataType("INT", 4, 4);
    public static final DataType BIGINT = new DataType("BIGINT", -5, 8);
    public static final DataType FLOAT = new DataType("FLOAT", 6, 8);
    public static final DataType DECIMAL = new DataType("DECIMAL", 3, 9);
    public static final DataType NUMERIC = new DataType("NUMERIC", 2, 9);
    public static final DataType CHAR = new DataType("CHAR", 1);
    public static final DataType VARCHAR = new DataType("VARCHAR", 12, -4000);
    public static final DataType TINYTEXT = new DataType("TINYTEXT", 12, 8);
    public static final DataType TEXT = new DataType("TEXT", 12);
    public static final DataType MEDIUMTEXT = new DataType("MEDIUMTEXT", -1);
    public static final DataType LONGTEXT = new DataType("LONGTEXT", 2005);
    public static final DataType VARBINARY = new DataType("VARBINARY", -3);
    public static final DataType TINYBLOB = new DataType("TINYBLOB", -3);
    public static final DataType BLOB = new DataType("BLOB", -3);
    public static final DataType MEDIUBLOB = new DataType("MEDIUBLOB", -4);
    public static final DataType LONGBLOB = new DataType("LONGBLOB", 2004);
    public static final DataType DATE = new DataType("DATE", 91);
    public static final DataType TIME = new DataType("TIME", 92);
    public static final DataType DATETIME = new DataType("DATETIME", 93);
    public static final DataType TIMESTAMP = new DataType("TIMESTAMP", 93);
    public static final DataType NVARCHAR = new DataType("NVARCHAR", 12, -4000);
    private static final DataType[] m_allDataTypes = new DataType[]{BIT, BOOLEAN, TINYINT, SMALLINT, INTEGER, BIGINT, FLOAT, DECIMAL, NUMERIC, CHAR, VARCHAR, TINYTEXT, TEXT, MEDIUMTEXT, LONGTEXT, VARBINARY, TINYBLOB, BLOB, MEDIUBLOB, LONGBLOB, DATE, TIME, DATETIME, TIMESTAMP, NVARCHAR};
    static final DataType[] m_supportedDataTypes = new DataType[]{TINYTEXT, TEXT, MEDIUMTEXT, LONGTEXT, TINYBLOB, MEDIUBLOB, LONGBLOB, NVARCHAR};
    private static final Map TYPE_CRPARAMS_COUNTER = new HashMap();

    public GBaseDB() {
        super("gbase", "com.gbase.jdbc.Driver", true);
    }

    public GBaseDB(String _sName, String _sDriverClass) {
        super(_sName, _sDriverClass, true);
    }

    @Override
    protected void registerDBInfo() {
        this.registerColumnType(-7, "bit");
        this.registerColumnType(16, "BOOLEAN");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(4, "int($l)");
        this.registerColumnType(4, "int");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(8, "double");
        this.registerColumnType(2, "decimal($p,$s)");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(3, "decimal($p,$s)");
        this.registerColumnType(3, "numeric($p,$s)");
        this.registerColumnType(1, "char($l)");
        this.registerColumnType(-1, 0xFFFFFF, "mediumtext");
        this.registerColumnType(2005, "text");
        this.registerColumnType(12, 65535, "varchar($l)");
        this.registerColumnType(12, 65535, "nvarchar($l)");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(-4, 0xFFFFFF, "mediumblob");
        this.registerColumnType(-3, 65535, "blob");
        this.registerColumnType(-3, 255, "tinyblob");
        this.registerColumnType(2004, "longblob");
        this.registerColumnType(2005, "longtext");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
    }

    @Override
    public String encodeStrToWrite(String _strSrc) {
        return _strSrc;
    }

    @Override
    public boolean canWriteTextDirectly() {
        return false;
    }

    @Override
    public DataType[] getAllDataTypes() {
        return m_allDataTypes;
    }

    @Override
    public DataType[] getSupportedDataTypes() {
        return m_supportedDataTypes;
    }

    @Override
    public String sqlConcatStr(String _strSQL1, String _strSQL2) {
        return "CONCAT(" + _strSQL1 + "," + _strSQL2 + ")";
    }

    @Override
    public String sqlConcatStr(String _strSQL1, String _strSQL2, String _strSQL3) {
        return "CONCAT(CONCAT(" + _strSQL1 + "," + _strSQL2 + ")," + _strSQL3 + ")";
    }

    @Override
    public String sqlConcatStr(String[] _strSQLs) {
        String sRet = "CONCAT(" + _strSQLs[0] + "," + _strSQLs[1] + ")";
        for (int i = 2; i < _strSQLs.length; ++i) {
            sRet = "CONCAT(" + sRet + "," + _strSQLs[i] + ")";
        }
        return sRet;
    }

    @Override
    public String sqlFilterForClob(String _sFieldName, String _sValue) {
        String sValue = _sValue.equals("?") ? "?" : "'" + CMyString.filterForSQL(_sValue) + "'";
        return "instr(" + _sFieldName + "," + sValue + ")>0 ";
    }

    @Override
    public String sqlAddField(String _sTableName, String _sFieldName, String _sFieldType, int _nMaxLength, boolean _bNullable, String _sDefaultValue, int _nScale) {
        DataType dataType = this.getDataType(_sFieldType);
        if (dataType == null) {
            return null;
        }
        String sFieldType = _sFieldType;
        int nMaxLength = _nMaxLength;
        String strSQL = "ALTER TABLE " + _sTableName + " ADD " + _sFieldName + " " + sFieldType;
        if (dataType.isLengthDefinedByUser()) {
            strSQL = _nScale > 0 ? String.valueOf(strSQL) + "(" + nMaxLength + ", " + _nScale + ")" : String.valueOf(strSQL) + "(" + nMaxLength + ")";
        }
        if (_bNullable) {
            strSQL = String.valueOf(strSQL) + " NULL";
        } else {
            if (_sDefaultValue != null) {
                strSQL = String.valueOf(strSQL) + " DEFAULT ";
                strSQL = dataType.isCharData() ? String.valueOf(strSQL) + "'" + CMyString.filterForSQL(_sDefaultValue) + "'" : String.valueOf(strSQL) + _sDefaultValue;
            }
            strSQL = String.valueOf(strSQL) + " NOT NULL ";
        }
        return strSQL;
    }

    @Override
    public String sqlRenameTable(String _sOldTableName, String _sNewTableName) {
        return "ALTER TABLE " + CMyString.filterForSQL(_sOldTableName) + " rename to " + CMyString.filterForSQL(_sNewTableName);
    }

    @Override
    public String sqlRenameField(String _sTableName, String _sOldFieldName, String _sNewFieldName) throws WCMException {
        DBManager dbman = DBManager.getDBManager();
        FieldInfo field = dbman.getFieldInfo(_sTableName, _sOldFieldName);
        if (field == null) {
            throw new WCMException(40, "No such field: " + _sOldFieldName + ", TABLE=" + _sTableName);
        }
        StringBuffer buff = new StringBuffer(128);
        buff.append("alter table ");
        buff.append(CMyString.filterForSQL(_sTableName));
        buff.append(" change column ");
        buff.append(_sOldFieldName);
        buff.append(' ');
        buff.append(_sNewFieldName);
        String typeName = field.getDataTypeName();
        String count = (String)TYPE_CRPARAMS_COUNTER.get(typeName.toLowerCase());
        buff.append(' ');
        buff.append(typeName);
        buff.append(' ');
        if ("1".equals(count)) {
            buff.append('(');
            buff.append(field.getDataLength());
            buff.append(')');
        } else if ("2".equals(count)) {
            buff.append('(');
            buff.append(field.getDataLength());
            buff.append(',');
            buff.append(field.getDataScale());
            buff.append(')');
        }
        if (!field.isNullable()) {
            buff.append(" not null");
        }
        String defautlValue = field.getDataDefault();
        if (field.getDataDefault() != null && defautlValue.length() > 0) {
            buff.append(" default ");
            if (field.getDataType().isCharData()) {
                buff.append("'");
                buff.append(defautlValue);
                buff.append("'");
            } else {
                buff.append(defautlValue);
            }
        }
        return buff.toString();
    }

    @Override
    protected String keywordsModifyField() {
        return "modify";
    }

    @Override
    public String sqlGetSysDate() {
        return "now()";
    }

    @Override
    public String sqlFilterOneDay(String _sFieldName, String _sDateTime, String _sFormat) {
        return "DateDiff(" + _sFieldName + ",'" + _sDateTime + "')=0";
    }

    @Override
    public String sqlDateTime(String _sDateTime, String _sFormat) {
        return "'" + _sDateTime + "'";
    }

    @Override
    public String sqlDate(String _sDateTime) {
        return "'" + _sDateTime + "'";
    }

    @Override
    public String sqlDateField(String _sDateField) {
        return _sDateField;
    }

    @Override
    public String initQuerySQL(String _strSql, int _nStartIndex, int _nSize) {
        return _strSql;
    }

    @Override
    public String sqlQueryTableInfos(String _sOwnerUser) {
        return null;
    }

    @Override
    public String sqlQueryTableInfo(String _sOwnerUser, String _sDBTableName) {
        return null;
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, int p_nFieldIndex) throws CMyException {
        return CMysqlText.getClob(p_rsData, p_nFieldIndex);
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, String p_sFieldName) throws CMyException {
        return CMysqlText.getClob(p_rsData, p_sFieldName);
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String p_sClobFieldName, String p_sValue) throws CMyException {
        return CMysqlText.setClob(p_oConn, p_sTableName, p_sWhere, p_sIdFieldName, p_sClobFieldName, p_sValue);
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String[] p_asFieldsAndValues) throws CMyException {
        return CMysqlText.setClob(p_oConn, p_sTableName, p_sWhere, p_sIdFieldName, p_asFieldsAndValues);
    }

    @Override
    public String sqlGetNextId() {
        return null;
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    public void setStringFieldValue(PreparedStatement _preStat, int _nIndex, String _sValue) throws Exception {
        if (_sValue == null) {
            _preStat.setString(_nIndex, _sValue);
            return;
        }
        int nLen = _sValue.length();
        StringBuffer sbValue = new StringBuffer(nLen * 2);
        for (int nValueIndex = 0; nValueIndex < nLen; ++nValueIndex) {
            sbValue.append(_sValue.charAt(nValueIndex));
            if (_sValue.charAt(nValueIndex) != '\\') continue;
            sbValue.append('\\');
        }
        if (sbValue.length() <= 300) {
            _preStat.setString(_nIndex, sbValue.toString());
            return;
        }
        StringReader stringReader = new StringReader(sbValue.toString());
        _preStat.setCharacterStream(_nIndex, (Reader)stringReader, sbValue.length());
    }

    @Override
    public boolean canDropField() {
        return true;
    }

    static {
        TYPE_CRPARAMS_COUNTER.put("varbinary", "1");
        TYPE_CRPARAMS_COUNTER.put("binary", "1");
        TYPE_CRPARAMS_COUNTER.put("char", "1");
        TYPE_CRPARAMS_COUNTER.put("varchar", "1");
        TYPE_CRPARAMS_COUNTER.put("numeric", "2");
        TYPE_CRPARAMS_COUNTER.put("decimal", "2");
    }
}

