/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.persistent.db.ConnectPasswordEncrypter;
import com.trs.infra.persistent.db.DBConnectionConfig;
import com.trs.infra.util.CMyString;
import com.trs.util.dbcp.ConnectionCache;
import com.trs.util.dbcp.ConnectionCacheFactory;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionPool {
    private ConnectionCache m_oDataSource;

    public ConnectionPool(DBConnectionConfig config) throws SQLException {
        ConnectionCacheFactory factory = ConnectionCacheFactory.getInstance();
        this.m_oDataSource = factory.createConnectionCache();
        this.m_oDataSource.setDriverClassName(config.getDBType().getDriverClass());
        this.m_oDataSource.setURL(config.getConnectionURL());
        this.m_oDataSource.setUserName(config.getConnectionUser());
        this.m_oDataSource.setPassWord(ConnectPasswordEncrypter.deEncrypt(config.getConnectionPassword()));
        this.m_oDataSource.setTraceAssign(config.isTraceAssign());
        this.m_oDataSource.setTTLOverUse(config.getTimeToLiveOverUse());
        if (config.getCacheScheme() != null) {
            this.m_oDataSource.setCacheScheme(this.getCacheScheme(config.getCacheScheme()));
            this.m_oDataSource.setMaxWait(this.getMaxWaitTime(config.getCacheScheme()));
        } else if (config.isWaitIfBusy()) {
            this.m_oDataSource.setCacheScheme(3);
            this.m_oDataSource.setMaxWait(-1);
        } else {
            this.m_oDataSource.setCacheScheme(2);
        }
        int initialConnections = config.getInitConnects();
        int maxConnections = config.getMaxConnects();
        if (initialConnections > maxConnections) {
            initialConnections = maxConnections;
        }
        this.m_oDataSource.setMaxLimit(maxConnections);
        this.m_oDataSource.setMinLimit(initialConnections);
        this.m_oDataSource.setMaxSpare(maxConnections);
        this.m_oDataSource.setMinSpare(initialConnections);
        this.m_oDataSource.setTestSQL(CMyString.showNull(config.getTestSQL()));
        this.m_oDataSource.setTestOnAssign(config.isTestOnAssign());
        boolean zTestOnIdle = config.isTestOnIdle();
        this.m_oDataSource.setTestOnIdle(zTestOnIdle);
        if (zTestOnIdle) {
            int iMonitorInterval = config.getMonitorInterval() * 60;
            this.m_oDataSource.setMonitorInterval(iMonitorInterval);
            int iMaxIdleTime = config.getMaxIdleTime() * 60;
            this.m_oDataSource.setMaxIdleTime(iMaxIdleTime);
        }
        this.m_oDataSource.setMaxOrphanTime(config.getMaxOrphanTime());
        this.m_oDataSource.start();
    }

    private int getCacheScheme(String sCacheScheme) {
        if (sCacheScheme != null) {
            if (sCacheScheme.startsWith("DYNAMIC_GROW")) {
                return 1;
            }
            if (sCacheScheme.startsWith("FIXED_FAIL")) {
                return 2;
            }
            if (sCacheScheme.startsWith("FIXED_WAIT")) {
                return 3;
            }
        }
        return 3;
    }

    private int getMaxWaitTime(String sCacheScheme) {
        if (sCacheScheme != null && sCacheScheme.startsWith("FIXED_WAIT:")) {
            try {
                return 1000 * Integer.parseInt(sCacheScheme.substring("FIXED_WAIT:".length()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public void close() {
        try {
            this.m_oDataSource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void free(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Connection getConnection() throws SQLException {
        return this.m_oDataSource.getConnection();
    }

    public String toString() {
        return this.m_oDataSource.toString();
    }

    public ConnectionCache getConnectionCache() {
        return this.m_oDataSource;
    }
}

