/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class Report {
    private static Logger logger = Logger.getLogger(Report.class);
    public static final int TYPE_ERROR = 5;
    public static final int TYPE_WARN = 4;
    public static final int TYPE_INFO = 3;
    public static final int TYPE_DEBUG = 2;
    private int m_nType = 3;
    private String m_sRportTitle;
    private String m_sRportDetail;
    private Object m_oRelateObject = null;

    public Report(String _sReportTitle, Throwable _throwable) {
        this.m_sRportTitle = _sReportTitle;
        if (_throwable != null) {
            this.setType(5);
            this.m_sRportDetail = _throwable.getMessage();
            logger.error((Object)"ReportDetail:", _throwable);
        }
    }

    public Report(int _type, String _sReportTitle, String _sReportDetail) {
        this.m_nType = _type;
        this.m_sRportTitle = _sReportTitle;
        this.m_sRportDetail = _sReportDetail;
    }

    public Report(String _sReportTitle) {
        this.m_sRportTitle = _sReportTitle;
    }

    public String getRportDetail() {
        return this.m_sRportDetail;
    }

    public String getRportTitle() {
        return this.m_sRportTitle;
    }

    public String toString() {
        return this.m_sRportTitle + "\n Detail: " + CMyString.showNull(this.m_sRportDetail);
    }

    public Element toXMLElement(boolean _bReturnJSONXML) {
        Element root = DocumentHelper.createElement((String)"REPORT");
        root.addElement("IS" + (_bReturnJSONXML ? "_" : "-") + "SUCCESS").addText(this.getType() != 5 ? "true" : "false");
        if (CMyString.containsCDATAStr(this.m_sRportTitle)) {
            root.addElement("TITLE").addText(this.m_sRportTitle);
        } else {
            root.addElement("TITLE").addCDATA(this.m_sRportTitle);
        }
        root.addElement("TYPE").addText(String.valueOf(this.getType()));
        if (this.m_sRportDetail != null) {
            if (CMyString.containsCDATAStr(this.m_sRportDetail)) {
                root.addElement("ERROR" + (_bReturnJSONXML ? "_" : "-") + "INFO").addText(this.m_sRportDetail);
            } else {
                root.addElement("ERROR" + (_bReturnJSONXML ? "_" : "-") + "INFO").addCDATA(this.m_sRportDetail);
            }
        }
        return root;
    }

    public String toXML() {
        return this.toXMLElement(false).asXML();
    }

    public String toJSONXML() {
        return this.toXMLElement(true).asXML();
    }

    public int getType() {
        return this.m_nType;
    }

    public void setType(int type) {
        this.m_nType = type;
    }

    public void setRportDetail(String rportDetail) {
        this.m_sRportDetail = rportDetail;
    }

    public void setRportTitle(String rportTitle) {
        this.m_sRportTitle = rportTitle;
    }

    public Object getRelateObject() {
        return this.m_oRelateObject;
    }

    public void setRelateObject(Object relateObject) {
        this.m_oRelateObject = relateObject;
    }
}

