/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.util.CMyException;
import java.util.Vector;

public class CMyErrors {
    private static final int INIT_SIZE = 5;
    private Vector vErrors = new Vector(5);

    public CMyErrors add(String _sError) {
        if (_sError != null) {
            this.vErrors.add(_sError);
        }
        return this;
    }

    public CMyErrors add(Exception _ex) {
        if (_ex != null) {
            this.vErrors.add(_ex);
        }
        return this;
    }

    public CMyErrors add(String _sInfo, Exception _ex) {
        this.add(_sInfo);
        this.add(_ex);
        return this;
    }

    public CMyErrors add(CMyErrors _errors) {
        if (_errors == null || _errors.isEmpty()) {
            return this;
        }
        this.vErrors.addAll(_errors.vErrors);
        return this;
    }

    public int size() {
        return this.vErrors.size();
    }

    public boolean isEmpty() {
        return this.vErrors.isEmpty();
    }

    public Vector getErrors() {
        return this.vErrors;
    }

    public Object getAt(int _index) {
        try {
            return this.vErrors.get(_index);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public CMyErrors clear() {
        this.vErrors.clear();
        return this;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean _bIncludingNo) {
        if (this.vErrors.size() == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.vErrors.size(); ++i) {
            Object objError = this.vErrors.get(i);
            if (objError == null) continue;
            if (_bIncludingNo) {
                buff.append("(" + i + ")");
            }
            if (objError instanceof String) {
                buff.append((String)objError).append("\n");
                continue;
            }
            if (!(objError instanceof Throwable)) continue;
            buff.append(CMyException.getStackTraceText((Throwable)objError)).append("\n");
        }
        return buff.toString();
    }

    public static void main(String[] args) {
        CMyErrors errors = new CMyErrors();
        CMyException ex = new CMyException(1, "My Exception");
        errors.add("This is an error message!");
        errors.add(new CMyException(41, "CMyException error", ex));
        System.out.println(errors.toString());
    }
}

