/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.security;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.security.SecureKeys;
import com.trs.infra.util.BASE64DecoderStream;
import com.trs.infra.util.BASE64EncoderStream;
import com.trs.infra.util.CMyString;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class SecureKey
extends BaseObj {
    public static final int OBJ_TYPE = 559084253;
    public static final String DB_TABLE_NAME = "WCMSECUREKEY";
    public static final String DB_ID_NAME = "SECUREKEYID";
    static final String KEYTYPE_DES = "DES";
    static final String KEYTYPE_DSA = "DSA";
    private static Logger s_logger = Logger.getLogger(SecureKey.class);

    @Override
    public int getWCMType() {
        return 559084253;
    }

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            String keyName = this.getKeyName();
            if (CMyString.isEmpty(keyName)) {
                throw new WCMException(1106, I18NMessage.get(SecureKey.class, "SecureKey.label1", "\u5c5e\u6027[KeyName]\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (SecureKey.findByName(keyName) != null) {
                throw new WCMException(1108, I18NMessage.get(SecureKey.class, "SecureKey.label2", "\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u540d\u4e3a[") + keyName + I18NMessage.get(SecureKey.class, "SecureKey.label3", "]\u7684SecureKey\u5bf9\u8c61!"));
            }
        }
        return true;
    }

    public static final SecureKey findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (SecureKey)BaseObj.findById(SecureKey.class, _nId);
    }

    public static final SecureKey createNewInstance() throws WCMException {
        return (SecureKey)BaseObj.createNewInstance(SecureKey.class);
    }

    public static final SecureKey findByKey(Object _oKey) throws WCMException {
        return (SecureKey)BaseObj.findByKey(SecureKey.class, _oKey);
    }

    public static final SecureKey findByName(String _sKeyName) throws WCMException {
        WCMFilter filter = new WCMFilter(DB_TABLE_NAME, "KEYNAME=?", "");
        filter.addSearchValues(0, CMyString.filterForSQL(_sKeyName));
        SecureKeys keys = new SecureKeys();
        keys.open(filter);
        if (keys.isEmpty()) {
            return null;
        }
        return (SecureKey)keys.getAt(0);
    }

    @Override
    public void update() throws WCMException {
        throw new WCMException(1100, "Unsuport modify");
    }

    public String getKeyName() {
        return this.getPropertyAsString("KEYNAME");
    }

    public boolean setKeyName(String _sKeyName) throws WCMException {
        return this.setProperty("KEYNAME", _sKeyName);
    }

    public String getAlgorithm() {
        return this.getPropertyAsString("ALGORITHM");
    }

    public boolean setAlgorithm(String _alg) throws WCMException {
        return this.setProperty("ALGORITHM", _alg);
    }

    public int getKeySize() {
        return this.getPropertyAsInt("KEYSIZE", 0);
    }

    public boolean setKeySize(int _nKeySize) throws WCMException {
        return this.setProperty("KEYSIZE", _nKeySize);
    }

    public Key getPrivateKey() {
        String sPrivate = this.getPropertyAsString("PRIVATEKEY");
        return this.decodeKey(sPrivate, true);
    }

    boolean setPrivateKey(Key _privateKey) throws WCMException {
        String sPrivateKey = this.encodeKey(_privateKey);
        return this.setProperty("PRIVATEKEY", sPrivateKey);
    }

    public Key getPublicKey() {
        String sPublicKey = this.getPropertyAsString("PUBLICKEY");
        return this.decodeKey(sPublicKey, false);
    }

    boolean setPublicKey(Key _publicKey) throws WCMException {
        String sPublicKey = this.encodeKey(_publicKey);
        return this.setProperty("PUBLICKEY", sPublicKey);
    }

    private Key decodeKey(String _sKey, boolean _bPrivateKey) {
        try {
            byte[] buff = BASE64DecoderStream.decode(_sKey);
            if (KEYTYPE_DSA.equals(this.getAlgorithm())) {
                KeyFactory keyf = KeyFactory.getInstance(KEYTYPE_DSA);
                if (_bPrivateKey) {
                    PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(buff);
                    PrivateKey priKey = keyf.generatePrivate(priPKCS8);
                    return priKey;
                }
                X509EncodedKeySpec pubX509 = new X509EncodedKeySpec(buff);
                PublicKey pubkey = keyf.generatePublic(pubX509);
                return pubkey;
            }
            SecretKeySpec secretKey = new SecretKeySpec(buff, KEYTYPE_DES);
            return secretKey;
        }
        catch (Exception e) {
            s_logger.error((Object)"decode key failed!", (Throwable)e);
            return null;
        }
    }

    private String encodeKey(Key _key) {
        return new String(BASE64EncoderStream.encode(_key.getEncoded()));
    }

    public String toString() {
        return this.getKeyName() + "[Alg-" + this.getAlgorithm() + "]";
    }

    public static void main(String[] args) {
        System.out.println("OBJ_TYPE:" + "com.trs.infra.support.security.SecureKey".hashCode());
    }
}

