/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.config.domain;

import com.trs.infra.I18NMessage;
import com.trs.infra.config.BeanConfigServer;
import com.trs.infra.config.persistent.BeanConfig;
import com.trs.infra.util.CMyException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.tree.DefaultDocumentType;

public class BeanConfigHelper {
    private Document m_oBeansDocument;
    private Element m_elBeansRoot;
    private List m_listBeanConfigCollection;

    public BeanConfigHelper(List _listBeanConfig) {
        this.m_listBeanConfigCollection = _listBeanConfig;
        this.m_elBeansRoot = DocumentHelper.createElement((String)"beans");
        this.m_oBeansDocument = DocumentHelper.createDocument((Element)this.m_elBeansRoot);
        DefaultDocumentType type = new DefaultDocumentType("beans", "-//SPRING//DTD BEAN//EN", "http://www.springframework.org/dtd/spring-beans.dtd");
        this.m_oBeansDocument.setDocType((DocumentType)type);
    }

    public InputStream getBeanConfigXmlInputStream() throws CMyException {
        if (this.m_listBeanConfigCollection == null || this.m_listBeanConfigCollection.isEmpty()) {
            throw new CMyException(I18NMessage.get(BeanConfigHelper.class, "BeanConfigHelper.label1", "\u5c1a\u672a\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\uff0c\u521d\u59cb\u5316\u5931\u8d25"));
        }
        String beanTag = "bean";
        String beanAttrId = "id";
        String beanAttrClazz = "class";
        String beanAttrSigleton = "singleton";
        for (int i = 0; i < this.m_listBeanConfigCollection.size(); ++i) {
            BeanConfig bean = (BeanConfig)this.m_listBeanConfigCollection.get(i);
            Element elm = DocumentHelper.createElement((String)beanTag);
            elm.addAttribute(beanAttrId, bean.getId());
            elm.addAttribute(beanAttrClazz, bean.getClassName());
            if (bean.isSingleton()) {
                elm.addAttribute(beanAttrSigleton, "true");
            } else {
                elm.addAttribute(beanAttrSigleton, "false");
            }
            this.m_elBeansRoot.add(elm);
        }
        this.m_oBeansDocument.setXMLEncoding("utf-8");
        return BeanConfigHelper.getInputStream(this.m_oBeansDocument.asXML(), "utf-8");
    }

    private static InputStream getInputStream(String _sValue, String _sEncoding) throws CMyException {
        try {
            byte[] bytes = _sValue.getBytes(_sEncoding);
            return new ByteArrayInputStream(bytes);
        }
        catch (Exception ex) {
            throw new CMyException("Failed to convert string into utf-8 stream.", ex);
        }
    }

    public void unload() {
        this.m_elBeansRoot = null;
        this.m_oBeansDocument = null;
        this.m_listBeanConfigCollection.clear();
    }

    public static void checkIsBeanValid(String _beanId, String _sName) {
        if (!BeanConfigServer.started()) {
            return;
        }
        if (!BeanConfigServer.getInstance().containsBean(_beanId)) {
            throw new RuntimeException("[name=" + _sName + I18NMessage.get(BeanConfigHelper.class, "BeanConfigHelper.label2", "]\u7684\u914d\u7f6e\u5bf9\u8c61\uff0c\u5176[BeanId=") + _beanId + I18NMessage.get(BeanConfigHelper.class, "BeanConfigHelper.label3", "]\u65e0\u6548\uff01"));
        }
    }

    public static void checkIsBeanValid(String _beanId) {
        BeanConfigHelper.checkIsBeanValid(_beanId, "UNKOWN");
    }
}

