/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wechat.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.service.MetaDataCenterServiceProvider;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wechat.IWeChatMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.controler.JSPRequestProcessor;
import com.trs.webframework.provider.IQueryServiceProvider;
import com.trs.webframework.provider.ISaveServiceProvider;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;

public class WXMContentServicePrivider
implements IQueryServiceProvider,
ISelfDefinedServiceProvider,
ISaveServiceProvider {
    private IWeChatMgr m_WeChatMgr = (IWeChatMgr)DreamFactory.createObjectById("IWeChatMgr");

    public String queryCustomMenuContent(MethodContext context) throws Throwable {
        int menuId = context.getValue("menuId", -1);
        int pageSize = context.getValue("pageSize", 10);
        int currPage = context.getValue("currPage", 1);
        String keyWord = context.getValue("keyWord");
        int pageIndex = (currPage - 1) * pageSize;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ChannelIds", menuId);
        param.put("PageSize", pageSize);
        param.put("CurrPage", currPage);
        if (!CMyString.isEmpty(keyWord)) {
            param.put("DOCTITLE", keyWord);
            param.put("CRUSER", keyWord);
            param.put("DOCKEYWORDS", keyWord);
            param.put("ISOR", true);
        }
        param.put("DocumentSelectFields", "CRUSER,DOCTITLE,CRTIME");
        JSPRequestProcessor oProcessor = new JSPRequestProcessor();
        ViewDocuments viewDocuments = (ViewDocuments)oProcessor.excute("wcm6_viewdocument", "query", param);
        StringBuffer bJson = new StringBuffer();
        bJson.append("{\"data\":[");
        int maxSize = pageIndex + pageSize >= viewDocuments.size() ? viewDocuments.size() : pageIndex + pageSize;
        int metaDocCount = 0;
        for (int i = pageIndex; i < maxSize; ++i) {
            ViewDocument viewDocument = (ViewDocument)viewDocuments.getAt(i);
            Document document = Document.findById(viewDocument.getId());
            if (document.getPropertyAsInt("DOCKIND", 0) != 0) {
                ++metaDocCount;
                continue;
            }
            String title = CMyString.showEmpty(document.getPropertyAsString("DOCTITLE"));
            String crtime = document.getCrTime().toString();
            String author = document.getCrUserName();
            bJson.append("{\"title\": \"").append(title).append("\" ,\"recid\": \"").append(viewDocument.getChnlDocProperty("RECID", -1)).append("\" ,\"crtime\": \"").append(crtime).append("\" ,\"author\": \"").append(author).append("\"},");
        }
        if (viewDocuments.size() != 0) {
            bJson.deleteCharAt(bJson.length() - 1);
        }
        bJson.append("],\"num\":\"").append(viewDocuments.size() - metaDocCount).append("\" ,\"currPage\": \"").append(currPage).append("\" ,\"pageSize\": \"").append(pageSize).append("\"}");
        String callBack = context.getValue("callback");
        if (!CMyString.isEmpty(callBack)) {
            return callBack + "(" + bJson.toString() + ")";
        }
        return bJson.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String query(MethodContext context) throws Throwable {
        int menuId = context.getValue("menuId", -1);
        Channel channel = Channel.findById(menuId);
        String link = channel.getLinkUrl();
        int pageSize = context.getValue("pageSize", 10);
        int currPage = context.getValue("currPage", 1);
        if (channel.getType() == 11) {
            String bJson = "{\"data\":[{\"title\":\"\" ,\"content\":\"\" ,\"crtime\": \"\" ,\"link\": \"" + link + "\" ,\"prewUrl\": \"\" ,\"appfile\": \"\" ,\"appdesc\": \"\"}],\"num\":\"1\" ,\"currPage\": \"" + currPage + "\" ,\"pageSize\": \"" + pageSize + "\"}";
            return bJson;
        }
        int pageIndex = (currPage - 1) * pageSize;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ChannelIds", menuId);
        param.put("PageSize", pageSize);
        param.put("CurrPage", currPage);
        param.put("DocumentSelectFields", "DOCCONTENT,DOCTITLE,CRTIME");
        String keywords = context.getValue("DOCKEYWORDS");
        if (!CMyString.isEmpty(keywords)) {
            param.put("CRUSER", keywords);
            param.put("DOCTITLE", keywords);
            param.put("ISOR", "true");
        }
        JSPRequestProcessor oProcessor = new JSPRequestProcessor();
        ViewDocuments viewDocuments = (ViewDocuments)oProcessor.excute("wcm6_viewdocument", "query", param);
        StringBuffer bJson = new StringBuffer();
        bJson.append("{\"data\":[");
        int maxSize = pageIndex + pageSize >= viewDocuments.size() ? viewDocuments.size() : pageIndex + pageSize;
        boolean flag = false;
        for (int i = pageIndex; i < maxSize; ++i) {
            String prewUrl = "";
            String appfile = "";
            String appdesc = "";
            ViewDocument viewDocument = (ViewDocument)viewDocuments.getAt(i);
            Document document = Document.findById(viewDocument.getId());
            if (document.getPropertyAsInt("DOCKIND", 0) != 0) continue;
            String title = URLEncoder.encode(CMyString.showEmpty(document.getPropertyAsString("DOCTITLE")), "utf-8");
            String content = URLEncoder.encode(CMyString.showEmpty(document.getPropertyAsString("DOCCONTENT")), "utf-8");
            String crtime = document.getCrTime().toString();
            String author = document.getCrUser().getTrueName();
            PublishPathCompass compass = new PublishPathCompass();
            try {
                prewUrl = this.getPublishUrl(document.getId());
            }
            finally {
                compass.clear();
            }
            AppendixMgr m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
            Appendixes appendixes = m_oAppendixMgr.getAppendixes(document, 20, null);
            if (!appendixes.isEmpty()) {
                Appendix appendix = (Appendix)appendixes.getAt(0);
                appfile = appendix.getPropertyAsString("APPFILE");
                appdesc = appendix.getPropertyAsString("APPDESC");
            }
            bJson.append("{\"title\": \"").append(title).append("\" ,\"recid\": \"").append(viewDocument.getChnlDocProperty("RECID", -1)).append("\" ,\"docId\": \"").append(viewDocument.getDocId()).append("\" ,\"content\": \"").append(content).append("\" ,\"author\": \"").append(author).append("\" ,\"crtime\": \"").append(crtime).append("\" ,\"link\": \"").append(link).append("\" ,\"prewUrl\": \"").append(prewUrl).append("\" ,\"appfile\": \"").append(appfile).append("\" ,\"appdesc\": \"").append(appdesc).append("\"},");
            flag = true;
        }
        if (flag) {
            bJson.deleteCharAt(bJson.length() - 1);
        }
        bJson.append("],\"num\":\"").append(viewDocuments.size()).append("\" ,\"currPage\": \"").append(currPage).append("\" ,\"pageSize\": \"").append(pageSize).append("\"}");
        return bJson.toString();
    }

    private String getPublishUrl(int docId) throws WCMException {
        IPublishContent oPublishContent = (IPublishContent)PublishElementFactory.lookupElement(605, docId);
        Document doc = Document.findById(docId);
        IPublishFolder oPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(doc.getChannel());
        oPublishContent.setFolder(oPublishFolder);
        Template template = oPublishContent.getDetailTemplate();
        if (template == null) {
            return "";
        }
        String sFileExt = template.getOutputFileExt();
        String sFileName = PublishPathCompass.makeDetailPageFileName(oPublishContent);
        String fileName = sFileName + "." + sFileExt;
        PublishPathCompass compass = new PublishPathCompass();
        String m_sPageHttpPath = compass.getAbsoluteHttpPath(oPublishContent);
        String url = m_sPageHttpPath + fileName;
        return url;
    }

    @Override
    public int save(MethodContext context) throws Throwable {
        User currUser = this.getLoginUser();
        int menuId = context.getValue("menuId", -1);
        Channel oChannel = Channel.findById(menuId);
        int recId = context.getValue("recid", 0);
        ChnlDoc chnlDoc = ChnlDoc.findById(recId);
        if (recId != 0 && chnlDoc == null) {
            throw new WCMException("\u4e0d\u5b58\u5728recId\uff1a" + recId + "\u7684\u8bb0\u5f55");
        }
        int docId = chnlDoc == null ? 0 : chnlDoc.getDocumentId();
        String chnlType = oChannel.getAttributeValue("chnlType");
        String content = context.getValue("content");
        context.setValue("content", content);
        String contentHtml = context.getValue("contentHtml");
        String title = context.getValue("title");
        String DOCABSTRACT = context.getValue("DOCABSTRACT");
        String APPFILE = context.getValue("APPFILE");
        String SRCFILE = context.getValue("SRCFILE");
        if (chnlType.equals("2")) {
            String linkUrl = context.getValue("link");
            oChannel.setLinkUrl(linkUrl);
            oChannel.save(currUser);
            return menuId;
        }
        if ("0".equals(chnlType) || "3".equals(chnlType)) {
            context.setValue("OBJECTID", docId);
            context.setValue("CHANNELID", oChannel.getId());
            MetaDataCenterServiceProvider oMetaDataCenterSP = new MetaDataCenterServiceProvider();
            MetaViewData mData = oMetaDataCenterSP.saveMetaViewData(context);
            this.publishContent(mData);
            int chnlDocId = ChnlDoc.findByDocAndChnl(mData.getId(), menuId).getId();
            return chnlDocId;
        }
        JSPRequestProcessor processsor = new JSPRequestProcessor();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("OBJECTID", docId);
        params.put("CHANNELID", menuId);
        params.put("DOCCONTENT", CMyString.showEmpty(content));
        params.put("DOCHTMLCON", contentHtml);
        params.put("DOCTITLE", CMyString.showEmpty(title));
        params.put("DOCABSTRACT", CMyString.showEmpty(DOCABSTRACT));
        params.put("DOCTYPE", 20);
        params.put("DOCFORM", 0);
        recId = (Integer)processsor.excute("wcm6_document", "save", params);
        if (!CMyString.isEmpty(APPFILE) && !CMyString.isEmpty(SRCFILE)) {
            String appendixesxml = "<OBJECTS><OBJECT ID=\"0\" APPFILE=\"" + APPFILE + "\" SRCFILE=\"" + SRCFILE + "\" APPLINKALT=\"" + SRCFILE + "\" APPFLAG=\"20\" APPDESC=\"" + SRCFILE + "\" ATTRIBUTE=\"\"/></OBJECTS>";
            appendixesxml = appendixesxml.replaceAll("&", "&amp;");
            HashMap<String, Object> params2 = new HashMap<String, Object>();
            params2.put("DOCID", recId);
            params2.put("APPENDIXTYPE", 20);
            params2.put("APPENDIXESXML", appendixesxml);
            processsor.excute("wcm6_document", "saveAppendixes", params2);
        }
        params = new HashMap();
        params.put("OBJECTIDS", recId + "");
        params.put("OBJECTTYPE", "605");
        processsor.excute("wcm6_publish", "directPublish", params);
        int _recId = ChnlDoc.findByDocAndChnl(recId, menuId).getId();
        String newsId = context.getValue("newsId");
        this.quote(_recId + "", menuId + "", newsId);
        return recId;
    }

    private void publishFolder(Channel channel) throws WCMException {
        IPublishFolder oPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        if (oPublishFolder == null) {
            return;
        }
        PublishServer.getInstance().publishFolder(oPublishFolder, 8);
    }

    public String saveContent(MethodContext context) throws Throwable {
        int id = this.save(context);
        if (!CMyString.isEmpty(context.getValue("callback"))) {
            return context.getValue("callback") + "(" + id + ")";
        }
        return id + "";
    }

    private void publishContent(MetaViewData oViewData) throws WCMException {
        if (oViewData != null) {
            IPublishContent oPublishContent = (IPublishContent)PublishElementFactory.lookupElement(605, oViewData.getId());
            IPublishFolder oPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(oViewData.getChannel());
            oPublishContent.setFolder(oPublishFolder);
            PublishServer.getInstance().publishContent(oPublishContent, 10);
        }
    }

    public void remove(MethodContext context) throws Throwable {
        int documentId = context.getValue("recIds", -1);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ObjectIds", documentId);
        param.put("Drop", "true");
        JSPRequestProcessor oProcessor = new JSPRequestProcessor();
        oProcessor.excute("wcm61_viewdocument", "delete", param);
    }

    public void quote(String recIds, String channelIds, String tochannelids) throws Throwable {
        JSPRequestProcessor processsor = new JSPRequestProcessor();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("OBJECTIDS", recIds);
        param.put("TOCHANNELIDS", tochannelids);
        processsor.excute("wcm6_viewdocument", "mirror", param);
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }

    public String getContentById(MethodContext _methodContext) throws WCMException, UnsupportedEncodingException {
        int recid = _methodContext.getValue("recid", 0);
        int menuId = _methodContext.getValue("menuId", 0);
        if (recid == 0 && menuId == 0) {
            throw new WCMException("\u6ca1\u6709\u4f20\u9012\u6587\u6863id");
        }
        ChnlDoc chnlDoc = ChnlDoc.findById(recid);
        String chnlType = "";
        String link = "";
        if (chnlDoc != null) {
            chnlType = chnlDoc.getChannel().getAttributeValue("chnlType");
        } else {
            Channel channel = Channel.findById(menuId);
            chnlType = channel.getAttributeValue("chnlType");
            link = channel.getLinkUrl();
        }
        StringBuilder sdata = new StringBuilder();
        if ("0".equals(chnlType)) {
            MetaViewData data = MetaViewData.findById(chnlDoc.getDocId());
            String content = data.getPropertyAsString("content");
            sdata.append("{\"content\":\"");
            content = CMyString.filterForJson(content);
            sdata.append(content);
            sdata.append("\"}");
            return sdata.toString();
        }
        if ("1".equals(chnlType)) {
            String appPic = this.getAppendixImages(chnlDoc.getDocument());
            sdata.append("{\"title\":\"");
            Document doc = chnlDoc.getDocument();
            sdata.append(CMyString.filterForJson(doc.getTitle()));
            sdata.append("\",\"htmlContent\":\"");
            sdata.append(CMyString.filterForJson(doc.getHtmlContentWithImgFilter(null, false)));
            sdata.append("\",\"content\":\"");
            sdata.append(CMyString.filterForJson(doc.getContent()));
            sdata.append("\",\"docabstract\":\"");
            sdata.append(CMyString.filterForJson(doc.getAbstract()));
            sdata.append("\",\"appPic\":\"");
            sdata.append(appPic);
            sdata.append("\",\"link\":\"");
            sdata.append("\"}");
            return sdata.toString();
        }
        if ("2".equals(chnlType)) {
            sdata.append("{\"link\":\"");
            sdata.append(link);
            sdata.append("\"}");
            return sdata.toString();
        }
        return "";
    }

    private String getAppendixImages(Document _document) throws WCMException {
        AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        Appendixes aApps = appendixMgr.getAppendixes(_document, 20);
        if (aApps.size() > 0) {
            return ((Appendix)aApps.getAt(0)).getFile();
        }
        return "";
    }

    public void changeOrder() {
    }
}

