/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.resource;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class Status
extends CMSObj {
    private static Logger logger = Logger.getLogger(Status.class);
    public static final int OBJ_TYPE = 610;
    public static final String DB_TABLE_NAME = "WCMSTATUS";
    public static final String DB_ID_NAME = "STATUSID";
    public static final int STATUS_ID_UNKNOWN = 0;
    public static final int STATUS_ID_NEW = 1;
    public static final int STATUS_ID_EDITED = 2;
    public static final int STATUS_ID_AGAIN = 3;
    public static final int STATUS_ID_PUBLISHED = 10;
    public static final int STATUS_ID_NO = 15;
    public static final int STATUS_ID_SIGN = 16;
    public static final int STATUS_ID_VERIFY = 18;
    public static final int STATUS_NOT_ACCEPTED = 21;
    public static final int STATUS_ACCEPTED = 22;
    public static final int STATUS_ID_IN_DESTROY = 1026;
    public static final int STATUS_ID_PUBLISHED_AFTER_EDIT = 1027;
    public static final int STATUS_ID_DRAFT = 1028;
    public static final String STATUS_DESC_EDITED = "[\u5f85\u7f16]";
    public static final String STATUS_DESC_VERIFY = "[\u5f85\u5ba1]";
    public static final String STATUS_DESC_SIGN = "[\u5f85\u7b7e]";
    public static final String STATUS_DESC_PUBLISHED = "[\u5df2\u53d1]";
    public static final int[] STATUS_CAN_DO_PUB = new int[]{10, 1027};
    public static final int STATUS_ID_USERDEF = 30;
    public static final int TYPE_FOR_SET_DOC = 1;
    public static final int TYPE_FOR_WORKFLOW = 2;
    public static final int TYPE_FOR_ALL = 3;
    public static final int TYPE_DO_NOT_SHOW = 0;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 610;
    }

    public String getName() {
        return (String)this.getProperty("SNAME");
    }

    public boolean setName(String _name) throws WCMException {
        return this.setProperty("SNAME", _name);
    }

    public String getDesc() {
        return (String)this.getProperty("SDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("SDESC", _desc);
    }

    public String getDisp() {
        return (String)this.getProperty("SDISP");
    }

    public boolean setDisp(String _disp) throws WCMException {
        return this.setProperty("SDISP", _disp);
    }

    public boolean isUsed() {
        return this.getPropertyAsBoolean("SUSED", true);
    }

    public boolean setUsed(boolean _bUsed) throws WCMException {
        return this.setProperty("SUSED", _bUsed);
    }

    public int getType() {
        return this.getPropertyAsInt("STYPE", 3);
    }

    public boolean setType(int _nType) throws WCMException {
        return this.setProperty("STYPE", _nType);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sName = null;
        if (this.isAddMode()) {
            sName = (String)this.getAllProperty().get("SNAME");
            if (sName == null) {
                throw new WCMException(1106, I18NMessage.get(Status.class, "Status.label1", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(Status.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Status.class, "Status.label2", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Status.isValid)"));
            }
            sName = (String)this.getNewProperty("SNAME");
        }
        if (sName != null) {
            String strCondition = " SName='" + CMyString.filterForSQL(sName) + "'";
            if (!this.isAddMode()) {
                strCondition = strCondition + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.checkExists(strCondition)) {
                throw new WCMException(1108, I18NMessage.get(Status.class, "Status.label3", "\u72b6\u6001\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff08Status.isValid\uff09"));
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(_currUser);
        }
    }

    public int getRightIndex() {
        return this.getPropertyAsInt("RIGHTINDEX", 35);
    }

    public boolean setRightIndex(int _rightIndex) throws WCMException {
        return this.setProperty("RIGHTINDEX", _rightIndex);
    }

    public static final Status findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Status)BaseObj.findById(Status.class, _nId);
    }

    public static final Status createNewInstance() throws WCMException {
        return (Status)BaseObj.createNewInstance(Status.class);
    }

    public static final Status findByKey(Object _oKey) throws WCMException {
        return (Status)BaseObj.findByKey(Status.class, _oKey);
    }

    public static int[] getStatusCanDoPubInOutline() {
        try {
            String isPageDestroy = ConfigServer.getServer().getSysConfigValue("PageDestroyWhenModifyPublishStatusDoc", "false");
            String sStatusCanDocPubInOutline = ConfigServer.getServer().getSysConfigValue("StatusCanDocPubInOutline", String.valueOf(10));
            if (isPageDestroy.equalsIgnoreCase("true") || isPageDestroy.equalsIgnoreCase("1")) {
                return CMyString.splitToInt(sStatusCanDocPubInOutline, ",");
            }
            String sPublishedDocumentContainsEdit = ConfigServer.getServer().getSysConfigValue("PublishedDocumentContainsEdit", "false").trim();
            sStatusCanDocPubInOutline = ConfigServer.getServer().getSysConfigValue("StatusCanDocPubInOutline", "10,1027");
            if (sPublishedDocumentContainsEdit.equalsIgnoreCase("true") || sPublishedDocumentContainsEdit.equalsIgnoreCase("1")) {
                return CMyString.splitToInt(sStatusCanDocPubInOutline, sStatusCanDocPubInOutline);
            }
        }
        catch (WCMException e) {
            logger.error((Object)"Fail to get published status!", (Throwable)e);
        }
        return new int[]{10};
    }

    public String translateIdToDesc(int statusId) {
        String statusDesc;
        switch (statusId) {
            case 1: {
                statusDesc = STATUS_DESC_EDITED;
                break;
            }
            case 2: {
                statusDesc = STATUS_DESC_EDITED;
                break;
            }
            case 18: {
                statusDesc = STATUS_DESC_VERIFY;
                break;
            }
            case 16: {
                statusDesc = STATUS_DESC_SIGN;
                break;
            }
            case 10: {
                statusDesc = STATUS_DESC_PUBLISHED;
                break;
            }
            default: {
                statusDesc = "";
            }
        }
        return statusDesc;
    }
}

