/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.element;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.taskdispatch.IPublishElementsIterator;
import com.trs.components.common.publish.persistent.element.IFolderQuoter;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.element.PublishElementsCMSListImpl;
import com.trs.components.common.publish.persistent.element.PublishElementsCMSObjsImpl;
import com.trs.components.common.publish.persistent.element.PublishFolderImplBase;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.components.wcm.publish.element.PublishElementsIteratorDocumentsImpl;
import com.trs.components.wcm.publish.element.PublishFolderWebSiteImpl;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class PublishFolderChannelImpl
extends PublishFolderImplBase
implements IFolderQuoter {
    private static final Logger logger = Logger.getLogger((String)PublishFolderChannelImpl.class.getName());
    private Channel m_channel;

    public PublishFolderChannelImpl() {
    }

    public PublishFolderChannelImpl(Channel _channel) {
        this.setSubstance(_channel);
    }

    @Override
    public int getType() {
        return 101;
    }

    @Override
    public CMSObj getSubstance() {
        return this.m_channel;
    }

    @Override
    public void setSubstance(CMSObj _cmsObj) {
        this.m_channel = (Channel)_cmsObj;
    }

    @Override
    public boolean loadById(int _nId) throws WCMException {
        this.m_channel = Channel.findById(_nId);
        return this.m_channel != null;
    }

    @Override
    public IPublishElements getIncreasedContents(WCMFilter _filter) throws Exception {
        IPublishFolder root = this.getRoot();
        IFolderPubStatusCacheMgr m_oCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        return this.getContents(m_oCacheMgr.findStatusesCanDoIncreasePub(root.getType(), root.getId()), _filter);
    }

    @Override
    public IPublishElements getPublishedContents(WCMFilter _filter) throws Exception {
        return this.getContents(new int[]{10}, _filter);
    }

    @Override
    public IPublishElements getAllContents(WCMFilter _filter) throws Exception {
        IPublishFolder root = this.getRoot();
        IFolderPubStatusCacheMgr m_oCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        return this.getContents(m_oCacheMgr.findStatusesCanDoPub(root.getType(), root.getId()), _filter);
    }

    private IPublishElements getContents(int[] _pStatuses, WCMFilter _filter) throws Exception {
        if (_pStatuses == null || _pStatuses.length <= 0) {
            return null;
        }
        DebugTimer aTimer = new DebugTimer();
        aTimer.start();
        WCMFilter filter = new WCMFilter("", "", "");
        filter.setMaxRowNumber(PublishServerConfigMapper.getTemplateParseConfig().getWcmOutlineContentsMaxNum());
        String sWhere = "WCMCHNLDOC.DOCSTATUS in(?";
        filter.addSearchValues(0, _pStatuses[0]);
        int nSize = _pStatuses.length;
        for (int i = 1; i < nSize; ++i) {
            sWhere = sWhere + ",?";
            filter.addSearchValues(i, _pStatuses[i]);
        }
        sWhere = sWhere + ")";
        filter.setWhere(sWhere);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getContents: Where=" + sWhere));
        }
        if (_filter != null) {
            filter.mergeWith(_filter);
        }
        Documents docs = null;
        if (Document.DOCUMENTS_GET_OPTIMIZE) {
            docs = DocumentsGetHelper.getDocuments(this.m_channel, filter);
        } else {
            DocumentMgr mgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
            docs = mgr.getDocuments(this.m_channel, filter);
        }
        aTimer.stop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getContents use [" + aTimer.getTime() + "]ms\nSQL:" + docs.getFilter().toSQL()));
        }
        if (docs == null || docs.isEmpty()) {
            return null;
        }
        return new PublishElementsCMSObjsImpl(docs);
    }

    @Override
    public boolean isLink() {
        return this.m_channel.isLink();
    }

    @Override
    public String getLinkUrl() {
        return this.m_channel.getLinkUrl();
    }

    @Override
    public int getId() {
        return this.m_channel == null ? 0 : this.m_channel.getId();
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public IPublishFolder getRoot() throws WCMException {
        PublishFolderWebSiteImpl root = null;
        if (this.m_channel != null) {
            WebSite site = this.m_channel.getSite();
            if (site == null) {
                throw new WCMException(I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label1", "\u6307\u5b9a\u7684\u680f\u76ee[Id=") + this.m_channel.getId() + ",Name=" + this.m_channel.getName() + I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label2", "]\u6240\u5c5e\u7ad9\u70b9[SiteId=") + this.m_channel.getSiteId() + I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label3", "]\u4e0d\u5b58\u5728!"));
            }
            root = new PublishFolderWebSiteImpl(site);
        }
        return root;
    }

    @Override
    public void makeFrom(CMSObj _cmsObj) {
        this.m_channel = (Channel)_cmsObj;
    }

    @Override
    public IPublishFolder getParent() throws WCMException {
        if (this.m_channel == null) {
            return null;
        }
        Channel parent = this.m_channel.getParent();
        PublishFolderImplBase folder = parent == null ? new PublishFolderWebSiteImpl(this.m_channel.getSite()) : new PublishFolderChannelImpl(parent);
        return folder;
    }

    @Override
    public IPublishElements getChildren() throws WCMException {
        List<Channel> children = this.m_channel.getChildren(ContextHelper.getLoginUser());
        if (children == null) {
            return null;
        }
        return new PublishElementsCMSListImpl(children);
    }

    @Override
    public int getSiblingIndex() throws WCMException {
        return this.m_channel.getSiblingIndex();
    }

    @Override
    public boolean validateCanDoPub() throws WCMException {
        int nChannelType = this.m_channel.getType();
        if (nChannelType == 2 || nChannelType == 1) {
            return true;
        }
        if (!this.m_channel.isCanPub()) {
            throw new WCMDatainvalidException(200004, CMyString.format(I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label4", "[{0}]\u8bbe\u7f6e\u4e3a\u4e0d\u53ef\u53d1\u5e03\uff01"), new String[]{this.getInfo()}));
        }
        FolderPublishConfig folderConfig = FolderPublishConfig.findOf(this);
        if (folderConfig == null) {
            throw new WCMDatainvalidException(200001, CMyString.format(I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label5", "[{0}]\u6ca1\u6709\u8bbe\u7f6e\u53d1\u5e03\u5c5e\u6027!"), new String[]{this.getInfo()}));
        }
        Templates templates = this.getOutlineTemplates();
        if (templates == null || templates.isEmpty()) {
            throw new WCMDatainvalidException(200002, CMyString.format(I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label6", "[{0}]\u6ca1\u6709\u8bbe\u7f6e\u6982\u89c8\u6a21\u677f\uff01"), new String[]{this.getInfo()}));
        }
        return true;
    }

    @Override
    public boolean canDoOutlinePageTask() {
        if (this.m_channel == null || this.m_channel.isDeleted()) {
            return false;
        }
        int nChannelType = this.m_channel.getType();
        if (nChannelType == 2 || nChannelType == 1) {
            return false;
        }
        Templates templates = this.getOutlineTemplates();
        return templates != null && !templates.isEmpty();
    }

    @Override
    public boolean canDoDetailPageTask() {
        if (this.m_channel == null) {
            return false;
        }
        int nChannelType = this.m_channel.getType();
        if (nChannelType == 2 || nChannelType == 1) {
            return true;
        }
        if (!this.m_channel.isCanPub()) {
            return false;
        }
        return this.getDetailTemplate() != null;
    }

    @Override
    public boolean isValidElement() {
        if (this.m_channel == null) {
            return false;
        }
        try {
            this.validateCanDoPub();
            return true;
        }
        catch (WCMDatainvalidException wCMDatainvalidException) {
        }
        catch (WCMException e) {
            logger.error((Object)(I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label7", "\u5224\u65ad\u53d1\u5e03\u5143\u7d20:") + this.getInfo() + I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label8", "\u7684\u6709\u6548\u6027\u5931\u8d25!")), (Throwable)e);
        }
        return false;
    }

    @Override
    public void validateCanDoPreview() throws WCMException {
        FolderPublishConfig folderConfig = FolderPublishConfig.findOf(this);
        if (folderConfig == null) {
            throw new WCMDatainvalidException(200001, CMyString.format(I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label5", "[{0}]\u6ca1\u6709\u8bbe\u7f6e\u53d1\u5e03\u5c5e\u6027!"), new String[]{this.getInfo()}));
        }
        Templates templates = this.getOutlineTemplates();
        if (templates == null || templates.isEmpty()) {
            throw new WCMDatainvalidException(200002, CMyString.format(I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label6", "[{0}]\u6ca1\u6709\u8bbe\u7f6e\u6982\u89c8\u6a21\u677f\uff01"), new String[]{this.getInfo()}));
        }
    }

    @Override
    public boolean canDoPreview() {
        try {
            FolderPublishConfig folderConfig = FolderPublishConfig.findOf(this);
            if (folderConfig == null) {
                return false;
            }
            return !this.getOutlineTemplates().isEmpty();
        }
        catch (Exception e) {
            logger.error((Object)(I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label9", "\u5224\u65ad ") + this.getInfo() + I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label10", " \u662f\u5426\u53ef\u4ee5\u9884\u89c8\u53d1\u751f\u5f02\u5e38\uff01")), (Throwable)e);
            return false;
        }
    }

    @Override
    public IPublishElementsIterator getIncreasedContentsIterator(WCMFilter _filter) throws Exception {
        IPublishFolder root = this.getRoot();
        IFolderPubStatusCacheMgr m_oCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        return this.getContentsIterator(m_oCacheMgr.findStatusesCanDoIncreasePub(root.getType(), root.getId()), _filter);
    }

    @Override
    public IPublishElementsIterator getAllContentsIterator(WCMFilter _filter) throws Exception {
        IPublishFolder root = this.getRoot();
        IFolderPubStatusCacheMgr m_oCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        return this.getContentsIterator(m_oCacheMgr.findStatusesCanDoPub(root.getType(), root.getId()), _filter);
    }

    @Override
    public IPublishElementsIterator getPublishedContentsIterator(WCMFilter _filter) throws Exception {
        return this.getContentsIterator(new int[]{10}, _filter);
    }

    private IPublishElementsIterator getContentsIterator(int[] _pStatuses, WCMFilter _filter) throws Exception {
        WCMFilter filter = new WCMFilter("", "", "");
        filter.setMaxRowNumber(PublishServerConfigMapper.getTemplateParseConfig().getWcmOutlineContentsMaxNum());
        String sWhere = "WCMCHNLDOC.DOCSTATUS";
        sWhere = "DOCSTATUS in(?";
        filter.addSearchValues(0, _pStatuses[0]);
        int nSize = _pStatuses.length;
        for (int i = 1; i < nSize; ++i) {
            sWhere = sWhere + ",?";
            filter.addSearchValues(i, _pStatuses[i]);
        }
        sWhere = sWhere + ")";
        filter.setWhere(sWhere);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getContents: Where=" + sWhere));
        }
        if (_filter != null) {
            filter.mergeWith(_filter);
        }
        WCMFilter documentsFilter = null;
        if (Document.DOCUMENTS_GET_OPTIMIZE) {
            documentsFilter = DocumentsGetHelper.makeChannelFilter(this.m_channel, filter);
        } else {
            DocumentMgr mgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
            documentsFilter = mgr.getFilterForDocuments(this.m_channel, filter);
        }
        return new PublishElementsIteratorDocumentsImpl(documentsFilter);
    }

    @Override
    public boolean canDoBatchDetailPageTask() {
        return this.canDoDetailPageTask();
    }

    @Override
    public boolean isCanDoSave(User _loginUser) throws WCMException {
        return AuthServer.hasRight(_loginUser, (CMSObj)this.m_channel, 13);
    }

    @Override
    public boolean isDeleted() {
        return this.m_channel.isDeleted();
    }

    @Override
    public void setPublishStatus(int _nStatus) throws WCMException {
        if (_nStatus == 10 && this.m_channel.isCanPub()) {
            User currUser = ContextHelper.getLoginUser();
            if (this.m_channel.canEdit(currUser)) {
                try {
                    this.m_channel.setCanPub(false);
                    this.m_channel.update(currUser);
                }
                finally {
                    if (this.m_channel.isLocked()) {
                        this.m_channel.cancelUpdate(currUser);
                    }
                }
            }
            String sUpdatePublishedDocumentDocChannel = "update WCMDocument set DocStatus=? where DocChannel=? and DocStatus=?";
            String sUpdatePublishedChnlDocChnlId = "update WCMChnlDoc set DocStatus=?, PubStatus = ? where ChnlId=?  and DocStatus=?";
            String sUpdateChnlDocDocChannel = "update WCMChnlDoc set DocStatus=?, PubStatus = ? where DocChannel=? and DocStatus=?";
            int[] documentParams = new int[]{16, this.m_channel.getId(), 10};
            int[] chnldocParams = new int[]{16, MetaDataConstants.PubStatusEnum.NOTPUBLISHED.value, this.m_channel.getId(), 10};
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{sUpdatePublishedDocumentDocChannel}, documentParams);
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{sUpdatePublishedChnlDocChnlId, sUpdateChnlDocDocChannel}, chnldocParams);
        }
    }

    public String toString() {
        return this.getInfo();
    }

    @Override
    public Collection getFoldersQuotingMe(boolean _bContainsContent) throws WCMException {
        Collection quoters = this.getFoldersQuotingMe();
        if (!_bContainsContent) {
            return quoters;
        }
        Collection quotersOfContent = this.getFoldersQuotingCotnent();
        quoters = this.mergeWith(quoters, quotersOfContent);
        return quoters;
    }

    private Collection getFoldersQuotingCotnent() throws WCMException {
        String sQuerySQL = "select ChannelId from WCMChannel where exists(select 1 from WCMChnlDoc where docchannel=? and (modal=2 or modal=3) and WCMChannel.ChannelId=WCMChnlDoc.ChnlId)";
        DebugTimer timer = new DebugTimer();
        timer.start();
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet rsData = null;
        ArrayList<IPublishElement> quotersList = null;
        DBManager dbManager = DBManager.getDBManager();
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement(sQuerySQL);
            oPreStmt.setInt(1, this.m_channel.getId());
            rsData = oPreStmt.executeQuery();
            quotersList = new ArrayList<IPublishElement>();
            while (rsData.next()) {
                int nFolderId = rsData.getInt(1);
                IPublishElement aFolder = PublishElementFactory.lookupElement(this.m_channel.getWCMType(), nFolderId);
                quotersList.add(aFolder);
            }
            rsData.close();
            oPreStmt.close();
            oPreStmt = null;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to Desc!", ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
        timer.stop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get[" + this.m_channel.getInfo() + "] contentQuote use [" + timer.getTime() + "]ms"));
        }
        return quotersList;
    }

    private Collection mergeWith(Collection collection1, Collection collection2) {
        if (collection1 == null || collection1.isEmpty()) {
            return collection2;
        }
        if (collection2 == null || collection2.isEmpty()) {
            return collection1;
        }
        for (Object object : collection2) {
            if (collection1.contains(object)) continue;
            collection1.add(object);
        }
        return collection1;
    }
}

