/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.trsserver;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.I18NMessage;
import java.util.HashMap;

public class TreeNode {
    private Channels m_srcChannels = null;
    private User m_oLoginUser = null;
    private int m_nDocumentsCount = 0;
    private Channel m_oChannel = null;
    private TreeNode[] m_pChildrenNodes = null;
    private int[] m_pChildrenIds = null;
    private int m_nChildrenCount = 0;
    private int m_nMaxChildCount = 30;
    private int[] m_pClassInfos = null;
    private HashMap m_hDocumentsCountCache = null;

    public TreeNode(User _loginUser, int[] _pClassInfos) {
        this.m_oLoginUser = _loginUser;
        this.m_pClassInfos = _pClassInfos;
        if (_pClassInfos != null) {
            this.m_nMaxChildCount = _pClassInfos.length;
        }
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(I18NMessage.get(TreeNode.class, "TreeNode.label1", "\u521d\u59cb\u5316\u5bf9\u8c61\u5931\u8d25\uff01"), e);
        }
    }

    public TreeNode(User _loginUser, String _sClassInfos) {
        String[] pTemp = _sClassInfos.split(",");
        this.m_pClassInfos = new int[pTemp.length];
        if (pTemp != null) {
            this.m_nMaxChildCount = pTemp.length;
        }
        for (int i = 0; i < pTemp.length; ++i) {
            this.m_pClassInfos[i] = Integer.parseInt(pTemp[i]);
        }
        this.m_oLoginUser = _loginUser;
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(I18NMessage.get(TreeNode.class, "TreeNode.label1", "\u521d\u59cb\u5316\u5bf9\u8c61\u5931\u8d25\uff01"), e);
        }
    }

    public TreeNode(Channel _channel, int _nChildMaxCount) {
        this.m_oChannel = _channel;
        this.m_nMaxChildCount = _nChildMaxCount;
        this.m_pChildrenIds = new int[_nChildMaxCount];
        this.m_pChildrenNodes = new TreeNode[_nChildMaxCount];
    }

    private TreeNode addNeedExpandNode(Channel _channel) {
        for (int i = 0; i < this.m_nChildrenCount; ++i) {
            if (this.m_pChildrenIds[i] != _channel.getId()) continue;
            return this.m_pChildrenNodes[i];
        }
        this.m_pChildrenIds[this.m_nChildrenCount] = _channel.getId();
        this.m_pChildrenNodes[this.m_nChildrenCount] = new TreeNode(_channel, this.m_nMaxChildCount);
        ++this.m_nChildrenCount;
        return this.m_pChildrenNodes[this.m_nChildrenCount - 1];
    }

    private Channel[] extractPathIds(Channel _channel) throws Exception {
        Channel[] pChannelsTemp = new Channel[100];
        int nPathCount = 0;
        for (Channel parent = _channel; parent != null; parent = parent.getParent()) {
            pChannelsTemp[nPathCount] = parent;
            ++nPathCount;
        }
        Channel[] pResult = new Channel[nPathCount];
        for (int i = nPathCount - 1; i >= 0; --i) {
            pResult[nPathCount - i - 1] = pChannelsTemp[i];
        }
        return pResult;
    }

    private void init() throws Exception {
        int i;
        if (this.m_srcChannels == null) {
            this.m_pChildrenIds = new int[this.m_nMaxChildCount];
            this.m_pChildrenNodes = new TreeNode[this.m_nMaxChildCount];
            this.m_hDocumentsCountCache = new HashMap(this.m_pClassInfos.length / 2);
            this.m_srcChannels = new Channels(this.m_oLoginUser, this.m_pClassInfos.length / 2, 1);
            for (i = 0; i < this.m_pClassInfos.length; ++i) {
                int nChannelId;
                Channel channel;
                if ((channel = Channel.findById(nChannelId = this.m_pClassInfos[i++])) == null) continue;
                this.m_srcChannels.addElement(channel);
                this.m_hDocumentsCountCache.put(new Integer(nChannelId), new Integer(this.m_pClassInfos[i]));
            }
        }
        for (i = 0; i < this.m_srcChannels.size(); ++i) {
            Channel channel = (Channel)this.m_srcChannels.getAt(i);
            if (channel == null) continue;
            Channel[] pPathChannels = this.extractPathIds(channel);
            TreeNode currNode = this;
            for (int j = 0; j < pPathChannels.length; ++j) {
                currNode = currNode.addNeedExpandNode(pPathChannels[j]);
            }
        }
        this.caculateAndSetNodesCount(this.getChildrenCount(), this.getChildrenNodes());
    }

    private void caculateAndSetNodesCount(int _nNodesCount, TreeNode[] _pTreeNodes) {
        for (int i = 0; i < _nNodesCount; ++i) {
            TreeNode node = _pTreeNodes[i];
            node.setDocumentsCount(this.caculateDocumentsCount(node));
            this.caculateAndSetNodesCount(node.getChildrenCount(), node.getChildrenNodes());
        }
    }

    private int caculateDocumentsCount(TreeNode _node) {
        Integer iCount = (Integer)this.m_hDocumentsCountCache.get(new Integer(_node.getChannel().getId()));
        int nCount = 0;
        if (iCount != null) {
            nCount = iCount;
        }
        int nChildrenCount = _node.getChildrenCount();
        TreeNode[] pChildrenCount = _node.getChildrenNodes();
        for (int i = 0; i < nChildrenCount; ++i) {
            nCount += this.caculateDocumentsCount(pChildrenCount[i]);
        }
        return nCount;
    }

    public Channel getChannel() {
        return this.m_oChannel;
    }

    public TreeNode[] getChildrenNodes() {
        return this.m_pChildrenNodes;
    }

    public String getAllChildrenNodeIds() {
        if (this.m_nChildrenCount <= 0) {
            return null;
        }
        StringBuffer sbNodeIds = new StringBuffer(this.m_nChildrenCount * 6);
        for (int i = 0; i < this.m_nChildrenCount; ++i) {
            if (i > 0) {
                sbNodeIds.append(",");
            }
            sbNodeIds.append(this.m_pChildrenIds[i]);
            String sTemp = this.m_pChildrenNodes[i].getAllChildrenNodeIds();
            if (sTemp == null) continue;
            sbNodeIds.append(",");
            sbNodeIds.append(sTemp);
        }
        return sbNodeIds.toString();
    }

    public String getChildrenNodeIds() {
        if (this.m_nChildrenCount <= 0) {
            return null;
        }
        StringBuffer sbNodeIds = new StringBuffer(this.m_nChildrenCount * 6);
        sbNodeIds.append(this.m_pChildrenIds[0]);
        for (int i = 1; i < this.m_nChildrenCount; ++i) {
            sbNodeIds.append(",");
            sbNodeIds.append(this.m_pChildrenIds[i]);
        }
        return sbNodeIds.toString();
    }

    public TreeNode getExpandNodeById(int _nChannelId) {
        if (this.m_nChildrenCount <= 0) {
            return null;
        }
        for (int i = 0; i < this.m_nChildrenCount; ++i) {
            if (this.m_pChildrenIds[i] != _nChannelId) continue;
            return this.m_pChildrenNodes[i];
        }
        return null;
    }

    public int getDocumentsCount() {
        return this.m_nDocumentsCount;
    }

    public void setDocumentsCount(int documentsCount) {
        this.m_nDocumentsCount = documentsCount;
    }

    public int getChildrenCount() {
        return this.m_nChildrenCount;
    }
}

