/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Right;
import com.trs.components.wcm.content.domain.SiteMemberMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class RightLCListenerForSynSiteMember
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnModify,
IObjectLCListenerOnDel {
    private static Logger logger = Logger.getLogger(RightLCListenerForSynSiteMember.class);
    private SiteMemberMgr m_oSiteMemberMgr = (SiteMemberMgr)DreamFactory.createObjectById("SiteMemberMgr");

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (!(_oObjAdded instanceof Right)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(RightLCListenerForSynSiteMember.class, "RightLCListenerForSynSiteMember.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjAdded.getClass() + I18NMessage.get(RightLCListenerForSynSiteMember.class, "RightLCListenerForSynSiteMember.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        Right right = (Right)_oObjAdded;
        if (right.getValueAsLong() <= 0L || right.getObjType() != 101 && right.getObjType() != 103) {
            return;
        }
        this.addSiteMemberIfNecessary(right);
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        long newRightValue;
        if (!(_oObjModified instanceof Right)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(RightLCListenerForSynSiteMember.class, "RightLCListenerForSynSiteMember.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjModified.getClass() + I18NMessage.get(RightLCListenerForSynSiteMember.class, "RightLCListenerForSynSiteMember.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        Right right = (Right)_oObjModified;
        if (!right.isChangeProperty("RIGHTVALUE") || right.getObjType() != 101 && right.getObjType() != 103) {
            return;
        }
        Object objValue = right.getNewProperty("RIGHTVALUE");
        long l = newRightValue = objValue == null ? 0L : ((Number)objValue).longValue();
        if (right.getValueAsLong() <= 0L && newRightValue > 0L) {
            this.addSiteMemberIfNecessary(right);
            return;
        }
        if (right.getValueAsLong() > 0L && newRightValue <= 0L) {
            this.deleteSiteMemberIfNecessary(right);
            return;
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (!(_oObjDeleted instanceof Right)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(RightLCListenerForSynSiteMember.class, "RightLCListenerForSynSiteMember.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjDeleted.getClass() + I18NMessage.get(RightLCListenerForSynSiteMember.class, "RightLCListenerForSynSiteMember.label3", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        Right right = (Right)_oObjDeleted;
        if (right.getValueAsLong() <= 0L || right.getObjType() != 101 && right.getObjType() != 103) {
            return;
        }
        this.deleteSiteMemberIfNecessary(right);
    }

    private void addSiteMemberIfNecessary(Right _right) throws WCMException {
        int nSiteId = this.getSiteId(_right);
        if (nSiteId > 0) {
            this.m_oSiteMemberMgr.addSiteMember(nSiteId, _right.getOperatorType(), _right.getOperatorId());
        }
    }

    private void deleteSiteMemberIfNecessary(Right _right) throws WCMException {
        int nSiteId = this.getSiteId(_right);
        if (this.isHasRightOnSite(_right.getId(), _right.getOperatorType(), _right.getOperatorId(), nSiteId)) {
            return;
        }
        this.m_oSiteMemberMgr.removeSiteMember(nSiteId, _right.getOperatorType(), _right.getOperatorId());
    }

    private int getSiteId(Right _right) throws WCMException {
        int nResult = _right.getObjId();
        if (101 == _right.getObjType()) {
            Channel channel = Channel.findById(nResult);
            nResult = channel != null ? channel.getSiteId() : 0;
        }
        return nResult;
    }

    private boolean isHasRightOnSite(int _nExcludeRightId, int _nOperType, int _nOperId, int _nSiteId) throws WCMException {
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet rsData = null;
        DBManager dbMgr = DBManager.getDBManager();
        String strSQL = "select RightId from WCMRight where RightId <>? and RightValue>0 and OprType=? and OprId=? and ( (ObjType=103 and ObjId=?) or (ObjType=101 and exists(select ChannelId from WCMChannel where SiteId=? and  WCMRight.ObjId=ChannelId) ) )";
        try {
            oConn = dbMgr.getConnection();
            oPreStmt = oConn.prepareStatement(strSQL);
            oPreStmt.setMaxRows(1);
            oPreStmt.setInt(1, _nExcludeRightId);
            oPreStmt.setInt(2, _nOperType);
            oPreStmt.setInt(3, _nOperId);
            oPreStmt.setInt(4, _nSiteId);
            oPreStmt.setInt(5, _nSiteId);
            rsData = oPreStmt.executeQuery();
            if (rsData.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException ex) {
            throw new WCMException(I18NMessage.get(RightLCListenerForSynSiteMember.class, "RightLCListenerForSynSiteMember.label4", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(I18NMessage.get(RightLCListenerForSynSiteMember.class, "RightLCListenerForSynSiteMember.label4", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + strSQL, ex);
        }
        finally {
            if (oConn != null) {
                dbMgr.freeConnection(oConn);
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception exception) {}
            }
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }
}

