/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ChnlDocLCListener4ClassInfo
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel {
    private static final String SQL_UPD_LINKQUOTE = "update WCMDOCUMENT set LINKQUOTE=? where DOCID=?";
    private static final String SQL_UPD_MIRRORQUOTE = "update WCMDOCUMENT set MIRRORQUOTE=? where DOCID=?";
    private static final String SQL_GET_LINKQUOTE = "select LINKQUOTE from WCMDOCUMENT where DOCID=?";
    private static final String SQL_GET_MIRRORQUOTE = "select MIRRORQUOTE from WCMDOCUMENT where DOCID=?";

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (_oObjAdded == null || 614 != _oObjAdded.getWCMType()) {
            return;
        }
        ChnlDoc chnldoc = (ChnlDoc)_oObjAdded;
        int nModal = chnldoc.getModal();
        switch (nModal) {
            case 2: {
                this.addLinkQuote(chnldoc.getDocId(), chnldoc.getChannelId());
                break;
            }
            case 3: {
                this.addMirrorQuote(chnldoc.getDocId(), chnldoc.getChannelId());
                break;
            }
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (_oObjDeleted == null || 614 != _oObjDeleted.getWCMType()) {
            return;
        }
        ChnlDoc chnldoc = (ChnlDoc)_oObjDeleted;
        int nModal = chnldoc.getModal();
        switch (nModal) {
            case 2: {
                this.removeLinkQuote(chnldoc.getDocId(), chnldoc.getChannelId());
                break;
            }
            case 3: {
                this.removeMirrorQuote(chnldoc.getDocId(), chnldoc.getChannelId());
                break;
            }
        }
    }

    private void addLinkQuote(int _nDocId, int _nChnlId) throws WCMException {
        this.updateQuote(SQL_GET_LINKQUOTE, SQL_UPD_LINKQUOTE, _nDocId, _nChnlId, true);
    }

    private void addMirrorQuote(int _nDocId, int _nChnlId) throws WCMException {
        this.updateQuote(SQL_GET_MIRRORQUOTE, SQL_UPD_MIRRORQUOTE, _nDocId, _nChnlId, true);
    }

    private void removeLinkQuote(int _nDocId, int _nChnlId) throws WCMException {
        this.updateQuote(SQL_GET_LINKQUOTE, SQL_UPD_LINKQUOTE, _nDocId, _nChnlId, false);
    }

    private void removeMirrorQuote(int _nDocId, int _nChnlId) throws WCMException {
        this.updateQuote(SQL_GET_MIRRORQUOTE, SQL_UPD_MIRRORQUOTE, _nDocId, _nChnlId, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateQuote(String _sGetSql, String _sUpdateSql, int _nDocId, int _nChnlId, boolean _bAdd) throws WCMException {
        DBManager dbmanager;
        Connection conn;
        block12: {
            conn = null;
            Statement pstmt = null;
            dbmanager = DBManager.getDBManager();
            try {
                String sLinkQuote2332 = this.getQuote(_sGetSql, _nDocId);
                if (_bAdd) {
                    sLinkQuote2332 = sLinkQuote2332.length() > 1 ? sLinkQuote2332 + "," + _nChnlId : String.valueOf(_nChnlId);
                } else {
                    sLinkQuote2332 = "," + sLinkQuote2332;
                    if ((sLinkQuote2332 = sLinkQuote2332.replaceAll("," + _nChnlId, "")).charAt(0) == ',') {
                        sLinkQuote2332 = sLinkQuote2332.substring(1);
                    }
                }
                conn = dbmanager.getConnection();
                pstmt = conn.prepareStatement(_sUpdateSql);
                pstmt.setString(1, sLinkQuote2332);
                pstmt.setInt(2, _nDocId);
                pstmt.executeUpdate();
                if (pstmt == null) break block12;
            }
            catch (SQLException e) {
                try {
                    throw new WCMException(40, I18NMessage.get(ChnlDocLCListener4ClassInfo.class, "ChnlDocLCListener4ClassInfo.label1", "\u66f4\u65b0\u5f15\u7528\u5206\u7c7b\u5931\u8d25"), e);
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (conn == null) throw throwable;
                    dbmanager.freeConnection(conn);
                    throw throwable;
                }
            }
            try {
                pstmt.close();
            }
            catch (Exception sLinkQuote2332) {
                // empty catch block
            }
        }
        if (conn == null) return;
        dbmanager.freeConnection(conn);
    }

    private String getQuote(String _sSql, int _nDocId) throws WCMException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        DBManager dbmanager = DBManager.getDBManager();
        try {
            conn = dbmanager.getConnection();
            pstmt = conn.prepareStatement(_sSql);
            pstmt.setInt(1, _nDocId);
            rs = pstmt.executeQuery();
            String sLinkQuote = "";
            if (rs.next()) {
                sLinkQuote = rs.getString(1);
            }
            String string = CMyString.showNull(sLinkQuote, "");
            return string;
        }
        catch (SQLException e) {
            throw new WCMException(40, I18NMessage.get(ChnlDocLCListener4ClassInfo.class, "ChnlDocLCListener4ClassInfo.label2", "\u83b7\u53d6\u5206\u7c7b\u5f15\u7528\u5931\u8d25"), e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                dbmanager.freeConnection(conn);
            }
        }
    }
}

