/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.wcm.advisor.Advisor;
import com.trs.components.wcm.advisor.AdvisorMgr;
import com.trs.components.wcm.advisor.AdvisorXmlToObjConverter;
import com.trs.components.wcm.advisor.Option;
import com.trs.components.wcm.advisor.OptionGroup;
import com.trs.components.wcm.advisor.OptionGroups;
import com.trs.components.wcm.advisor.Options;
import com.trs.components.wcm.advisor.Step;
import com.trs.components.wcm.advisor.Steps;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AdvisorImporter {
    private static Logger logger = Logger.getLogger(AdvisorImporter.class);
    private String m_sImportFile;
    private Channel m_oCurrChannel;
    private boolean m_bToCurrChnl = false;
    private AdvisorXmlToObjConverter m_converter = null;
    private Map m_mOptionIdMapping = new HashMap();
    private AdvisorMgr m_oAdvisorMgr = null;

    public AdvisorImporter(int _nImportType, Channel oCurrChannel) throws WCMException {
        this.m_oCurrChannel = oCurrChannel;
        this.m_converter = new AdvisorXmlToObjConverter(_nImportType, oCurrChannel);
        this.m_oAdvisorMgr = (AdvisorMgr)DreamFactory.createObjectById("AdvisorMgr");
    }

    public void setImportToCurrChnl(boolean importToCurrChnl) {
        this.m_bToCurrChnl = importToCurrChnl;
    }

    public void importFromZip(String sImportZipFile) throws WCMException {
        if (!CMyFile.fileExists(sImportZipFile)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            sImportZipFile = filesMan.mapFilePath(sImportZipFile, 0) + CMyFile.extractFileName(sImportZipFile);
        }
        String sUnZipFilePath = CMyFile.extractFilePath(sImportZipFile);
        this.m_sImportFile = sUnZipFilePath = sUnZipFilePath + CMyFile.extractMainFileName(sImportZipFile) + File.separator;
        CMyUnZipFile uzf = new CMyUnZipFile(sImportZipFile, sUnZipFilePath);
        try {
            uzf.addFileExtFilters("xml");
            uzf.doUnZipAnd();
            CMyFile.deleteFile(sImportZipFile);
        }
        catch (CMyException e) {
            throw new WCMException(200, "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25!", e);
        }
        ArrayList allXmlFiles = uzf.getFilteredFiles();
        XmlObject[] xmlObjs = null;
        int length = allXmlFiles.size();
        for (int i = 0; i < length; ++i) {
            String sXmlFile = (String)allXmlFiles.get(i);
            xmlObjs = this.m_converter.convertXml(sXmlFile, null, null);
            this.importAdvisors(xmlObjs, this.m_oCurrChannel);
        }
        CMyFile.deleteDir(this.m_sImportFile);
    }

    private void importAdvisors(XmlObject[] xmlObjs, Channel channel) throws WCMException {
        for (int i = 0; i < xmlObjs.length; ++i) {
            this.importAdvisor(xmlObjs[i], channel);
        }
    }

    private Advisor importAdvisor(XmlObject xmlObj, Channel channel) throws WCMException {
        String sAppendixFileName;
        Advisor advisor = (Advisor)xmlObj.getCurrentObj();
        if (this.m_bToCurrChnl) {
            advisor.setChannelId(channel.getId());
        }
        if (!CMyString.isEmpty(sAppendixFileName = advisor.getAppendixFileName())) {
            FilesMan filesMan = FilesMan.getFilesMan();
            String sNewFileName = filesMan.getNextFilePathName("P0", CMyFile.extractFileExt(sAppendixFileName));
            try {
                CMyFile.copyFile(this.m_sImportFile + sAppendixFileName, sNewFileName);
            }
            catch (CMyException e) {
                throw new WCMException("\u590d\u5236\u6587\u4ef6\u5931\u8d25", e);
            }
            advisor.setAppendixFileName(CMyFile.extractFileName(sNewFileName));
        }
        advisor.save(ContextHelper.getLoginUser());
        XmlObject[] steps = xmlObj.getChild("XWCMSTEPS");
        this.importSteps(steps, advisor);
        this.afterAdvisorSave(advisor);
        return advisor;
    }

    private void afterAdvisorSave(Advisor advisor) throws WCMException {
        Steps steps = this.m_oAdvisorMgr.queryStepsByAdvisor(advisor, null);
        int nSize = steps.size();
        for (int i = 0; i < nSize; ++i) {
            Step step = (Step)steps.getAt(i);
            if (step == null) continue;
            OptionGroups groups = this.m_oAdvisorMgr.queryOptionGroupsByStep(step, null);
            int nJSize = groups.size();
            for (int j = 0; j < nJSize; ++j) {
                String sLastOptions;
                OptionGroup group = (OptionGroup)groups.getAt(j);
                if (group == null || CMyString.isEmpty(sLastOptions = group.getLastOptions())) continue;
                String sNewOptions = this.getNewOptionIds(sLastOptions);
                group.setLastOptions(sNewOptions);
                group.save(ContextHelper.getLoginUser());
            }
        }
        Options options = this.m_oAdvisorMgr.queryOptionsByAdvisor(advisor, null);
        int nSize2 = options.size();
        for (int i = 0; i < nSize2; ++i) {
            String sNotAllowOptions;
            Option option = (Option)options.getAt(i);
            if (option == null) continue;
            boolean isChange = false;
            String sLastOptions = option.getLastOptions();
            if (!CMyString.isEmpty(sLastOptions)) {
                String sNewOptions = this.getNewOptionIds(sLastOptions);
                option.setLastOptions(sNewOptions);
                isChange = true;
            }
            if (!CMyString.isEmpty(sNotAllowOptions = option.getNotAllowedSelectOptions())) {
                String sNewOptions = this.getNewOptionIds(sNotAllowOptions);
                option.setNotAllowedSelectOptions(sNewOptions);
                isChange = true;
            }
            if (!isChange) continue;
            option.save(ContextHelper.getLoginUser());
        }
    }

    private String getNewOptionIds(String sOldOptionIds) {
        if (CMyString.isEmpty(sOldOptionIds)) {
            return "";
        }
        int[] oldIds = CMyString.splitToInt(sOldOptionIds, ",");
        StringBuffer sbNewIds = new StringBuffer();
        for (int i = 0; i < oldIds.length; ++i) {
            Integer oNewId = (Integer)this.m_mOptionIdMapping.get(new Integer(oldIds[i]));
            if (oNewId == null) continue;
            sbNewIds.append(oNewId).append(",");
        }
        if (sbNewIds.length() > 0) {
            sbNewIds.setLength(sbNewIds.length() - 1);
        }
        return sbNewIds.toString();
    }

    private void importSteps(XmlObject[] xmlObjs, Advisor advisor) throws WCMException {
        for (int i = 0; i < xmlObjs.length; ++i) {
            this.importStep(xmlObjs[i], advisor);
        }
    }

    private Step importStep(XmlObject xmlObj, Advisor advisor) throws WCMException {
        Step step = (Step)xmlObj.getCurrentObj();
        step.setAdvisorId(advisor.getId());
        step.save(ContextHelper.getLoginUser());
        XmlObject[] groups = xmlObj.getChild("XWCMOPTIONGROUPS");
        this.importOptionGroups(groups, step);
        return step;
    }

    private void importOptionGroups(XmlObject[] xmlObjs, Step step) throws WCMException {
        for (int i = 0; i < xmlObjs.length; ++i) {
            this.importOptionGroup(xmlObjs[i], step);
        }
    }

    private OptionGroup importOptionGroup(XmlObject xmlObj, Step step) throws WCMException {
        OptionGroup group = (OptionGroup)xmlObj.getCurrentObj();
        group.setStepId(step.getId());
        group.save(ContextHelper.getLoginUser());
        XmlObject[] options = xmlObj.getChild("XWCMOPTIONS");
        this.importOptions(options, group);
        return group;
    }

    private void importOptions(XmlObject[] xmlObjs, OptionGroup group) throws WCMException {
        for (int i = 0; i < xmlObjs.length; ++i) {
            this.importOption(xmlObjs[i], group);
        }
    }

    private Option importOption(XmlObject xmlObj, OptionGroup group) throws WCMException {
        Option option = (Option)xmlObj.getCurrentObj();
        option.setGroupId(group.getId());
        String[] pics = new String[]{"PICTRUE"};
        for (int i = 0; i < pics.length; ++i) {
            String sPicFileName = option.getPropertyAsString(pics[i]);
            if (CMyString.isEmpty(sPicFileName)) continue;
            if (!CMyFile.fileExists(this.m_sImportFile + sPicFileName)) {
                logger.error((Object)CMyString.format("\u5bfc\u5165\u987e\u95ee\u56fe\u7247\u65f6\u56fe\u7247\u4e0d\u5b58\u5728[{0}]", new String[]{this.m_sImportFile + sPicFileName}));
                continue;
            }
            FilesMan filesMan = FilesMan.getFilesMan();
            String sNewFileName = filesMan.getNextFilePathName("P0", CMyFile.extractFileExt(sPicFileName));
            try {
                CMyFile.copyFile(this.m_sImportFile + sPicFileName, sNewFileName);
            }
            catch (CMyException e) {
                throw new WCMException("\u590d\u5236\u6587\u4ef6\u5931\u8d25", e);
            }
            option.setPropertyWithString(pics[i], CMyFile.extractFileName(sNewFileName));
        }
        Integer oOldId = (Integer)this.m_converter.getObjIdMapping().get(option);
        option.save(ContextHelper.getLoginUser());
        this.m_mOptionIdMapping.put(oOldId, option.getKey());
        return option;
    }
}

