/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.components.stat.BaseStatHandler;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.DebugTimer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DocStatHandler4UserDept
extends BaseStatHandler {
    private static Logger logger = Logger.getLogger(DocStatHandler4UserDept.class);
    private HashMap m_hRelGroupsOfUser = new HashMap();

    @Override
    public void visitStatItem(ResultSet resultSet, int nSQLIndex) throws WCMException {
        try {
            String sUserName = resultSet.getString(2);
            int nDataCount = resultSet.getInt(1);
            if (nDataCount == 0) {
                return;
            }
            DebugTimer timerTemp = new DebugTimer();
            timerTemp.start();
            Groups oRelGroups = this.makeCurrRelGroups(sUserName);
            timerTemp.stop();
            logger.debug((Object)("makeCurrRelGroups of " + sUserName + " use[" + timerTemp.getTime() + "]ms"));
            timerTemp.start();
            int nSize = oRelGroups.size();
            for (int nRelGroupIndex = 0; nRelGroupIndex < nSize; ++nRelGroupIndex) {
                Group oRelGroup = (Group)oRelGroups.getAt(nRelGroupIndex);
                if (oRelGroup == null) continue;
                String sGroupId = oRelGroup.getId() + "";
                String oGroupKey = this.makePrivateKey(sGroupId, resultSet);
                int iExistsDataCount = this.getValue(nSQLIndex, oGroupKey);
                int nDataCountOfCurrGroup = nDataCount;
                this.setValue(nSQLIndex, oGroupKey, nDataCountOfCurrGroup += iExistsDataCount);
                this.addMajorObject(sGroupId);
            }
            timerTemp.stop();
            logger.debug((Object)("merge datacount of " + sUserName + " use[" + timerTemp.getTime() + "]ms"));
        }
        catch (SQLException e) {
            logger.debug((Object)"\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new WCMException("\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    private String makePrivateKey(String groupKey, ResultSet resultSet) throws SQLException {
        int nColumnCount = resultSet.getMetaData().getColumnCount();
        String[] sParam = new String[nColumnCount - 1];
        sParam[0] = groupKey;
        for (int i = 2; i < nColumnCount; ++i) {
            sParam[i - 1] = resultSet.getString(i + 1);
        }
        return this.makeKey(sParam);
    }

    private Groups makeCurrRelGroups(String _sLowerCaseUserName) throws WCMException {
        Groups oCurrRelGroups = (Groups)this.m_hRelGroupsOfUser.get(_sLowerCaseUserName);
        if (oCurrRelGroups != null) {
            return oCurrRelGroups;
        }
        oCurrRelGroups = new Groups(null);
        User oCurrUser = User.findByName(_sLowerCaseUserName);
        if (oCurrUser == null) {
            return oCurrRelGroups;
        }
        Groups groups = oCurrUser.getGroups();
        int nSize = groups.size();
        for (int i = 0; i < nSize; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            for (Group parent = group; parent != null; parent = parent.getParent()) {
                oCurrRelGroups.addElement(parent);
            }
        }
        this.m_hRelGroupsOfUser.put(oCurrUser.getKey(), oCurrRelGroups);
        return oCurrRelGroups;
    }
}

