/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.service.IDefaultChannelMaker;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.BaseConfigServer;
import com.trs.infra.config.TRSConfigServer;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class DefaultChannelMakerCenter
extends BaseConfigServer {
    public static final String SERVICE_ID = "defaultChannelCenter";
    private static Logger logger = Logger.getLogger(DefaultChannelMakerCenter.class);
    private Hashtable m_hMakers = new Hashtable();

    public DefaultChannelMakerCenter() {
        this.m_sAppName = SERVICE_ID;
    }

    @Override
    protected void doShutdown() {
    }

    @Override
    protected boolean doStart() {
        Iterator itCreators = WCMDiscoveryFactory.getDiscovery().getImplementors(IDefaultChannelMaker.class.getName());
        while (itCreators.hasNext()) {
            String sMakerClassName = (String)itCreators.next();
            try {
                IDefaultChannelMaker maker = (IDefaultChannelMaker)Class.forName(sMakerClassName).newInstance();
                int[] pViewid = maker.registerViewIds();
                for (int i = 0; i < pViewid.length; ++i) {
                    this.m_hMakers.put(new Integer(pViewid[i]), sMakerClassName);
                }
            }
            catch (Throwable e) {
                logger.error((Object)(I18NMessage.get(DefaultChannelMakerCenter.class, "DefaultChannelMakerCenter.label1", "\u6ce8\u518c\u9ed8\u8ba4\u680f\u76ee\u6784\u9020\u5668[ClassName=") + sMakerClassName + I18NMessage.get(DefaultChannelMakerCenter.class, "DefaultChannelMakerCenter.label2", "]\u5931\u8d25\uff01")), e);
            }
        }
        return true;
    }

    public Channel makeDefaultChannel(User _loginUser, int _nViewId) throws WCMException {
        String sMakerClassName = (String)this.m_hMakers.get(new Integer(_nViewId));
        IDefaultChannelMaker maker = null;
        try {
            if (sMakerClassName != null) {
                maker = (IDefaultChannelMaker)Class.forName(sMakerClassName).newInstance();
            }
        }
        catch (Throwable e) {
            logger.error((Object)(I18NMessage.get(DefaultChannelMakerCenter.class, "DefaultChannelMakerCenter.label3", "\u9ed8\u8ba4\u680f\u76ee\u6784\u9020\u5668[ClassName=") + sMakerClassName + I18NMessage.get(DefaultChannelMakerCenter.class, "DefaultChannelMakerCenter.label4", "]\u5b9e\u4f8b\u5316\u5931\u8d25\uff01")), e);
        }
        if (maker != null) {
            return maker.makeDefaultChannel(_loginUser, _nViewId);
        }
        return null;
    }

    public Channels getAvailableChannels(User _loginUser, int _nViewId) throws WCMException {
        MetaView oMetaView;
        IMetaViewEmployerMgr oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
        Channels oChannels = oMetaViewEmployerMgr.getEmployers(oMetaView = MetaView.findById(_nViewId), null);
        if (oChannels == null || oChannels.isEmpty()) {
            return null;
        }
        Channel oChannel = null;
        for (int i = oChannels.size() - 1; i >= 0; --i) {
            oChannel = (Channel)oChannels.getAt(i);
            if (oChannel == null) {
                oChannels.removeAt(i, false);
            }
            if (AuthServer.hasRight(_loginUser, (CMSObj)oChannel, 31)) continue;
            oChannels.removeAt(i, false);
        }
        return oChannels;
    }

    public static DefaultChannelMakerCenter getInstance() {
        return (DefaultChannelMakerCenter)TRSConfigServer.findConfigServerById(SERVICE_ID);
    }
}

