/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.RoleMgr;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.RoleUserCacheMgr;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfoUtil;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.components.metadata.definition.xml.ClassInfoImporter;
import com.trs.components.metadata.definition.xml.ClassInfoXMLConvertor;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IFindByIdServiceProvider;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ClassInfoServiceProvider
implements ISelfDefinedServiceProvider,
IFindByIdServiceProvider {
    private static Logger logger = Logger.getLogger(ClassInfoServiceProvider.class);
    private static final int SELECT_NODE = 0;
    private static final int ONLY_SELECT_LEAF = 1;
    private int m_nNodeType = 0;
    private IClassInfoMgr m_oClassInfoMgr = (IClassInfoMgr)DreamFactory.createObjectById("IClassInfoMgr");

    public String createClassInfoTreeHTMLOfIds(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sClassInfos = _methodContext.getValue("objectIds");
        this.m_nNodeType = _methodContext.getValue("SelectType", 0);
        StringBuffer sbResult = new StringBuffer(4096);
        if (_methodContext.getValue("type", 0) == 0) {
            int[] aClassInfos = CMyString.splitToInt(sClassInfos, ",");
            this.createClassInfoTreeHTMLOfIds(sbResult, aClassInfos, 0);
        } else {
            sClassInfos = this.m_oClassInfoMgr.getPath(ClassInfos.findByIds(loginUser, sClassInfos));
            int[] aClassInfos = CMyString.splitToInt(sClassInfos, ",");
            HashMap oUsedMap = new HashMap(aClassInfos.length);
            this.createClassInfoTreeHTMLOfIds(sbResult, aClassInfos, oUsedMap, 0, 0);
        }
        return sbResult.toString();
    }

    private void createClassInfoTreeHTMLOfIds(StringBuffer _sbResult, int[] aClassInfo, int level) throws WCMException {
        if (level == aClassInfo.length) {
            return;
        }
        ClassInfo oClassInfo = ClassInfo.findById(aClassInfo[level]);
        if (oClassInfo == null) {
            return;
        }
        User loginUser = this.getLoginUser();
        ClassInfos oClassInfos = this.m_oClassInfoMgr.queryChildren(loginUser, oClassInfo, null);
        if (oClassInfos.size() <= 0) {
            return;
        }
        ++level;
        int nSize = oClassInfos.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo _oClassInfo = (ClassInfo)oClassInfos.getAt(i);
            if (_oClassInfo == null) continue;
            if (level + 1 < aClassInfo.length && _oClassInfo.getId() == aClassInfo[level]) {
                this.appendOneClassInfoHTML(_sbResult, _oClassInfo);
                _sbResult.append("<ul>");
                this.createClassInfoTreeHTMLOfIds(_sbResult, aClassInfo, level);
                _sbResult.append("</ul>");
                continue;
            }
            this.makeClassInfoHTML(_sbResult, _oClassInfo);
        }
    }

    private void createClassInfoTreeHTMLOfIds(StringBuffer _sbResult, int[] aClassInfo, HashMap oUsedMap, int index, int maxIndex) throws WCMException {
        if (index >= aClassInfo.length) {
            return;
        }
        if (oUsedMap.get(new Integer(aClassInfo[index])) == Boolean.TRUE) {
            this.createClassInfoTreeHTMLOfIds(_sbResult, aClassInfo, oUsedMap, index + 1, index + 1);
            return;
        }
        oUsedMap.put(new Integer(aClassInfo[index]), Boolean.TRUE);
        ClassInfo oClassInfo = ClassInfo.findById(aClassInfo[index]);
        if (oClassInfo == null) {
            this.createClassInfoTreeHTMLOfIds(_sbResult, aClassInfo, oUsedMap, index + 1, index + 1);
            return;
        }
        User loginUser = this.getLoginUser();
        this.appendOneClassInfoHTML(_sbResult, oClassInfo);
        ClassInfos oClassInfos = this.m_oClassInfoMgr.queryChildren(loginUser, oClassInfo, null);
        if (oClassInfos.size() <= 0) {
            return;
        }
        _sbResult.append("<ul>");
        ++index;
        int nSize = oClassInfos.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo _oClassInfo = (ClassInfo)oClassInfos.getAt(i);
            if (_oClassInfo == null) continue;
            if (index < aClassInfo.length && this.isContain(aClassInfo, _oClassInfo.getId())) {
                this.createClassInfoTreeHTMLOfIds(_sbResult, aClassInfo, oUsedMap, index, index);
                continue;
            }
            this.makeClassInfoHTML(_sbResult, _oClassInfo);
        }
        _sbResult.append("</ul>");
        if (maxIndex < index) {
            maxIndex = index;
        }
        if (maxIndex < aClassInfo.length && oClassInfo.getId() == aClassInfo[maxIndex]) {
            this.createClassInfoTreeHTMLOfIds(_sbResult, aClassInfo, oUsedMap, maxIndex, maxIndex);
        }
    }

    private boolean isContain(int[] array, int key) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != key) continue;
            return true;
        }
        return false;
    }

    public String createClassInfoTreeHTML(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nParentId = _methodContext.getValue("ParentId", 0);
        this.m_nNodeType = _methodContext.getValue("SelectType", 0);
        return this.createClassInfoTreeHTML(loginUser, nParentId);
    }

    public String createClassInfoTreeHTML(User _currUser, int _nParentId) throws WCMException {
        ClassInfos classInfos = this.queryClassInfos(_currUser, _nParentId, null);
        StringBuffer sbResult = new StringBuffer(51200);
        this.makeClassInfoHTML(sbResult, classInfos);
        return sbResult.toString();
    }

    public ClassInfos queryClassInfos(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nParentId = _methodContext.getValue("ParentId", 0);
        boolean bContainsAll = _methodContext.getValue("ContainAll", false);
        if (!bContainsAll) {
            return this.queryClassInfos(loginUser, nParentId, _methodContext.getExtraWCMFilter());
        }
        String sIds = this.m_oClassInfoMgr.queryChildrenWithAllLevel(loginUser, nParentId, new WCMFilter(_methodContext.getQueryFilter()));
        return ClassInfos.findByIds(loginUser, sIds);
    }

    public ClassInfos queryClassInfos(User _currUser, int _nParentId, WCMFilter _extraFilter) throws WCMException {
        ClassInfo parent = null;
        if (_nParentId > 0) {
            parent = this.findClassInfoById(_nParentId);
        }
        return this.m_oClassInfoMgr.queryChildren(_currUser, parent, _extraFilter);
    }

    public ClassInfos queryAnyClassInfos(MethodContext _methodContext) throws WCMException {
        User loginUser = this.getLoginUser();
        int nRootId = _methodContext.getValue("rootId", 0);
        ClassInfo oClassInfo = ClassInfo.findById(nRootId);
        if (oClassInfo == null) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label25", "\u6ca1\u6709\u627e\u5230\u3010Id=") + nRootId + I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label26", "\u3011\u7684\u5206\u7c7b"));
        }
        return this.m_oClassInfoMgr.queryAnyClassInfos(loginUser, oClassInfo, _methodContext.getExtraWCMFilter());
    }

    public void deleteClassInfo(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nClassInfoId = _methodContext.getObjectId();
        this.validateRight();
        if (nClassInfoId > 0) {
            this.deleteClassInfo(loginUser, nClassInfoId);
        } else {
            this.deleteClassInfo(loginUser, _methodContext.getObjectIds());
        }
    }

    public void deleteClassInfo(User _currUser, int _nClassInfoId) throws WCMException {
        ClassInfo classInfo = this.findClassInfoById(_nClassInfoId);
        this.m_oClassInfoMgr.deleteClassInfo(_currUser, classInfo);
    }

    public void deleteClassInfo(User _currUser, String _sClassInfoIds) throws WCMException {
        ClassInfos classInfos = ClassInfos.findByIds(_currUser, _sClassInfoIds);
        if (classInfos == null) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label2", "\u6307\u5b9a\u8282\u70b9\u6ca1\u6709\u627e\u5230\uff01"));
        }
        int nSize = classInfos.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
            if (classInfo == null) continue;
            this.m_oClassInfoMgr.deleteClassInfo(_currUser, classInfo);
        }
    }

    private void validateRight() throws WCMException {
        User oUser = ContextHelper.getLoginUser();
        if (oUser.isAdministrator()) {
            return;
        }
        String sRoleName = ConfigServer.getServer().getSysConfigValue("ClassInfo_Role_Manager", I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label27", "\u5206\u7c7b\u6cd5\u7ef4\u62a4\u4eba\u5458"));
        RoleMgr oRoleMgr = (RoleMgr)DreamFactory.createObjectById("RoleMgr");
        Role oRole = oRoleMgr.findRoleByName(sRoleName);
        if (oRole == null) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label28", "\u4f60\u4e0d\u662f\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u5206\u7c7b\u6cd5\u7ef4\u62a4\u4eba\u5458\uff0c\u4e0d\u80fd\u7ef4\u62a4\u5206\u7c7b\u6cd5"));
        }
        RoleUserCacheMgr roleUserCacheMgr = (RoleUserCacheMgr)DreamFactory.createObjectById("RoleUserCacheMgr");
        Roles oRoles = roleUserCacheMgr.getRoles(oUser, null);
        if (oRoles.indexOf(oRole.getId()) >= 0) {
            return;
        }
        throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label28", "\u4f60\u4e0d\u662f\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u5206\u7c7b\u6cd5\u7ef4\u62a4\u4eba\u5458\uff0c\u4e0d\u80fd\u7ef4\u62a4\u5206\u7c7b\u6cd5"));
    }

    public ClassInfo saveClassInfo(MethodContext _context) throws WCMException {
        this.validateRight();
        String sCName = "";
        String sCDesc = "";
        sCName = _context.containsParameter("Name") ? _context.getValue("Name") : _context.getValue("CName");
        sCDesc = _context.containsParameter("Desc") ? _context.getValue("Desc") : _context.getValue("CDesc");
        return this.saveClassInfo(_context, this.getLoginUser(), _context.getObjectId(), _context.getValue("ParentId", 0), _context.getValue("PreviousId", -2), sCName, sCDesc, _context.getValue("CCode"));
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public ClassInfo saveClassInfo(User _currUser, int _nCurrId, int _nParentId, int _nPreviousId, String _sName, String _sDesc, String _sCCode) throws WCMException {
        ClassInfo parent = null;
        if (_nParentId > 0 && (parent = ClassInfo.findById(_nParentId)) == null) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label4", "\u6307\u5b9a\u7684\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01[Id=") + _nParentId + "]");
        }
        ClassInfo classInfo = null;
        if (_nCurrId > 0) {
            classInfo = ClassInfo.findById(_nCurrId);
            if (classInfo == null) {
                throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label5", "\u6307\u5b9a\u4e3b\u9898\u6ca1\u6709\u627e\u5230\uff01[ID=") + _nCurrId + "]");
            }
        } else {
            classInfo = ClassInfo.createNewInstance();
            classInfo.setParentId(_nParentId);
            if (parent != null) {
                classInfo.setRootId(parent.isRoot() ? parent.getId() : parent.getRootId());
            } else {
                classInfo.setRootId(0);
            }
        }
        if (_sName != null) {
            classInfo.setName(_sName);
        }
        if (_sDesc != null) {
            classInfo.setDesc(_sDesc);
        }
        if (_sCCode != null) {
            classInfo.setCode(_sCCode);
        }
        if (_nPreviousId == -1) {
            classInfo.setOrder(_nPreviousId);
        } else if (_nPreviousId > 0) {
            String SQL_QUERY_ORDER = "select ClassOrder from XWCMCLASSINFO where CLASSINFOID=?";
            int nOrder = DBManager.getDBManager().sqlExecuteIntQuery("select ClassOrder from XWCMCLASSINFO where CLASSINFOID=?", new int[]{_nPreviousId});
            classInfo.setOrder(nOrder);
        }
        classInfo.save(_currUser);
        return classInfo;
    }

    public ClassInfo saveClassInfo(MethodContext _methodContext, User _currUser, int _nCurrId, int _nParentId, int _nPreviousId, String _sName, String _sDesc, String _sCCode) throws WCMException {
        ClassInfo parent = null;
        if (_nParentId > 0 && (parent = ClassInfo.findById(_nParentId)) == null) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label4", "\u6307\u5b9a\u7684\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01[Id=") + _nParentId + "]");
        }
        ClassInfo classInfo = null;
        if (_nCurrId > 0) {
            classInfo = ClassInfo.findById(_nCurrId);
            if (classInfo == null) {
                throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label5", "\u6307\u5b9a\u4e3b\u9898\u6ca1\u6709\u627e\u5230\uff01[ID=") + _nCurrId + "]");
            }
        } else {
            classInfo = ClassInfo.createNewInstance();
            classInfo.setParentId(_nParentId);
            if (parent != null) {
                classInfo.setRootId(parent.isRoot() ? parent.getId() : parent.getRootId());
            } else {
                classInfo.setRootId(0);
            }
        }
        String[] pLogicFields = new String[]{"ObjectId"};
        classInfo = (ClassInfo)WCMAJAXServiceHelper.setWCMObjectProperties(_currUser, _methodContext, classInfo, pLogicFields);
        if (_sName != null) {
            classInfo.setName(_sName);
        }
        if (_sDesc != null) {
            classInfo.setDesc(_sDesc);
        }
        if (_sCCode != null) {
            classInfo.setCode(_sCCode);
        }
        if (_nPreviousId == -1) {
            classInfo.setOrder(_nPreviousId);
        } else if (_nPreviousId > 0) {
            String SQL_QUERY_ORDER = "select ClassOrder from XWCMCLASSINFO where CLASSINFOID=?";
            int nOrder = DBManager.getDBManager().sqlExecuteIntQuery("select ClassOrder from XWCMCLASSINFO where CLASSINFOID=?", new int[]{_nPreviousId});
            classInfo.setOrder(nOrder);
        }
        classInfo.save(_currUser);
        return classInfo;
    }

    private void makeClassInfoHTML(StringBuffer _sbResult, ClassInfos _classInfos) throws WCMException {
        int nSize = _classInfos.size();
        for (int i = 0; i < nSize; ++i) {
            this.makeClassInfoHTML(_sbResult, (ClassInfo)_classInfos.getAt(i));
        }
    }

    private void makeClassInfoHTML(StringBuffer _sbResult, ClassInfo _classInfo) throws WCMException {
        if (_classInfo == null) {
            return;
        }
        this.appendOneClassInfoHTML(_sbResult, _classInfo);
        String SQL_QUERY_CHILD = "select CLASSINFOID from XWCMCLASSINFO where ParentId=?";
        int nId = DBManager.getDBManager().sqlExecuteIntQuery("select CLASSINFOID from XWCMCLASSINFO where ParentId=?", new int[]{_classInfo.getId()});
        if (nId > 0) {
            _sbResult.append("<ul></ul>\n");
        }
    }

    private void appendOneClassInfoHTML(StringBuffer _sbResult, ClassInfo _classInfo) throws WCMException {
        String SQL_QUERY_CHILD = "select CLASSINFOID from XWCMCLASSINFO where ParentId=?";
        int nId = DBManager.getDBManager().sqlExecuteIntQuery("select CLASSINFOID from XWCMCLASSINFO where ParentId=?", new int[]{_classInfo.getId()});
        boolean bHasChild = false;
        if (nId > 0) {
            bHasChild = true;
        }
        _sbResult.append("<div objectId=");
        _sbResult.append("'");
        _sbResult.append(_classInfo.getId());
        _sbResult.append("'");
        _sbResult.append(" id=");
        _sbResult.append("'");
        _sbResult.append("node_");
        _sbResult.append(_classInfo.getId());
        _sbResult.append("'");
        if (this.m_nNodeType == 1 && bHasChild) {
            _sbResult.append(" onlyNode='true'");
        }
        _sbResult.append(" cDesc=");
        _sbResult.append("'");
        _sbResult.append(CMyString.transDisplay(_classInfo.getDesc()));
        _sbResult.append("'");
        _sbResult.append(" cCode=");
        _sbResult.append("'");
        _sbResult.append(CMyString.transDisplay(_classInfo.getCode()));
        _sbResult.append("'");
        _sbResult.append(" title=");
        _sbResult.append("'");
        _sbResult.append("ID:");
        _sbResult.append(_classInfo.getId());
        _sbResult.append("'");
        _sbResult.append(">");
        _sbResult.append("<a href=#>");
        _sbResult.append(CMyString.transDisplay(_classInfo.getName()));
        _sbResult.append("</a></div>");
    }

    @Override
    public Object findById(MethodContext _methodContext) throws Throwable {
        int nObjectId = _methodContext.getObjectId();
        ClassInfo classInfo = null;
        classInfo = nObjectId == 0 ? ClassInfo.createNewInstance() : this.findClassInfoById(nObjectId);
        return classInfo;
    }

    private ClassInfo findClassInfoById(int _nObjectId) throws WCMException {
        ClassInfo classInfo = ClassInfo.findById(_nObjectId);
        if (classInfo == null) {
            throw new WCMException(200006, I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label6", "\u6307\u5b9a\u7684\u5206\u7c7b\u4e0d\u5b58\u5728\uff01[ID=") + _nObjectId + "]");
        }
        return classInfo;
    }

    public Object exists(MethodContext _methodContext) throws WCMException {
        boolean zIntType;
        WCMFilter extraFilter = _methodContext.getExtraWCMFilter();
        String propertyName = CMyString.showNull(_methodContext.getValue("propertyName"), "CName");
        WCMFilter existFilter = new WCMFilter("XWCMCLASSINFO", propertyName + "=?", "", "ClassInfoID");
        DBManager dbmanager = DBManager.getDBManager();
        int nType = dbmanager.getFieldInfo("XWCMCLASSINFO", propertyName).getDataType().getType();
        boolean bl = zIntType = nType == 4 || nType == -5 || nType == 5 || nType == 2 || nType == -6;
        if (zIntType) {
            existFilter.addSearchValues(_methodContext.getValue("propertyValue", 0));
        } else {
            existFilter.addSearchValues(_methodContext.getValue("propertyValue"));
        }
        int classInfoId = dbmanager.sqlExecuteIntQuery(existFilter.mergeWith(extraFilter));
        if (classInfoId > 0) {
            return ClassInfo.findById(classInfoId);
        }
        return null;
    }

    public String getPath(MethodContext _methodContext) throws WCMException {
        int classInfoId = _methodContext.getValue("objectId", 0);
        if (classInfoId == 0) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label7", "\u6ca1\u6709\u6307\u5b9a\u5206\u7c7b\u6cd5ID"));
        }
        ClassInfo classInfo = ClassInfo.findById(classInfoId);
        if (classInfo == null) {
            throw new WCMException(200006, I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label6", "\u6307\u5b9a\u7684\u5206\u7c7b\u4e0d\u5b58\u5728\uff01[ID=") + classInfoId + "]");
        }
        return this.m_oClassInfoMgr.getPath(classInfo);
    }

    public Reports importClassInfos(MethodContext _methodContext) throws Exception {
        String sImportFile = _methodContext.getValue("importFile");
        Reports oReports = new Reports(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label9", "\u5bfc\u5165\u5206\u7c7b\u6cd5"));
        this.validateRight();
        String sFileExt = CMyFile.extractFileExt(sImportFile);
        if (sFileExt == null || (sFileExt = sFileExt.trim()).length() == 0) {
            oReports.addFailedReport(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label10", "\u53c2\u6570[ImportFile=") + sImportFile + I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label11", "]\u4e0d\u6b63\u786e\uff01\u6ca1\u6709\u540e\u7f00\u540d"), null);
            return oReports;
        }
        sFileExt = sFileExt.toUpperCase();
        String sFileName = this.getAbsoluteFileName(sImportFile);
        if (sFileExt.equals("TXT")) {
            this.importFromTXT(sFileName, oReports, _methodContext, false);
        } else if (sFileExt.equals("ZIP")) {
            this.importFromZIP(sFileName, oReports, _methodContext);
        } else if (sFileExt.equals("XML")) {
            this.importClassInfosFromXML(sFileName, oReports, _methodContext);
        } else {
            oReports.addFailedReport(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label10", "\u53c2\u6570[ImportFile=") + sImportFile + I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label12", "]\u540e\u7f00\u4e0d\u6b63\u786e\uff01\u4e0d\u662f.zip\u540e\u7f00\u540d"), null);
            return oReports;
        }
        return oReports;
    }

    private void importFromTXT(String _sTxtFile, Reports _oReports, MethodContext _methodContext, boolean bClassInfoName) throws Exception {
        boolean bContainCode = _methodContext.getValue("ContainCode", true);
        int importType = _methodContext.getValue("importType", 0);
        int importrootid = _methodContext.getValue("importRootId", 0);
        String sClassInfoName = null;
        if (!bClassInfoName) {
            String sRealFileName = _methodContext.getValue("RealFileName");
            sClassInfoName = CMyFile.extractMainFileName(sRealFileName);
        } else {
            sClassInfoName = CMyFile.extractMainFileName(_sTxtFile);
        }
        boolean bResult = false;
        ClassInfoUtil util = new ClassInfoUtil();
        try {
            bResult = util.importClassInfos(sClassInfoName, _sTxtFile, bContainCode, importType, importrootid);
            if (bResult) {
                _oReports.addSucessedReport(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label13", "\u6210\u529f\u5bfc\u5165\u5206\u7c7b\u6cd5\uff1a") + sClassInfoName);
            } else {
                String sMsg = I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label14", "\u5bfc\u5165\u7684\u5206\u7c7b\u6cd5[") + sClassInfoName + I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label15", "]\u51fa\u73b0\u91cd\u590d\uff0c\u5df2\u8df3\u8fc7");
                _oReports.addFailedReport(sMsg, new Exception(sMsg));
            }
        }
        catch (Exception e) {
            _oReports.addFailedReport(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label16", "\u5bfc\u5165\u5206\u7c7b\u6cd5[") + sClassInfoName + I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label17", "]\u5931\u8d25"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFromZIP(String _sZipFile, Reports _oReports, MethodContext _methodContext) {
        User loginUser = this.getLoginUser();
        String sUnZIPTempPath = CMyFile.extractFilePath(_sZipFile);
        sUnZIPTempPath = sUnZIPTempPath + "temp" + System.currentTimeMillis() + File.separator;
        int importType = _methodContext.getValue("importType", 0);
        try {
            ArrayList allTxtFiles;
            block12: {
                CMyUnZipFile uzf = new CMyUnZipFile(_sZipFile, sUnZIPTempPath);
                uzf.setFileNameEncoding("GBK");
                uzf.addFileExtFilters("TXT");
                uzf.addFileExtFilters("XML");
                uzf.doUnZipAnd();
                allTxtFiles = uzf.getFilteredFiles();
                if (allTxtFiles != null && !allTxtFiles.isEmpty()) break block12;
                return;
            }
            try {
                String sDataFile = null;
                for (int i = allTxtFiles.size() - 1; i >= 0; --i) {
                    sDataFile = (String)allTxtFiles.get(i);
                    if (sDataFile.endsWith("txt")) {
                        this.importFromTXT(sDataFile, _oReports, _methodContext, true);
                        continue;
                    }
                    ClassInfoImporter importer = new ClassInfoImporter(loginUser);
                    importer.importFromXML(sDataFile, importType);
                    _oReports.merge(importer.getReports());
                }
            }
            catch (CMyException e) {
                _oReports.addFailedReport(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label18", "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25![File=") + _sZipFile + ",DstPath=" + sUnZIPTempPath + "]", e);
            }
        }
        catch (Exception e) {
            _oReports.addFailedReport(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label19", "\u5bfc\u5165\u5206\u7c7b\u6cd5\u5931\u8d25!"), e);
        }
        finally {
            if (sUnZIPTempPath != null) {
                CMyFile.deleteDir(sUnZIPTempPath);
            }
        }
    }

    private String getAbsoluteFileName(String _sFileName) throws WCMException {
        String sAbsolutFileName = null;
        FilesMan filesMan = FilesMan.getFilesMan();
        String[] pFlag = new String[]{"U0", "ST"};
        for (int i = 0; i < pFlag.length; ++i) {
            if (!FilesMan.isValidFile(_sFileName, pFlag[i])) continue;
            sAbsolutFileName = filesMan.mapFilePath(_sFileName, 0) + _sFileName;
            break;
        }
        if (sAbsolutFileName == null) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label20", "\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + _sFileName + "]");
        }
        if (!CMyFile.fileExists(sAbsolutFileName)) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label20", "\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + sAbsolutFileName + "]");
        }
        return sAbsolutFileName;
    }

    public void changeOrder(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nSrcObjectId = _methodContext.getValue("SrcObjectId", 0);
        ClassInfo srcObject = this.findClassInfoById(nSrcObjectId);
        int nDstObjectId = _methodContext.getValue("DstObjectId", 0);
        ClassInfo dstObject = null;
        if (nDstObjectId > 0) {
            dstObject = this.findClassInfoById(nDstObjectId);
        }
        int nNewOrder = dstObject == null ? -1 : dstObject.getOrder();
        srcObject.setOrder(nNewOrder);
        srcObject.save(loginUser);
    }

    public void moveAsChild(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nSrcObjectId = _methodContext.getValue("SrcObjectId", 0);
        ClassInfo srcObject = this.findClassInfoById(nSrcObjectId);
        int nDstObjectId = _methodContext.getValue("DstObjectId", 0);
        ClassInfo dstObject = this.findClassInfoById(nDstObjectId);
        if (srcObject.getParentId() == nDstObjectId) {
            return;
        }
        if (srcObject.getRootId() != dstObject.getRootId()) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label21", "\u5206\u7c7b\u8282\u70b9[") + nSrcObjectId + "," + nDstObjectId + I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label22", "]\u4e0d\u5728\u4e00\u68f5\u5206\u7c7b\u6811\u4e0a\uff0c\u4e0d\u80fd\u79fb\u52a8"));
        }
        if (this.m_oClassInfoMgr.isAncestor(nSrcObjectId, nDstObjectId)) {
            throw new WCMException(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label21", "\u5206\u7c7b\u8282\u70b9[") + nSrcObjectId + I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label23", "]\u4e3a\u8282\u70b9[") + nDstObjectId + I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label24", "]\u7684\u7956\u5148\u8282\u70b9\uff0c\u4e0d\u80fd\u79fb\u52a8"));
        }
        srcObject.setParentId(nDstObjectId);
        int nMaxOrder = ClassInfo.getMaxOrder(nDstObjectId);
        srcObject.refreshProperty("ClassOrder", nMaxOrder);
        srcObject.setOrder(1);
        srcObject.save(loginUser);
    }

    public String exportClassInfos(MethodContext _oMethodContext) throws WCMException {
        this.validateRight();
        User loginUser = this.getLoginUser();
        String sClassInfoIds = _oMethodContext.getValue("ClassInfoIds");
        ClassInfos classInfos = null;
        classInfos = CMyString.isEmpty(sClassInfoIds) ? ClassInfos.openWCMObjs(loginUser, null) : ClassInfos.findByIds(loginUser, sClassInfoIds);
        FilesMan filesMan = FilesMan.getFilesMan();
        String sFileName = filesMan.getNextFilePathName("ST", "xml");
        ClassInfoXMLConvertor convertor = new ClassInfoXMLConvertor();
        convertor.toXMLFile(classInfos, sFileName);
        return CMyFile.extractFileName(sFileName);
    }

    private void importClassInfosFromXML(String _sFileName, Reports _oReports, MethodContext _oMethodContext) throws WCMException {
        User loginUser = this.getLoginUser();
        try {
            String sImportFile = _oMethodContext.getValue("ImportFile");
            int importType = _oMethodContext.getValue("importType", 0);
            ClassInfoImporter importer = new ClassInfoImporter(loginUser);
            importer.importFromXML(sImportFile, importType);
            _oReports.merge(importer.getReports());
        }
        catch (Exception ex) {
            _oReports.addFailedReport(I18NMessage.get(ClassInfoServiceProvider.class, "ClassInfoServiceProvider.label19", "\u5bfc\u5165\u5206\u7c7b\u6cd5\u5931\u8d25!"), ex);
        }
    }
}

