/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition.xml;

import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.XmlToObjConverterByDOM4j;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.Reports;

public class ClassInfoImporter {
    private User m_oCurrUser = null;
    private Reports m_reports = new Reports("");

    public ClassInfoImporter(User _currUser) {
        this.m_oCurrUser = _currUser;
    }

    public Reports getReports() {
        return this.m_reports;
    }

    public void importFromXML(String _sXMLFile, int _nImportType) throws WCMException {
        String sImportFile = _sXMLFile;
        if (!CMyFile.fileExists(sImportFile)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            sImportFile = filesMan.mapFilePath(_sXMLFile, 0) + _sXMLFile;
        }
        if (!CMyFile.fileExists(sImportFile)) {
            throw new WCMException(I18NMessage.get(ClassInfoImporter.class, "ClassInfoImporter.label1", "\u5b9a\u4e49\u5206\u7c7b\u6cd5\u4fe1\u606f\u7684XML\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[") + _sXMLFile + "][" + sImportFile + "]");
        }
        XmlToObjConverterByDOM4j convertor = new XmlToObjConverterByDOM4j(1);
        convertor.registPersistentObj("XWCMCLASSINFO", ClassInfo.class);
        XmlObject[] pXmlObjects = convertor.convertXml(sImportFile, null, null);
        int nRootClassInfoId = 0;
        ClassInfo parentClassInfo = null;
        this.processClassInfos(nRootClassInfoId, parentClassInfo, pXmlObjects, _nImportType);
    }

    private void processClassInfos(int _nRootClassInfoId, ClassInfo _parentClassInfo, XmlObject[] _pXmlObjects, int _nImportType) throws WCMException {
        int nParentClassInfoId = _parentClassInfo == null ? 0 : _parentClassInfo.getId();
        for (int i = 0; i < _pXmlObjects.length; ++i) {
            XmlObject oXmlObject = _pXmlObjects[i];
            ClassInfo currClassInfo = (ClassInfo)oXmlObject.getCurrentObj();
            String sClassInfoName = currClassInfo.getName();
            ClassInfo classInfoTemp = this.findClassInfoByName(_nRootClassInfoId, nParentClassInfoId, sClassInfoName);
            boolean bSkip = false;
            if (classInfoTemp == null || classInfoTemp != null && _nImportType == 2) {
                currClassInfo.removeProperty("CLASSINFOID");
                currClassInfo.removeProperty("CRUSER");
                currClassInfo.removeProperty("CRTIME");
                currClassInfo.setRootId(_nRootClassInfoId);
                currClassInfo.setParentId(nParentClassInfoId);
                currClassInfo.save(this.m_oCurrUser);
            } else if (_nImportType == 0) {
                currClassInfo = classInfoTemp;
                if (classInfoTemp.getParentId() == 0) {
                    bSkip = true;
                    this.m_reports.addSucessedReport(I18NMessage.get(ClassInfoImporter.class, "ClassInfoImporter.label2", "\u8df3\u8fc7\u5206\u7c7b\u6cd5\uff1a") + currClassInfo.getName());
                }
            } else if (_nImportType == 1) {
                try {
                    int nClassInfoId = classInfoTemp.getId();
                    classInfoTemp.setProperty("CRUSER", this.m_oCurrUser.getName());
                    classInfoTemp.setProperty("CRTIME", CMyDateTime.now());
                    classInfoTemp.save(this.m_oCurrUser);
                    if (classInfoTemp.getParentId() == 0) {
                        String deleteSQL = "delete from XWCMClassInfo where RootId=" + nClassInfoId;
                        DBManager.getDBManager().sqlExecuteUpdate(deleteSQL);
                    }
                    currClassInfo = classInfoTemp;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (currClassInfo.getParentId() == 0 && !bSkip) {
                this.m_reports.addSucessedReport(I18NMessage.get(ClassInfoImporter.class, "ClassInfoImporter.label3", "\u6210\u529f\u5bfc\u5165\u5206\u7c7b\u6cd5\uff1a") + currClassInfo.getName());
            }
            XmlObject[] pClassInfoXMLObjects = oXmlObject.getChild("XWCMCLASSINFOS");
            int nRealRootClassInfoId = _nRootClassInfoId == 0 ? currClassInfo.getId() : _nRootClassInfoId;
            this.processClassInfos(nRealRootClassInfoId, currClassInfo, pClassInfoXMLObjects, _nImportType);
        }
    }

    private ClassInfo findClassInfoByName(int _nRootClassInfoId, int _nParentId, String _sTableName) throws WCMException {
        String sWhere = "RootId=? and ParentId=? and  CName=?";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(_nRootClassInfoId);
        filter.addSearchValues(_nParentId);
        filter.addSearchValues(_sTableName);
        ClassInfos classInfos = ClassInfos.openWCMObjs(this.m_oCurrUser, filter);
        if (classInfos != null && !classInfos.isEmpty()) {
            return (ClassInfo)classInfos.getAt(0);
        }
        return null;
    }
}

