/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget.acceptor;

import com.trs.components.common.publish.widget.WidgetParameter;
import com.trs.components.common.publish.widget.acceptor.BaseWidgetAcceptor;
import com.trs.components.common.publish.widget.acceptor.IWidgetAcceptorContext;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.image.CMyImage;
import org.apache.log4j.Logger;

public class ImageRollingWidgetAcceptor
extends BaseWidgetAcceptor {
    private static Logger logger = Logger.getLogger(ImageRollingWidgetAcceptor.class);

    private boolean verifyTop(IWidgetAcceptorContext context) {
        float fMinTop = 100.0f;
        String sMinTop = this.getExtraParam("\u6700\u5c0f\u9876\u90e8\u4f4d\u7f6e");
        try {
            if (!CMyString.isEmpty(sMinTop)) {
                fMinTop = this.getExpressionEval(sMinTop);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6700\u5c0f\u9876\u90e8\u4f4d\u7f6e:" + fMinTop));
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u667a\u80fd\u8d44\u6e90\u9009\u62e9\u5668[" + this.getWidgetName() + "]\u53c2\u6570[\u6700\u5c0f\u9876\u90e8\u4f4d\u7f6e]\u8bbe\u7f6e\u4e0d\u5408\u6cd5[" + sMinTop + "]"), (Throwable)e);
        }
        float fMaxTop = 400.0f;
        String sMaxTop = this.getExtraParam("\u6700\u5927\u9876\u90e8\u4f4d\u7f6e");
        try {
            if (!CMyString.isEmpty(sMaxTop)) {
                fMaxTop = this.getExpressionEval(sMaxTop);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6700\u5927\u9876\u90e8\u4f4d\u7f6e:" + fMaxTop));
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u667a\u80fd\u8d44\u6e90\u9009\u62e9\u5668[" + this.getWidgetName() + "]\u53c2\u6570[\u6700\u5927\u9876\u90e8\u4f4d\u7f6e]\u8bbe\u7f6e\u4e0d\u5408\u6cd5[" + sMaxTop + "]"), (Throwable)e);
        }
        float top = context.getTop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u83b7\u53d6\u5f53\u524d\u8d44\u6e90\u7684\u9876\u90e8\u4f4d\u7f6e:" + top));
        }
        return !(top < fMinTop) && !(top > fMaxTop);
    }

    private boolean verifyWidth(IWidgetAcceptorContext context) throws WCMException {
        String sLocalFilePath;
        float fMinWidth = 276.0f;
        String sMinWidth = this.getExtraParam("\u6700\u5c0f\u5bbd\u5ea6");
        try {
            if (!CMyString.isEmpty(sMinWidth)) {
                fMinWidth = this.getExpressionEval(sMinWidth);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6700\u5c0f\u5bbd\u5ea6:" + fMinWidth));
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u667a\u80fd\u8d44\u6e90\u9009\u62e9\u5668[" + this.getWidgetName() + "]\u53c2\u6570[\u6700\u5c0f\u5bbd\u5ea6]\u8bbe\u7f6e\u4e0d\u5408\u6cd5[" + sMinWidth + "]"), (Throwable)e);
        }
        float fMaxWidth = 540.0f;
        String sMaxWidth = this.getExtraParam("\u6700\u5927\u5bbd\u5ea6");
        try {
            if (!CMyString.isEmpty(sMaxWidth)) {
                fMaxWidth = this.getExpressionEval(sMaxWidth);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6700\u5927\u5bbd\u5ea6:" + fMaxWidth));
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u667a\u80fd\u8d44\u6e90\u9009\u62e9\u5668[" + this.getWidgetName() + "]\u53c2\u6570[\u6700\u5927\u5bbd\u5ea6]\u8bbe\u7f6e\u4e0d\u5408\u6cd5[" + sMaxWidth + "]"), (Throwable)e);
        }
        int nWidth = (int)context.getWidth();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u83b7\u53d6\u5f53\u524d\u8d44\u6e90\u7684\u5bbd\u5ea6:" + nWidth));
        }
        if ((float)nWidth < fMinWidth || (float)nWidth > fMaxWidth) {
            return false;
        }
        context.setWidgetParameter("\u56fe\u7247\u5bbd\u5ea6", String.valueOf(nWidth));
        String sImageFirstFrom = "content";
        WidgetParameter oImageFromParameter = this.widgetParameterMgr.findParameterByName(this.getWidget(), "\u56fe\u7247\u6765\u6e90");
        if (oImageFromParameter != null) {
            sImageFirstFrom = CMyString.showNull(oImageFromParameter.getDefaultValue(), "content");
        }
        if (CMyString.isEmpty(sLocalFilePath = this.findFirstImage(context, sImageFirstFrom))) {
            return false;
        }
        int[] size = CMyImage.getImageSize(sLocalFilePath);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u56fe\u7247\u5b9e\u9645\u5c3a\u5bf8[" + size[0] + "," + size[1] + "]"));
        }
        if (size[0] == -1 || size[1] == -1) {
            return false;
        }
        int nHeight = (int)(1.0 * (double)size[1] / (double)size[0] * (double)nWidth);
        context.setWidgetParameter("\u56fe\u7247\u9ad8\u5ea6", String.valueOf(nHeight));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u8ba1\u7b97\u540e\u7684\u56fe\u7247\u9ad8\u5ea6[" + nHeight + "]"));
        }
        return true;
    }

    private boolean verifyImageNumber(IWidgetAcceptorContext context) throws WCMException {
        String sDefaultNumber;
        int nMinNumber = 1;
        String sMinNumber = this.getExtraParam("\u6700\u5c0f\u663e\u793a\u4e2a\u6570");
        try {
            if (!CMyString.isEmpty(sMinNumber)) {
                nMinNumber = Integer.parseInt(sMinNumber);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6700\u5c0f\u663e\u793a\u4e2a\u6570:" + nMinNumber));
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u667a\u80fd\u8d44\u6e90\u9009\u62e9\u5668[" + this.getWidgetName() + "]\u53c2\u6570[\u6700\u5c0f\u663e\u793a\u4e2a\u6570]\u8bbe\u7f6e\u4e0d\u5408\u6cd5[" + sMinNumber + "]"), (Throwable)e);
        }
        int nMaxNumber = 6;
        String sMaxNumber = this.getExtraParam("\u6700\u5927\u663e\u793a\u4e2a\u6570");
        try {
            if (!CMyString.isEmpty(sMaxNumber)) {
                nMaxNumber = Integer.parseInt(sMaxNumber);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6700\u5927\u663e\u793a\u4e2a\u6570:" + nMaxNumber));
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u667a\u80fd\u8d44\u6e90\u9009\u62e9\u5668[" + this.getWidgetName() + "]\u53c2\u6570[\u6700\u5927\u663e\u793a\u4e2a\u6570]\u8bbe\u7f6e\u4e0d\u5408\u6cd5[" + sMaxNumber + "]"), (Throwable)e);
        }
        int nImageCount = this.getImageDocsCount(context);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u5f53\u524d\u680f\u76ee\u4e0b\u7684\u56fe\u7247\u6570:" + nImageCount));
        }
        if (nImageCount < nMinNumber || nImageCount > nMaxNumber) {
            return false;
        }
        int nDefaultNumber = nMaxNumber;
        WidgetParameter numberParameter = this.widgetParameterMgr.findParameterByName(this.getWidget(), "\u663e\u793a\u4e2a\u6570");
        if (numberParameter != null && !CMyString.isEmpty(sDefaultNumber = numberParameter.getDefaultValue())) {
            nDefaultNumber = Integer.parseInt(sDefaultNumber);
        }
        int nNumber = Math.min(nDefaultNumber, nMaxNumber);
        context.setWidgetParameter("\u663e\u793a\u4e2a\u6570", String.valueOf(nNumber));
        return true;
    }

    @Override
    public boolean accept(IWidgetAcceptorContext context) throws WCMException {
        if (this.findChannel(context).getDesc().equals(this.getWidgetName())) {
            return true;
        }
        if (!this.verifyTop(context)) {
            return false;
        }
        if (!this.verifyImageNumber(context)) {
            return false;
        }
        return this.verifyWidth(context);
    }
}

