/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import com.trs.components.common.publish.domain.taskdispatch.IAtomTask;
import com.trs.components.common.publish.domain.taskdispatch.PublishTaskRuntime;
import com.trs.infra.I18NMessage;
import org.apache.log4j.Logger;

public class TaskWorker
implements Runnable {
    private static final Logger s_logger = Logger.getLogger(TaskWorker.class);
    private PublishTaskRuntime m_oTaskRuntime;

    @Override
    public void run() {
        this.m_oTaskRuntime.registerWorker(this);
        try {
            this.runTaskLoop();
        }
        catch (Throwable t) {
            s_logger.error((Object)I18NMessage.get(TaskWorker.class, "TaskWorker.label1", "\u975e\u9884\u671f\u7684\u5f02\u5e38"), t);
        }
        this.m_oTaskRuntime.deregisterWorker(this);
    }

    private void runTaskLoop() {
        block5: {
            try {
                int iResult;
                IAtomTask task = null;
                do {
                    if ((task = this.m_oTaskRuntime.getNextTask(task)) != null) continue;
                    return;
                } while (0 == (iResult = task.execute()));
                if (1 == iResult) {
                    this.m_oTaskRuntime.suspend();
                    break block5;
                }
                if (2 == iResult) {
                    this.m_oTaskRuntime.fail(null);
                    break block5;
                }
                throw new Exception(I18NMessage.get(TaskWorker.class, "TaskWorker.label2", "\u975e\u9884\u671f\u7684\u4efb\u52a1\u6267\u884c\u7ed3\u679c:") + iResult);
            }
            catch (Throwable t) {
                this.m_oTaskRuntime.fail(t);
            }
        }
    }

    public PublishTaskRuntime getTaskRuntime() {
        return this.m_oTaskRuntime;
    }

    public void setTaskRuntime(PublishTaskRuntime taskRuntime) {
        if (taskRuntime == null) {
            throw new NullPointerException("PublishTaskRuntime is null.");
        }
        this.m_oTaskRuntime = taskRuntime;
    }
}

