/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.infra.common.WCMException;
import java.util.List;
import org.apache.log4j.Logger;

public class TagParserIsFirstRecord
extends BaseTagParser {
    private static Logger logger = Logger.getLogger(TagParserIsFirstRecord.class);
    private static final int PAGE_SIZE_UNINITED = -1;
    private static final int PAGE_SIZE_NOT_SET = 0;
    private int mStartPos = 0;
    private int mPageSize = -1;
    private static final int DEFAULT_PAGE_SIZE = 20;

    private int getPageSize(PublishTagContext context) throws WCMException {
        if (this.mPageSize != -1) {
            return this.mPageSize;
        }
        int nNum = -1;
        for (TagItem item = context.getTagItem(); item != null; item = item.getParent()) {
            this.mPageSize = item.getIntAttribute("PageSize", 0);
            if (this.mPageSize != 0) {
                this.mStartPos = item.getIntAttribute("StartPos", 0);
                break;
            }
            nNum = item.getIntAttribute("Num", 0);
            if (nNum != 0) {
                this.mPageSize = nNum;
                this.mStartPos = item.getIntAttribute("StartPos", 0);
                break;
            }
            int nStartPos = item.getIntAttribute("StartPos", -1);
            if (nStartPos == -1) continue;
            this.mStartPos = nStartPos;
            break;
        }
        return this.mPageSize;
    }

    @Override
    public String[] parse(PublishTagContext context) throws WCMException {
        String[] result;
        boolean bReverse;
        int nPageSize = this.getPageSize(context);
        int nIndex = context.getSequenceNumber();
        ITagParser4List myTagParserList = context.getTagParser4List();
        int nRecordSize = myTagParserList.getRecordSize();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RecordSize:" + nRecordSize + ",PageSize:" + nPageSize + ",Index:" + nIndex + ",StartPos:" + this.mStartPos));
        }
        if (!(bReverse = context.getAttribute("reverse", false))) {
            if (nIndex % nRecordSize == 1 || nPageSize != 0 && nIndex % nPageSize == 1) {
                TagItem oTagItem = context.getTagItem();
                List tagChildren = oTagItem.getChildren();
                result = TagParseHelper.parseItems(tagChildren, context);
            } else {
                result = null;
            }
        } else if (nIndex % nRecordSize == 1 || nPageSize != 0 && nIndex % nPageSize == 1) {
            result = null;
        } else {
            TagItem oTagItem = context.getTagItem();
            List tagChildren = oTagItem.getChildren();
            result = TagParseHelper.parseItems(tagChildren, context);
        }
        return result;
    }
}

