/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DataType;
import org.apache.log4j.Logger;

public class ExtendedField
extends CMSObj {
    private static Logger logger = Logger.getLogger(ExtendedField.class);
    private static final char CHAR_UNDERLINE = '_';
    public static final int OBJ_TYPE = 4;
    public static final String DB_TABLE_NAME = "WCMEXTFIELD";
    public static final String DB_ID_NAME = "EXTFIELDID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 4;
    }

    public String getTableName() {
        return this.getPropertyAsString("TABLENAME");
    }

    public boolean setTableName(String _tableName) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(ExtendedField.class, "ExtendedField.label1", "\u5c5e\u6027TableName\u4e0d\u5141\u8bb8\u4fee\u6539\uff08ExtendedField.setTableName\uff09"));
        }
        if (_tableName == null) {
            throw new WCMException(10, I18NMessage.get(ExtendedField.class, "ExtendedField.label2", "\u6307\u5b9a\u7684\u8868\u540d\u79f0\u4e3a\u7a7a\uff08ExtendedField.setTableName\uff09"));
        }
        _tableName = _tableName.toUpperCase();
        if (this.getDBManager().getTableInfo(_tableName) == null) {
            throw new WCMException(10, I18NMessage.get(ExtendedField.class, "ExtendedField.label3", "\u6307\u5b9a\u7684\u6570\u636e\u8868") + _tableName + I18NMessage.get(ExtendedField.class, "ExtendedField.label4", "\u4e0d\u5b58\u5728\uff08ExtendedField.setTableName\uff09"));
        }
        return this.setProperty("TABLENAME", _tableName.toUpperCase());
    }

    public String getName() {
        return this.getPropertyAsString("FIELDNAME");
    }

    public boolean setName(String _sName) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(ExtendedField.class, "ExtendedField.label5", "\u5c5e\u6027Name\u4e0d\u5141\u8bb8\u4fee\u6539\uff08ExtendedField.setName\uff09"));
        }
        return this.setProperty("FIELDNAME", _sName.toUpperCase());
    }

    public String getDesc() {
        return this.getPropertyAsString("FIELDDESC");
    }

    public boolean setDesc(String _sDesc) throws WCMException {
        return this.setProperty("FIELDDESC", _sDesc);
    }

    public String getTypeName() {
        return this.getPropertyAsString("FIELDTYPE");
    }

    public String getTypeDesc() throws WCMException {
        return DataType.toTypeDescription(this.getType());
    }

    public DataType getType() throws WCMException {
        String sType = this.getTypeName();
        return sType == null ? null : this.getDBManager().getDBType().getDataType(sType);
    }

    public int getMaxLength() {
        return this.getPropertyAsInt("FIELDMAXLEN", 0);
    }

    public int getScale() {
        return this.getPropertyAsInt("FIELDSCALE", 0);
    }

    public boolean isNullable() {
        return this.getPropertyAsBoolean("FIELDNULLABLE", true);
    }

    public String getDefaultValue() {
        return this.getPropertyAsString("FIELDDEFAULT");
    }

    public int getDefaultValueAsInt(int _default) throws WCMException {
        String sValue = this.getDefaultValue();
        if (sValue == null || (sValue = sValue.trim()).length() == 0) {
            return _default;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (Exception ex) {
            throw new WCMException(2, I18NMessage.get(ExtendedField.class, "ExtendedField.label6", "\u9ed8\u8ba4\u503c\u4e0d\u662f\u6574\u6570\uff08ExtendedField.getDefaultValueAsInt\uff09"), ex);
        }
    }

    public boolean setType(String _typeName, int _maxLength) throws WCMException {
        return this.setType(_typeName, _maxLength, true, null);
    }

    public boolean setType(String _typeName, int _maxLength, boolean _bNullable, String _sDefaultValue) throws WCMException {
        return this.setType(_typeName, _maxLength, _bNullable, _sDefaultValue, 0);
    }

    public boolean setType(String _typeName, int _maxLength, boolean _bNullable, String _sDefaultValue, int _nScale) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(ExtendedField.class, "ExtendedField.label7", "\u5c5e\u6027Name\u4e0d\u5141\u8bb8\u4fee\u6539\uff08ExtendedField.setType\uff09"));
        }
        if (_typeName == null) {
            throw new WCMException(10, I18NMessage.get(ExtendedField.class, "ExtendedField.label8", "\u6307\u5b9a\u5b57\u6bb5\u7c7b\u578b\u4e3a\u7a7a\uff08ExtendedField.setType\uff09"));
        }
        if (_maxLength < 0) {
            throw new WCMException(10, I18NMessage.get(ExtendedField.class, "ExtendedField.label9", "\u6307\u5b9a\u6700\u5927\u957f\u5ea6\u5c0f\u4e8e0\uff1a") + _maxLength + "\uff08ExtendedField.setType\uff09");
        }
        if (!_bNullable && _sDefaultValue == null) {
            throw new WCMException(10, I18NMessage.get(ExtendedField.class, "ExtendedField.label10", "\u975e\u7a7a\u5b57\u6bb5\u5fc5\u987b\u8bbe\u7f6e\u9ed8\u8ba4\u503c\uff08ExtendedField.setType\uff09"));
        }
        DataType dataType = this.getDBManager().getDBType().getDataType(_typeName);
        if (dataType == null) {
            throw new WCMException(10, I18NMessage.get(ExtendedField.class, "ExtendedField.label11", "\u65e0\u6548\u7684\u6570\u636e\u7c7b\u578b\uff1a") + _typeName + "\uff08ExtendedField.setType\uff09");
        }
        int nLengthLimit = dataType.getMaxLength();
        if (!dataType.isLengthDefinedByUser()) {
            _maxLength = nLengthLimit;
        } else if (_maxLength > nLengthLimit) {
            throw new WCMException(10, I18NMessage.get(ExtendedField.class, "ExtendedField.label12", "\u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7") + nLengthLimit + "\uff08ExtendedField.setType\uff09");
        }
        if (!this.setProperty("FIELDTYPE", _typeName)) {
            return false;
        }
        if (!this.setProperty("FIELDMAXLEN", _maxLength)) {
            return false;
        }
        if (!this.setProperty("FIELDNULLABLE", _bNullable)) {
            return false;
        }
        if (!this.setProperty("FIELDSCALE", _nScale)) {
            return false;
        }
        return _bNullable ? true : this.setProperty("FIELDDEFAULT", _sDefaultValue);
    }

    @Override
    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    @Override
    public boolean setAttribute(String _attribute) throws WCMException {
        return this.setProperty("ATTRIBUTE", _attribute);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            String sTableName = (String)this.getAllProperty().get("TABLENAME");
            if (sTableName == null) {
                throw new WCMException(1106, I18NMessage.get(ExtendedField.class, "ExtendedField.label13", "\u5c5e\u6027TableName\u6ca1\u6709\u8bbe\u7f6e(ExtendedField.isValid)"));
            }
            String sName = (String)this.getAllProperty().get("FIELDNAME");
            if (sName == null || sName.trim().length() == 0) {
                throw new WCMException(1106, I18NMessage.get(ExtendedField.class, "ExtendedField.label14", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(ExtendedField.isValid)"));
            }
            if (CMyString.isContainChineseChar(sName)) {
                throw new WCMException(1104, I18NMessage.get(ExtendedField.class, "ExtendedField.label15", "\u5c5e\u6027Name\u65e0\u6548,\u4e0d\u5141\u8bb8\u5305\u542b\u4e2d\u6587\u5b57\u7b26\u7684\u6269\u5c55\u5b57\u6bb5\u540d!"));
            }
            this.assertValidName(sName);
            this.setName(sName);
            if (this.getDBManager().getFieldInfo(sTableName, sName) != null) {
                throw new WCMException(1108, I18NMessage.get(ExtendedField.class, "ExtendedField.label16", "\u6570\u636e\u8868") + sTableName + I18NMessage.get(ExtendedField.class, "ExtendedField.label17", "\u4e2d\u5df2\u7ecf\u5b58\u5728\u5b57\u6bb5") + sName + "\uff08ExtendedField.isValid\uff09");
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(ExtendedField.class, "ExtendedField.label18", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ExtendedField.isValid)"));
        }
        return true;
    }

    @Override
    public void update(User _currUser) throws WCMException {
        super.update(_currUser);
        if ("NVARCHAR".equalsIgnoreCase(this.getTypeName()) && this.isChangeProperty("FIELDMAXLEN")) {
            DBManager dbmanager = this.getDBManager();
            try {
                String[] strSQLs = new String[]{dbmanager.getDBType().sqlModifyField(this.getTableName(), this.getName(), 12, this.getMaxLength(), this.isNullable(), this.getScale())};
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("UpdateSQL: " + strSQLs[0]));
                }
                dbmanager.sqlExecuteUpdate(strSQLs);
            }
            catch (Exception ex) {
                throw new WCMException(1100, "\u4fee\u6539\u6269\u5c55\u5b57\u6bb5\u5931\u8d25!", ex);
            }
            dbmanager.reloadTableInfo(this.getTableName());
        }
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(_currUser);
            DBManager dbmanager = this.getDBManager();
            try {
                String[] strSQLs = new String[]{dbmanager.getDBType().sqlAddField(this.getTableName(), this.getName(), this.getTypeName(), this.getMaxLength(), this.isNullable(), this.getDefaultValue(), this.getScale())};
                dbmanager.sqlExecuteUpdate(strSQLs);
            }
            catch (Exception ex) {
                try {
                    String sql = "DELETE FROM WCMEXTFIELD WHERE FieldName='" + this.getName() + "'";
                    dbmanager.sqlExecuteUpdate(sql);
                }
                catch (Exception ex2) {
                    logger.fatal((Object)"Faield rollback:\n", (Throwable)ex2);
                }
                throw new WCMException(1100, I18NMessage.get(ExtendedField.class, "ExtendedField.label19", "\u6dfb\u52a0\u6269\u5c55\u5b57\u6bb5\u5931\u8d25!"), ex);
            }
            dbmanager.reloadTableInfo(this.getTableName());
        }
    }

    @Override
    public int delete(User _currUser) throws WCMException {
        if (!this.getDBManager().getDBType().canDropField()) {
            return 0;
        }
        String sCondition = " EXTFIELDID in (select EXTFIELDID from WCMCONTENTEXTFIELD where EXTFIELDID=" + this.getId() + ")";
        if (this.checkExists(sCondition)) {
            throw new WCMException(1100, I18NMessage.get(ExtendedField.class, "ExtendedField.label20", "\u67d0\u4e9b\u9891\u9053\u6b63\u5728\u4f7f\u7528\u8be5\u6269\u5c55\u5b57\u6bb5\uff0c\u4e0d\u80fd\u5220\u9664\uff08ExtentedField.delete\uff09"));
        }
        DBManager dbmanager = DBManager.getDBManager();
        try {
            String[] strSQLs = new String[]{this.getDBManager().getDBType().sqlDropField(this.getTableName(), this.getName())};
            dbmanager.sqlExecuteUpdate(strSQLs);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(ExtendedField.class, "ExtendedField.label21", "\u5220\u9664\u6570\u636e\u5e93\u4e2d\u7684\u6269\u5c55\u5b57\u6bb5\u5931\u8d25\uff08ExtendedField.delete\uff09"), ex);
        }
        int nDeleted = super.delete(_currUser);
        dbmanager.reloadTableInfo(this.getTableName());
        return nDeleted;
    }

    public static final ExtendedField findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (ExtendedField)BaseObj.findById(ExtendedField.class, _nId);
    }

    public static final ExtendedField createNewInstance() throws WCMException {
        return (ExtendedField)BaseObj.createNewInstance(ExtendedField.class);
    }

    public static final ExtendedField findByKey(Object _oKey) throws WCMException {
        return (ExtendedField)BaseObj.findByKey(ExtendedField.class, _oKey);
    }

    private void assertValidName(String _name) throws WCMException {
        char[] arChar = _name.toCharArray();
        char ch = arChar[0];
        if (!ExtendedField.isEnglishChar(ch)) {
            throw new WCMException(1104, I18NMessage.get(ExtendedField.class, "ExtendedField.label22", "\u65e0\u6548\u7684\u6269\u5c55\u5b57\u6bb5\u540d,\u6269\u5c55\u5b57\u6bb5\u540d\u7684\u7b2c\u4e00\u4e2a\u5b57\u7b26\u5fc5\u987b\u662f\u82f1\u6587\u5b57\u7b26!"));
        }
        for (int i = 1; i < arChar.length; ++i) {
            ch = arChar[i];
            if (ch == '_' || ExtendedField.isEnglishChar(ch) || ExtendedField.isNumricChar(ch)) continue;
            throw new WCMException(1104, I18NMessage.get(ExtendedField.class, "ExtendedField.label23", "\u65e0\u6548\u7684\u6269\u5c55\u5b57\u6bb5\u540d,\u6269\u5c55\u5b57\u6bb5\u540d\u53ea\u80fd\u7531\u82f1\u6587\u5b57\u7b26\u548c\u6570\u5b57\u7ec4\u6210!\u5305\u542b\u65e0\u6548\u7684\u5b57\u7b26[") + ch + "]");
        }
    }

    private static boolean isNumricChar(int ch) {
        return ch >= 48 && ch <= 57;
    }

    private static boolean isEnglishChar(int ch) {
        return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122;
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return I18NMessage.get(ExtendedField.class, "ExtendedField.label24", "[\u6269\u5c55\u5b57\u6bb5-") + this.getId() + "]" + this.getName();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExtendedField)) {
            return false;
        }
        ExtendedField field = (ExtendedField)obj;
        if (!field.getName().equalsIgnoreCase(this.getName())) {
            return false;
        }
        try {
            return this.getType().equals(field.getType());
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(ExtendedField.class, "ExtendedField.label25", "\u5bf9\u4e8eData Type\u6bd4\u8f83\u5931\u8d25\uff01"), (Throwable)e);
            return false;
        }
    }
}

