/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.GroupUser;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.I18NMessage;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.cache.ICacheMgr;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GroupAdminsCacheMgr
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify,
ICacheMgr {
    public static long LRU_CACHE_EXPIRES = 3600000L;
    public static int MAX_CACHE_SIZE = 4000;
    private static Cache cache = (Cache)DreamFactory.createObjectById("lruCache");

    public GroupAdminsCacheMgr() {
        cache.setMaxSize(MAX_CACHE_SIZE);
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        GroupUser groupUser = (GroupUser)_oObjAdded;
        if (groupUser.isAdministrator()) {
            this.addToCache(groupUser);
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        GroupUser groupUser = (GroupUser)_oObjDeleted;
        if (groupUser.isAdministrator()) {
            this.removeFromCache(groupUser);
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        GroupUser groupUser = (GroupUser)_oObjModified;
        if (groupUser.isChangeProperty("ISADMINISTRATOR")) {
            int admin = groupUser.getNewPropertyAsInt("ISADMINISTRATOR", 0);
            if (admin == 0) {
                this.removeFromCache(groupUser);
            } else {
                this.addToCache(groupUser);
            }
        }
    }

    public Users getAdmins(Group _group) throws WCMException {
        this.assertNotNull(_group);
        Users admins = this.getGroupAdmins(_group.getId());
        Users results = new Users(User.getSystem());
        results.addWith(admins);
        return results;
    }

    @Override
    public boolean init() throws WCMException {
        return true;
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    @Override
    public void clear() {
    }

    private void assertNotNull(Group _group) throws WCMException {
        if (_group == null) {
            throw new WCMException(10, I18NMessage.get(GroupAdminsCacheMgr.class, "GroupAdminsCacheMgr.label1", "\u65e0\u6548\u7684\u7528\u6237\u7ec4\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u5176\u7ba1\u7406\u5458\u96c6\u5408!"));
        }
    }

    private void addToCache(GroupUser _groupUser) throws WCMException {
        this.reloadCache(_groupUser.getGroupId());
    }

    private void removeFromCache(GroupUser _groupUser) throws WCMException {
        this.reloadCache(_groupUser.getGroupId());
    }

    private Users getGroupAdmins(int _nGroupId) throws WCMException {
        Integer iKey = new Integer(_nGroupId);
        Users users = null;
        List<Object> list = cache.lrange(this.getKey(iKey), 0L, -1L);
        if (list != null && list.size() > 0) {
            String _sIds = StringUtils.join(list, (String)",");
            users = Users.findByIds(null, _sIds);
        }
        if (users != null) {
            return users;
        }
        users = this.initCache(_nGroupId);
        return users;
    }

    private synchronized Users initCache(int _nGroupId) throws WCMException {
        return this.reloadCache(_nGroupId);
    }

    private Users reloadCache(int _nGroupId) throws WCMException {
        Integer iKey = new Integer(_nGroupId);
        String sWhereSql = "GroupId=? AND IsAdministrator=1";
        WCMFilter aFilter = new WCMFilter("WCMGrpUser", sWhereSql, "", "UserId");
        aFilter.addSearchValues(_nGroupId);
        Users users = Users.openWCMObjs(null, aFilter);
        cache.clear(this.getKey(iKey));
        for (int i = 0; i < users.size(); ++i) {
            cache.rpush(this.getKey(iKey), users.getAt(i).getKey());
        }
        cache.pexpire(this.getKey(iKey), LRU_CACHE_EXPIRES);
        return users;
    }

    private String getKey() {
        return this.getClass().getName();
    }

    private String getKey(Integer sGroupId) {
        return this.getKey() + "." + sGroupId;
    }
}

