/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster.receiver;

import com.trs.cluster.IClusterMsgReceiver;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.store.FileService;

public class FileWithdrawMsgReceiver
implements IClusterMsgReceiver {
    @Override
    public void receive(BaseObj eventObject, int eventType) throws Exception {
    }

    @Override
    public void receive(String content, String[] parameters) throws Exception {
        if (!"FILE.WITHDRAW".equals(content)) {
            return;
        }
        String filename = parameters[0];
        FileService file = new FileService(filename);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            boolean ok = file.renameTo(new FileService(file.getParentFileStore(), CMyFile.getTempFileName()));
            if (!ok) {
                throw new Exception("Failed to withdraw folder: " + file);
            }
        } else {
            int lastDot = filename.indexOf(46);
            String fn = filename.substring(0, lastDot);
            String fext = filename.substring(lastDot);
            int nPageIndex = 1;
            do {
                file.delete();
                file = new FileService(fn + "_" + nPageIndex + fext);
                ++nPageIndex;
            } while (file.exists());
            int len = parameters.length;
            for (int i = 1; i < len; ++i) {
                file = new FileService(parameters[i]);
                if (!file.exists()) continue;
                file.delete();
            }
        }
    }

    @Override
    public String[] registerMoniterMessages() {
        return new String[]{"FILE.WITHDRAW"};
    }

    @Override
    public int[] registerMoniterWCMObjTypesOnAdd() {
        return null;
    }

    @Override
    public int[] registerMoniterWCMObjTypesOnDel() {
        return null;
    }

    @Override
    public int[] registerMoniterWCMObjTypesOnModify() {
        return null;
    }

    public static void main(String[] args) {
        String filename = "test.txt";
        int lastDot = filename.indexOf(46);
        String fn = filename.substring(0, lastDot);
        String fext = filename.substring(lastDot);
        System.out.println(fn);
        System.out.println(fext);
    }
}

