/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.domain.RoleMgr;
import com.trs.cms.auth.domain.UserMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.presentation.util.LoginHelper;
import com.trs.service.IUserService;
import com.trs.service.impl.UserService;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.ArrayList;

public class UserServiceProvider
implements IGlueServiceProvider {
    @Override
    public void delete(MethodContext _methodContext) throws Throwable {
    }

    @Override
    public Object query(MethodContext _methodContext) throws Throwable {
        return null;
    }

    @Override
    public int save(MethodContext _methodContext) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        int nUserId = _methodContext.getValue("UserId", 0);
        int nGroupId = _methodContext.getValue("GroupId", 0);
        User currUser = null;
        Group currGroup = null;
        if (nUserId > 0) {
            currUser = User.findById(nUserId);
            if (currUser == null) {
                throw new WCMException(I18NMessage.get(UserServiceProvider.class, "UserServiceProvider.label4", "\u6ca1\u6709\u627e\u5230ID\u4e3a[") + nUserId + "]" + I18NMessage.get(UserServiceProvider.class, "UserServiceProvider.label3", "\u7684\u7528\u6237\uff01"));
            }
        } else {
            currUser = User.createNewInstance();
        }
        if (nGroupId > 0 && (currGroup = Group.findById(nGroupId)) == null) {
            throw new WCMException(I18NMessage.get(UserServiceProvider.class, "GroupServiceProvider.label1", "\u6ca1\u6709\u627e\u5230ID\u4e3a[") + nGroupId + "]" + I18NMessage.get(UserServiceProvider.class, "GroupServiceProvider.label2", "\u7684\u7ec4\u7ec7\uff01"));
        }
        this.validateUserSaveRigth(loginUser, currUser, currGroup);
        try {
            String[] stringArray;
            if (nUserId > 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "username";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "";
            }
            String[] pLogicFields = stringArray;
            currUser = (User)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, currUser, pLogicFields);
        }
        catch (Exception ex) {
            throw new WCMException(I18NMessage.get(UserServiceProvider.class, "UserServiceProvider.label5", "\u4fdd\u5b58\u7528\u6237\u65f6\u56e0\u5c5e\u6027\u503c\u4e0d\u6b63\u786e\u800c\u5931\u8d25\u4e2d\u6b62\uff01"));
        }
        IUserService currUserService = (IUserService)DreamFactory.createObjectById("IUserService");
        try {
            currUserService.save(currUser, currGroup);
        }
        catch (Exception ex) {
            throw new WCMException(I18NMessage.get(UserServiceProvider.class, "UserServiceProvider.label6", "\u4fdd\u5b58\u7528\u6237\u5931\u8d25\u4e2d\u6b62\uff01"), ex);
        }
        if (currGroup != null) {
            try {
                currUserService.enable(currUser);
            }
            catch (Exception ex) {
                throw new WCMException(I18NMessage.get(UserServiceProvider.class, "UserServiceProvider.label7", "\u5f00\u901a\u8d26\u53f7\u5931\u8d25\u4e2d\u6b62\uff01"));
            }
        }
        nUserId = currUser.getId();
        return nUserId;
    }

    private void validateUserSaveRigth(User loginUser, User currUser, Group currGroup) throws WCMException {
        if (currGroup == null) {
            UserMgr aMgr;
            boolean bIsManagerOfUser;
            boolean bUserSelf = loginUser.getName().equals(currUser.getName());
            boolean bIsAdmin = loginUser.isSecurityAdmin();
            if (!(bIsAdmin || bUserSelf || (bIsManagerOfUser = (aMgr = (UserMgr)DreamFactory.createObjectById("UserMgr")).isManagerOfUser(currUser)))) {
                throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label1", "\u60a8\u65e0\u6743\u4fdd\u5b58\u7528\u6237\uff01\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u7528\u6237\u81ea\u8eab\u6216\u7528\u6237\u521b\u5efa\u8005\u624d\u53ef\u4ee5\u66f4\u6539\u4fdd\u5b58\u7528\u6237\u4fe1\u606f."));
            }
        } else if (!AuthServer.hasRight(loginUser, currGroup)) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label3", "\u60a8\u65e0\u6743\u4fdd\u5b58\u7528\u6237\uff01"));
        }
    }

    @Override
    public Object findById(MethodContext _methodContext) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext _methodContext) throws Throwable {
        return null;
    }

    public Users getOnlineUsers() throws Throwable {
        return LoginHelper.getOnlineUsers();
    }

    public Users getUsersByNames(MethodContext _context) throws WCMException {
        String sNames = _context.getValue("userNames");
        if (CMyString.isEmpty(sNames)) {
            throw new WCMException(I18NMessage.get(UserServiceProvider.class, "UserServiceProvider.label1", "\u6ca1\u6709\u4f20\u5165[UserNames]\uff0c\u65e0\u6cd5\u6839\u636e\u7528\u6237\u540d\u8fdb\u884c\u67e5\u627e!"));
        }
        String[] arNames = sNames.split(",");
        Users result = Users.createNewInstance(ContextHelper.getLoginUser());
        ArrayList<String> arNotFoundNames = new ArrayList<String>(2);
        for (int i = 0; i < arNames.length; ++i) {
            String sName = arNames[i];
            User user = User.findByName(sName.trim());
            if (user == null) {
                arNotFoundNames.add(sName);
                continue;
            }
            result.addElement(user);
        }
        if (arNotFoundNames.size() != 0) {
            String sUserNames = "";
            for (int k = 0; k < arNotFoundNames.size(); ++k) {
                sUserNames = k == arNotFoundNames.size() - 1 ? sUserNames + arNotFoundNames.get(k) : (k == arNotFoundNames.size() - 2 ? sUserNames + arNotFoundNames.get(k) + I18NMessage.get(UserServiceProvider.class, "UserServiceProvider.label8", "\" \u548c \"") : sUserNames + arNotFoundNames.get(k) + "\", \"");
            }
            String sErrorInfo = CMyString.format(I18NMessage.get(UserServiceProvider.class, "UserServiceProvider.label2", "\u6ca1\u6709\u627e\u5230\u7528\u6237\u540d\u4e3a  \"{0}\" \u7684\u7528\u6237"), new String[]{sUserNames});
            throw new WCMException(200006, sErrorInfo);
        }
        return result;
    }

    public Users getUsersOfRole(MethodContext _context) throws WCMException {
        int nRoleId = _context.getValue("RoleId", 0);
        Role role = Role.findById(nRoleId);
        if (role == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89d2\u8272[RoleId" + nRoleId + "]\u6ca1\u6709\u627e\u5230");
        }
        if (role.getRoleType() == -1) {
            return this.getUsersOfSystemRoleOnSite(_context);
        }
        return this.getUsersOfSpecialRole(_context);
    }

    public Users getUsersOfSystemRoleOnSite(MethodContext _context) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        int nSiteId = _context.getValue("SiteId", 0);
        int nRoleId = _context.getValue("RoleId", 0);
        Role role = Role.findById(nRoleId);
        if (role == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89d2\u8272[RoleId" + nRoleId + "]\u6ca1\u6709\u627e\u5230");
        }
        if (role.getRoleType() != -1) {
            throw new WCMException("\u975e\u7cfb\u7edf\u7ea7\u89d2\u8272[RoleId" + nRoleId + "]\u4e0d\u80fd\u4f7f\u7528\u8be5\u63a5\u53e3");
        }
        if (!loginUser.isSecurityAdmin() && !this.getRoleMgr().isRoleManagers(loginUser)) {
            throw new WCMException("\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u89d2\u8272\u7ba1\u7406\u5458\u80fd\u83b7\u53d6\u89d2\u8272\u4e0b\u7684\u7528\u6237\u4fe1\u606f");
        }
        WCMFilter extraFilter = _context.getExtraWCMFilter();
        return this.getRoleMgr().getUsersBySystemRoleForUser(role, nSiteId, extraFilter);
    }

    public Users getUsersOfSpecialRole(MethodContext _context) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        int nRoleId = _context.getValue("RoleId", 0);
        Role role = Role.findById(nRoleId);
        if (role == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89d2\u8272[RoleId" + nRoleId + "]\u6ca1\u6709\u627e\u5230");
        }
        if (role.getRoleType() != 0) {
            throw new WCMException("\u975e\u7279\u5b9a\u89d2\u8272[RoleId" + nRoleId + "]\u4e0d\u80fd\u4f7f\u7528\u8be5\u63a5\u53e3");
        }
        RoleMgr roleMgr = this.getRoleMgr();
        if (!loginUser.isSecurityAdmin() && !roleMgr.isRoleManagers(loginUser)) {
            throw new WCMException("\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u89d2\u8272\u7ba1\u7406\u5458\u80fd\u83b7\u53d6\u89d2\u8272\u4e0b\u7684\u7528\u6237\u4fe1\u606f");
        }
        WCMFilter extraFilter = _context.getExtraWCMFilter();
        return roleMgr.getUsersBySpecailForUser(role, extraFilter);
    }

    private RoleMgr getRoleMgr() {
        return (RoleMgr)DreamFactory.createObjectById("RoleMgr");
    }

    public Users getUsersOfGroup(MethodContext _context) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        int nGroupId = _context.getValue("GroupId", 0);
        Group group = new Group();
        if (nGroupId != 0 && (group = Group.findById(nGroupId)) == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7ec4\u7ec7[GroupId" + nGroupId + "]\u6ca1\u6709\u627e\u5230");
        }
        IUserService userService = (IUserService)DreamFactory.createObjectById("IUserService");
        boolean bAdmin = loginUser.isSecurityAdmin();
        if (!bAdmin && !userService.isAdminOfGroup(loginUser)) {
            throw new WCMException("\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u7ec4\u7ec7\u7ba1\u7406\u5458\u80fd\u83b7\u53d6\u7ec4\u7ec7\u4e0b\u7684\u7528\u6237\u4fe1\u606f");
        }
        WCMFilter extraFilter = _context.getExtraWCMFilter();
        String sWhere = "STATUS=30 AND ISDELETED=0";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        extraFilter.mergeWith(filter);
        GroupMgr groupMgr = this.getGroupMgr();
        Users users = Users.createNewInstance(loginUser);
        if (bAdmin) {
            users = nGroupId == 0 ? Users.openWCMObjs(loginUser, extraFilter) : groupMgr.getUsers(group, extraFilter);
        } else if (nGroupId == 0) {
            Groups groups = groupMgr.getGroups(loginUser, null);
            for (int i = 0; i < groups.size(); ++i) {
                group = (Group)groups.getAt(i);
                users.addWith(groupMgr.getUsers(group, extraFilter, true));
            }
        } else {
            users = groupMgr.getUsers(group, extraFilter);
        }
        return users;
    }

    private GroupMgr getGroupMgr() {
        return (GroupMgr)DreamFactory.createObjectById("GroupMgr");
    }
}

