/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.ajaxservice.XmlToRightConvertor;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.RoleAuthServer;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.XmlObject;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;

public class AuthServiceProvider
implements ISelfDefinedServiceProvider {
    public String saveOperatorRights(MethodContext _methodContext) throws Exception {
        User loginUser = this.getLoginUser();
        CMSObj operator = this.makeOperator(_methodContext);
        this.validLoginUserIsAdminOfOperator(loginUser, operator);
        XmlToRightConvertor converter = new XmlToRightConvertor(2);
        XmlObject[] pXMLObject = converter.convertXml(_methodContext.getValue("RightsXML"), null);
        int nCount = pXMLObject.length;
        StringBuffer sbResult = new StringBuffer(nCount * 5);
        for (int i = 0; i < nCount; ++i) {
            XmlObject xmlObject = pXMLObject[i];
            Right right = (Right)xmlObject.getCurrentObj();
            if (right.isAddMode()) {
                right.setOperator(operator);
            } else {
                right.validCanEditAndLock(loginUser);
            }
            right.save(loginUser);
            if (i > 0) {
                sbResult.append(",");
            }
            sbResult.append(right.getId());
        }
        _methodContext.setReturnHTML(true);
        return sbResult.toString();
    }

    public String deleteOperatorRight(MethodContext _methodContext) throws Exception {
        User loginUser = this.getLoginUser();
        Right right = Right.findById(_methodContext.getObjectId());
        if (right == null) {
            throw new WCMException(I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label1", "\u6307\u5b9a\u7684Right\u5bf9\u8c61\u4e0d\u5b58\u5728![ID=") + _methodContext.getObjectId() + "]");
        }
        CMSObj operator = right.getOperator();
        this.validLoginUserIsAdminOfOperator(loginUser, operator);
        CMSObj host = this.makeObject(right.getObjType(), right.getObjId());
        int nRightIndex = 59;
        if (host instanceof WebSite) {
            nRightIndex = 7;
        } else if (host instanceof Channel) {
            nRightIndex = 55;
        }
        if (!loginUser.isSecurityAdmin() && !AuthServer.hasRight(loginUser, host, nRightIndex)) {
            throw new WCMException(I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u7ed9\u5f53\u524d\u5bf9\u8c61\u8bbe\u7f6e\u6743\u9650\uff01(\u64cd\u4f5c\u4eba=") + loginUser + I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label3", ",\u5bf9\u8c61=") + host + ")");
        }
        right.delete(loginUser);
        _methodContext.setReturnHTML(true);
        return AuthServer.getRightValue(host, operator).toString();
    }

    private CMSObj makeOperator(MethodContext _methodContext) throws WCMException {
        int nOperatorId = _methodContext.getValue("OperatorId", 0);
        int nOperatorType = _methodContext.getValue("OperatorType", 0);
        CMSObj operator = (CMSObj)BaseObj.findById(nOperatorType, nOperatorId);
        if (operator == null) {
            throw new WCMException(I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label4", "\u627e\u4e0d\u5230\u6307\u5b9a\u7684Operator[Type=") + nOperatorType + ",Id=" + nOperatorId + I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label5", "]\u6216\u8bb8\u88ab\u5220\u9664\uff1f"));
        }
        return operator;
    }

    private CMSObj makeObject(int _nObjectType, int _nObjectId) throws WCMException {
        CMSObj operator = (CMSObj)BaseObj.findById(_nObjectType, _nObjectId);
        if (operator == null) {
            throw new WCMException(I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label6", "\u627e\u4e0d\u5230\u6307\u5b9a\u7684Object[Type=") + _nObjectType + ",Id=" + _nObjectId + I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label5", "]\u6216\u8bb8\u88ab\u5220\u9664\uff1f"));
        }
        return operator;
    }

    private void validLoginUserIsAdminOfOperator(User _loginUser, CMSObj _operator) throws WCMException {
        if (_loginUser.isSecurityAdmin()) {
            return;
        }
        switch (_operator.getWCMType()) {
            case 204: {
                User user = (User)_operator;
                Groups groups = user.getGroups();
                int nSize = groups.size();
                for (int i = 0; i < nSize; ++i) {
                    Group group = (Group)groups.getAt(i);
                    if (group == null || !this.isAdminOfGroup(_loginUser, group)) continue;
                    return;
                }
                break;
            }
            case 201: {
                if (!this.isAdminOfGroup(_loginUser, (Group)_operator)) break;
                return;
            }
            case 203: {
                if (!RoleAuthServer.hasRight(_loginUser, (Role)_operator, 11)) break;
                return;
            }
        }
        throw new WCMException(I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label7", "\u7528\u6237[") + _loginUser.getName() + I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label8", "]\u6ca1\u6709\u6743\u9650\u7ba1\u7406") + _operator + "\uff01");
    }

    private boolean isAdminOfGroup(User loginUser, Group group) throws WCMException {
        if (group == null) {
            return false;
        }
        if (group.isAdministrator(loginUser)) {
            return true;
        }
        return this.isAdminOfGroup(loginUser, group.getParent());
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }
}

