/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent;

import com.trs.idm.exception.IdMException;
import com.trs.idm.interact.TransferUtil;
import com.trs.idm.interact.agent.AgentVersion;
import com.trs.idm.interact.agent.IClientTransfer;
import com.trs.idm.interact.agent.IDSSocketFactory;
import com.trs.idm.interact.protocol.PacketUtil;
import com.trs.idm.interact.protocol.ProtocolPacket;
import com.trs.idm.interact.protocol.RequestPacket;
import com.trs.idm.interact.protocol.ResponsePacket;
import com.trs.idm.util.CloseUtil;
import com.trs.idm.util.EnvUtil;
import com.trs.idm.util.PropertyUtil;
import com.trs.idm.util.SocketUtil;
import com.trs.idm.util.StringHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ClientTransfer
implements Runnable,
IClientTransfer {
    private static final Logger LOG = Logger.getLogger(ClientTransfer.class);
    private static final String DUMMY_SSL = "dummySSL";
    public static final int DETECT_INTERVAL = 300000;
    public static final int RECONNECT_INTERVAL = 30000;
    public static final int MAX_RESPONSE = Short.MAX_VALUE;
    private static final int EOF_CHAR = 25;
    private String agentName;
    private String host;
    private int port;
    private Properties props;
    private Socket socket;
    private volatile boolean socketAlive;
    private boolean enableDetect;
    private String serverInfo;
    private String nodeKeyOfIDSServer;
    private String idmServerCharset;

    public ClientTransfer(String host, int port, String agentName, String serverInfo, Properties props) {
        this.host = host;
        this.port = port;
        this.agentName = agentName;
        this.serverInfo = serverInfo;
        this.props = props;
        this.enableDetect = true;
    }

    public void init() throws IOException {
        CloseUtil.closeSocket(this.socket);
        try {
            this.socket = this.createSocket(this.host, this.port);
            this.socketAlive = true;
        }
        catch (IOException e) {
            LOG.error((Object)("fail to connect IDS Server: [" + this.host + ":" + this.port + "]"), (Throwable)e);
            this.socketAlive = false;
            CloseUtil.closeSocket(this.socket);
            throw e;
        }
        int soTimeout = PropertyUtil.getPropertyAsInt(this.props, "soTimeout", 150000);
        if (soTimeout < 15000 || soTimeout > 300000) {
            soTimeout = 150000;
        }
        SocketUtil.setTimeout(this.socket, soTimeout);
        SocketUtil.setTcpNoDelay(this.socket, true);
        LOG.info((Object)SocketUtil.getSocketDetail(this.socket));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getResponse(byte[] req) throws IOException {
        if (req == null) {
            throw new IllegalArgumentException("request bytes is null!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("socketAlive=" + this.socketAlive + ", send req=" + StringHelper.toString(req)));
        }
        byte[] resp = null;
        try {
            ClientTransfer clientTransfer = this;
            synchronized (clientTransfer) {
                this.sendRequestBytes(req, this.socket.getOutputStream());
                resp = this.readResponseBytes(this.socket.getInputStream());
            }
        }
        catch (IOException e) {
            LOG.error((Object)("sendRequestBytes fail! retry init. " + this.agentName), (Throwable)e);
            try {
                this.init();
            }
            catch (Exception e1) {
                LOG.error((Object)("retry init fail! " + this.agentName), (Throwable)e1);
            }
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("return resp=" + StringHelper.toString(resp)));
        }
        return resp;
    }

    private Socket createSocket(String host, int port) throws UnknownHostException, IOException {
        if ("plain".equals(this.props.getProperty("socketType"))) {
            return new Socket(host, port);
        }
        return IDSSocketFactory.createSSLSocket(host, port, DUMMY_SSL.equals(this.props.getProperty("socketType")));
    }

    public void close() {
        CloseUtil.closeSocket(this.socket);
        this.socketAlive = false;
        this.enableDetect = false;
    }

    private byte[] readResponseBytes(InputStream inStream) throws IOException {
        int eofChar;
        byte[] result = null;
        byte[] head = TransferUtil.readBytes(inStream, 16);
        short bodyLenth = PacketUtil.parseBodyLength(head);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("response head=" + StringHelper.toString(head) + ", bodyLen=" + bodyLenth));
        }
        if (bodyLenth > 0) {
            byte[] body = TransferUtil.readBytes(inStream, bodyLenth);
            result = new byte[head.length + body.length];
            System.arraycopy(head, 0, result, 0, head.length);
            System.arraycopy(body, 0, result, head.length, body.length);
        }
        if ((eofChar = inStream.read()) != 25) {
            LOG.error((Object)("invalid protocol eof char: " + eofChar));
        }
        return result == null ? head : result;
    }

    private void sendRequestBytes(byte[] bytes, OutputStream outStream) throws IOException {
        outStream.write(bytes);
        outStream.write(25);
        outStream.flush();
    }

    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("enableDetect=" + this.enableDetect));
        }
        while (this.enableDetect) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("socketAlive=" + this.socketAlive));
            }
            if (!this.socketAlive) {
                try {
                    this.init();
                }
                catch (Exception e) {
                    LOG.error((Object)"init fail!", (Throwable)e);
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (Exception e) {
                    LOG.error((Object)"wait (reconnect) fail!", (Throwable)e);
                }
                continue;
            }
            try {
                this.checkConnected();
            }
            catch (Exception e) {
                LOG.warn((Object)"check Connect fail!", (Throwable)e);
            }
            try {
                Thread.sleep(300000L);
            }
            catch (Exception e) {
                LOG.error((Object)"wait (detect) fail!", (Throwable)e);
            }
        }
    }

    private void checkConnected() throws IdMException, IOException {
        byte[] bs = new byte[]{};
        try {
            RequestPacket req = new RequestPacket(100, bs, 2, this.idmServerCharset);
            this.getResponse(req.toBytes());
        }
        catch (RuntimeException e) {
            LOG.error((Object)("fail on detect! agent=" + this.agentName), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOG.error((Object)("socket disconnected! agent=" + this.agentName), (Throwable)e);
            throw e;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSocketAlive() {
        return this.socketAlive;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("agentName=").append(this.agentName);
        sb.append(';').append("socket=").append(this.socket);
        sb.append(';').append(super.toString());
        return sb.toString();
    }

    public String getNodeKeyOfIDSServer() {
        return null;
    }

    public void initCoAppConfig() throws IOException {
        String logoutUri = this.props.getProperty("logout.uri", "/logout.jsp");
        String allowGuest = this.props.getProperty("allow.anonymous", "n");
        try {
            RequestPacket req = new RequestPacket(81, new String[]{this.agentName, logoutUri, allowGuest, this.serverInfo, EnvUtil.getJavaEnvInfo(), AgentVersion.getReleaseInfo(), AgentVersion.getSourceLocation()}, null);
            byte[] bytesResp = this.getResponse(req.toBytes());
            ProtocolPacket packet = PacketUtil.parseFromBytes(bytesResp);
            if (!(packet instanceof ResponsePacket)) {
                LOG.error((Object)("received: [" + packet + "] not a ResponsePacket! IDS Server: [" + this.host + ":" + this.port + "]"));
                throw new IOException("Received is not a IDS ResponsePacket!");
            }
            ResponsePacket resp = (ResponsePacket)packet;
            if (resp.getErrCode() != 1) {
                throw new IOException("the coAppName:[" + this.agentName + "] not exist on IDS Server: [" + this.host + ":" + this.port + "]");
            }
            this.nodeKeyOfIDSServer = resp.getData(0);
            this.idmServerCharset = resp.getData(1);
            LOG.info((Object)(String.valueOf(this.agentName) + " connected IDS, localSocketAddr=" + this.socket.getLocalSocketAddress() + ", idsSocketAddr=" + this.host + ":" + this.port + ", nodeKeyOfIDSServer=" + this.nodeKeyOfIDSServer + ", idmServerCharset=" + this.idmServerCharset));
        }
        catch (IdMException e) {
            LOG.error((Object)"fail on send init info!", (Throwable)e);
        }
    }
}

