/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.exception.WrappedException;
import com.trs.dev4.jdk16.file.IFile;
import com.trs.dev4.jdk16.file.IProgressListener;
import com.trs.dev4.jdk16.file.impl.LocalFile;
import com.trs.dev4.jdk16.utils.AssertUtil;
import com.trs.dev4.jdk16.utils.CloseUtil;
import com.trs.dev4.jdk16.utils.EncodingDetector;
import com.trs.dev4.jdk16.utils.EnvConst;
import com.trs.dev4.jdk16.utils.FTPUtil;
import com.trs.dev4.jdk16.utils.IOUtil;
import com.trs.dev4.jdk16.utils.ObjectUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import com.trs.dev4.jdk16.utils.UrlUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class FileUtil {
    private static final Logger logger = Logger.getLogger(FileUtil.class);
    private static final String UTF_8 = "UTF-8";
    public static final String UNIVERSAL_SEPARATOR = "/";
    public static final String LINE_FEED = System.getProperty("line.separator");

    public static boolean createNewFile(File f) {
        FileUtil.createFolder(f.getParent());
        try {
            return f.createNewFile();
        }
        catch (IOException e) {
            throw new WrappedException("create file [" + f + "] failed.", e);
        }
    }

    public static boolean createNewFile(String sPath) {
        if (StringHelper.isEmpty(sPath)) {
            return false;
        }
        return FileUtil.createNewFile(new File(sPath));
    }

    public static boolean createFolder(String dirPath) {
        File dir = new File(dirPath);
        return FileUtil.createFolder(dir);
    }

    public static boolean createFolder(File dir) {
        if (dir.exists()) {
            if (dir.isDirectory()) {
                return false;
            }
            throw new WrappedException("create folder [" + dir + "] failed, because it exists, but not a folder.");
        }
        boolean ok = dir.mkdirs();
        if (ok) {
            return true;
        }
        throw new WrappedException("create folder [" + dir + "] failed.");
    }

    public static boolean deleteFile(String strFile) {
        if (strFile == null) {
            return false;
        }
        return FileUtil.deleteFile(new File(strFile));
    }

    public static boolean deleteFile(File file) {
        if (file == null || !file.isFile()) {
            return false;
        }
        return file.delete();
    }

    public static String assertExist(String path) {
        AssertUtil.notNull(path, "path is null!");
        File f = new File(path);
        if (f.exists()) {
            if (f.isDirectory()) {
                return StringHelper.smartAppendSuffix(f.getAbsolutePath(), File.separator);
            }
            return f.getAbsolutePath();
        }
        throw new IllegalArgumentException("the path [" + path + "] not exist!");
    }

    public static File assertDirExists(File f) {
        if (f == null || !f.isDirectory()) {
            throw new WrappedException("dir not exist: [" + f + "]");
        }
        return f;
    }

    public static File assertIsDir(String path) {
        File f = new File(path);
        return FileUtil.assertDirExists(f);
    }

    public static void assertFileExists(File f) {
        if (f == null || !f.isFile()) {
            throw new IllegalArgumentException("file not exist: [" + f + "]");
        }
    }

    public static void assertFileNotEmpty(File f) {
        FileUtil.assertFileExists(f);
        if (f.length() == 0L) {
            throw new WrappedException("file exist but is zero size: [" + f + "]");
        }
    }

    public static void assertFileExists(File folder, String ... filenames) {
        FileUtil.assertDirExists(folder);
        int i = 0;
        while (i < filenames.length) {
            File file = new File(folder, filenames[i]);
            FileUtil.assertFileExists(file);
            ++i;
        }
    }

    public static void assertFileCanRead(File file) {
        FileUtil.assertFileExists(file);
        if (!file.canRead()) {
            throw new IllegalArgumentException("the file [" + file + "] can not read by user [" + EnvConst.getProcessUser() + "]");
        }
    }

    public static String getFileExtension(File f) {
        AssertUtil.notNull(f, "the file object is null!");
        String filename = f.getName();
        int lastDotPosition = filename.lastIndexOf(46);
        if (lastDotPosition == -1) {
            return null;
        }
        return filename.substring(lastDotPosition + 1);
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null || "".equals(fileName.trim())) {
            throw new NullPointerException("the fileName is null!");
        }
        int lastDotPosition = fileName.lastIndexOf(46);
        if (lastDotPosition == -1) {
            return null;
        }
        return fileName.substring(lastDotPosition + 1);
    }

    public static String getFileNameWithoutExt(String fileName) {
        AssertUtil.notNull(fileName, "the fileName is null.");
        fileName = fileName.trim();
        if (fileName.length() == 0) {
            throw new IllegalArgumentException("the fileName is empty.");
        }
        int lastDotPosition = fileName.lastIndexOf(46);
        if (lastDotPosition == -1) {
            return fileName;
        }
        return fileName.substring(0, lastDotPosition);
    }

    public static String getFileNameWithoutExt(File file) {
        AssertUtil.notNull(file, "the file is null.");
        return FileUtil.getFileNameWithoutExt(file.getName());
    }

    public static String getParentPath(File f) {
        if (f == null) {
            return null;
        }
        File parentFile = f.getParentFile();
        if (parentFile == null) {
            return null;
        }
        String parentPath = parentFile.getAbsolutePath();
        if (!parentPath.endsWith(UNIVERSAL_SEPARATOR)) {
            parentPath = String.valueOf(parentPath) + UNIVERSAL_SEPARATOR;
        }
        return parentPath;
    }

    public static String getFileExtensionWithDot(File f) {
        if (f == null) {
            throw new NullPointerException("the file object is null!");
        }
        String filename = f.getName();
        int lastDotPosition = filename.lastIndexOf(46);
        if (lastDotPosition == -1) {
            return null;
        }
        return filename.substring(lastDotPosition);
    }

    public static void copyFile(File fSrc, File fDst) {
        if (fSrc == null || fDst == null) {
            throw new IllegalArgumentException("the file object is null!");
        }
        if (!fSrc.exists()) {
            throw new IllegalArgumentException("the fSrc [ " + fSrc + " ] is not exist!");
        }
        if (!fSrc.isFile()) {
            throw new IllegalArgumentException("the fSrc [ " + fSrc + " ] is NOT a file!");
        }
        if (fDst.isDirectory()) {
            fDst = new File(fDst, fSrc.getName());
        }
        if (!fDst.exists()) {
            FileUtil.createNewFile(fDst);
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        int BUF_SIZE = 4096;
        int len = 0;
        byte[] buf = new byte[4096];
        try {
            try {
                fis = new FileInputStream(fSrc);
                fos = new FileOutputStream(fDst);
                bis = new BufferedInputStream(fis, 4096);
                bos = new BufferedOutputStream(fos, 4096);
                while ((len = bis.read(buf)) > 0) {
                    bos.write(buf, 0, len);
                }
            }
            catch (IOException e) {
                throw new WrappedException(e);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.closeOutputStream(bos);
            CloseUtil.closeOutputStream(fos);
            CloseUtil.closeInputStream(bis);
            CloseUtil.closeInputStream(fis);
            throw throwable;
        }
        CloseUtil.closeOutputStream(bos);
        CloseUtil.closeOutputStream(fos);
        CloseUtil.closeInputStream(bis);
        CloseUtil.closeInputStream(fis);
    }

    public static void copyIntoFolder(File fSrc, File fDst) {
        AssertUtil.notNull(fSrc, "fSrc is null.");
        AssertUtil.notNull(fDst, "fDst is null.");
        if (fSrc.isFile()) {
            FileUtil.copyFile(fSrc, fDst);
            return;
        }
        File[] srcFiles = fSrc.listFiles();
        if (srcFiles == null || srcFiles.length == 0) {
            return;
        }
        if (!fDst.isDirectory()) {
            if (fDst.exists()) {
                throw new WrappedException("[" + fDst + "] \u5df2\u5b58\u5728\uff0c\u4f46\u4e0d\u662f\u76ee\u5f55!");
            }
            fDst.mkdirs();
        }
        String destPath = String.valueOf(fDst.getAbsolutePath()) + File.separatorChar;
        File[] fileArray = srcFiles;
        int n = srcFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File srcFile = fileArray[n2];
            File destFile = new File(String.valueOf(destPath) + srcFile.getName());
            if (srcFile.isDirectory()) {
                FileUtil.copyIntoFolder(srcFile, destFile);
            } else {
                FileUtil.copyFile(srcFile, destFile);
            }
            ++n2;
        }
    }

    public static String loadFirstLine(File file, String charsetName) throws IOException {
        String string;
        if (file == null || !file.isFile()) {
            throw new IllegalArgumentException("the file [ " + file + " ] is NOT a file!");
        }
        if (file.length() > 32767L) {
            throw new IllegalArgumentException("the file too large! size(in bytes): " + file.length());
        }
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader((InputStream)new FileInputStream(file), charsetName);
            br = new BufferedReader(isr);
            string = br.readLine();
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                CloseUtil.closeReader(br);
                CloseUtil.closeReader(isr);
                throw throwable;
            }
        }
        CloseUtil.closeReader(br);
        CloseUtil.closeReader(isr);
        return string;
    }

    public static void moveFile(File fSrc, File fDst) throws IOException {
        if (fSrc == null || fDst == null) {
            throw new IllegalArgumentException("one of the two file object is null: fSrc=" + fSrc + "; fDst=" + fDst);
        }
        if (!fSrc.isFile()) {
            throw new IllegalArgumentException("the fSrc [ " + fSrc + " ] is NOT a file!");
        }
        if (fDst.exists()) {
            throw new IllegalArgumentException("the fDst [ " + fSrc + " ] is already exist!");
        }
        boolean success = fSrc.renameTo(fDst);
        if (success) {
            return;
        }
        File destDir = fDst.getParentFile();
        if (!destDir.canWrite()) {
            throw new IOException("user [" + System.getProperty("user.name") + "] not have write permission on dest dir [" + destDir + "]!");
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(fSrc);
            fos = new FileOutputStream(fDst);
            byte[] buf = new byte[8192];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
            fSrc.delete();
        }
        catch (Throwable throwable) {
            CloseUtil.closeInputStream(fis);
            CloseUtil.closeOutputStream(fos);
            throw throwable;
        }
        CloseUtil.closeInputStream(fis);
        CloseUtil.closeOutputStream(fos);
    }

    public static void moveFolder(File fSrc, File fDst) throws IOException {
        File[] srcFiles;
        if (fSrc == null || fDst == null) {
            throw new IllegalArgumentException("one of the two file object is null!");
        }
        if (!fSrc.isDirectory()) {
            throw new IllegalArgumentException("the fSrc [ " + fSrc + " ] is NOT a directory!");
        }
        if (!fDst.isDirectory()) {
            fDst.mkdirs();
        }
        String destPath = String.valueOf(fDst.getAbsolutePath()) + File.separatorChar;
        File[] fileArray = srcFiles = fSrc.listFiles();
        int n = srcFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File srcFile = fileArray[n2];
            File destFile = new File(String.valueOf(destPath) + srcFile.getName());
            if (srcFile.isDirectory()) {
                FileUtil.moveFolder(srcFile, destFile);
            } else {
                FileUtil.moveFile(srcFile, destFile);
            }
            ++n2;
        }
        fSrc.delete();
    }

    public static boolean fileExists(String fileName) {
        if (fileName == null) {
            return false;
        }
        File file = new File(fileName);
        return file.isFile();
    }

    public static long fileLength(String fileName) {
        File file = new File(fileName);
        return file.length();
    }

    public static long copyFile(File fSrc, File fDst, IProgressListener listener) {
        long l;
        AssertUtil.notNull(fSrc, "src file is null!");
        AssertUtil.notNull(fDst, "dest file is null!");
        if (!fSrc.isFile()) {
            throw new IllegalArgumentException("the fSrc [ " + fSrc + " ] is NOT a file!");
        }
        if (fDst.isDirectory()) {
            fDst = new File(fDst, fSrc.getName());
        }
        if (!fDst.exists()) {
            FileUtil.createNewFile(fDst);
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(fSrc);
            fos = new FileOutputStream(fDst);
            l = IOUtil.copy(fis, fos, listener, fSrc.length());
        }
        catch (IOException e) {
            try {
                throw new WrappedException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.closeOutputStream(fos);
                CloseUtil.closeInputStream(fis);
                throw throwable;
            }
        }
        CloseUtil.closeOutputStream(fos);
        CloseUtil.closeInputStream(fis);
        return l;
    }

    public static void copyFile(String fSrc, String fDst) {
        FileUtil.copyFile(new File(fSrc), new File(fDst));
    }

    public static String getFileText(String file) {
        return FileUtil.readFileText(file, UTF_8);
    }

    public static String readFileText(String file, String encoding) {
        StringBuilder sb = new StringBuilder();
        FileInputStream in = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            try {
                in = new FileInputStream(file);
                isr = new InputStreamReader((InputStream)in, encoding);
                br = new BufferedReader(isr);
                String line = br.readLine();
                while (line != null) {
                    sb.append(line).append(EnvConst.NEWLINE);
                    line = br.readLine();
                }
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.closeReader(br);
            CloseUtil.closeReader(isr);
            CloseUtil.closeInputStream(in);
            throw throwable;
        }
        CloseUtil.closeReader(br);
        CloseUtil.closeReader(isr);
        CloseUtil.closeInputStream(in);
        return sb.toString();
    }

    public static List<String> loadText(File file, String encoding) {
        List<String> list;
        FileUtil.assertFileCanRead(file);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            list = IOUtil.loadText(in, encoding);
        }
        catch (IOException e) {
            try {
                throw new WrappedException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.closeInputStream(in);
                throw throwable;
            }
        }
        CloseUtil.closeInputStream(in);
        return list;
    }

    @Deprecated
    public static void forceWriteFile(String filePath, List<String> lines) throws Exception {
        FileWriter fWriter = new FileWriter(filePath);
        PrintWriter pWriter = new PrintWriter(fWriter);
        int i = 0;
        while (i < lines.size()) {
            pWriter.println(lines.get(i));
            ++i;
        }
        try {
            fWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        pWriter.close();
    }

    public static void writeTextToFile(String content, File file) {
        FileUtil.writeTextToFile(content, file, UTF_8, false);
    }

    public static void appendTextToFile(String content, File file) {
        AssertUtil.notNull(file, "file is null");
        if (file.isDirectory()) {
            throw new IllegalArgumentException("cannot write text to a directory! (" + file + ")");
        }
        if (file.length() == 0L) {
            FileUtil.writeTextToFile(content, file, UTF_8, true);
        } else {
            FileUtil.writeTextToFile(String.valueOf(EnvConst.NEWLINE) + content, file, UTF_8, true);
        }
    }

    static void writeTextToFile(String content, File file, String encoding, boolean append) {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            try {
                fos = new FileOutputStream(file, append);
                osw = new OutputStreamWriter((OutputStream)fos, encoding);
                osw.write(content);
            }
            catch (IOException e) {
                throw new WrappedException(e);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.closeWriter(osw);
            CloseUtil.closeOutputStream(fos);
            throw throwable;
        }
        CloseUtil.closeWriter(osw);
        CloseUtil.closeOutputStream(fos);
    }

    public static void replaceByToken(File file, String matchedToken, String replacement) {
        FileUtil.replaceByToken(file, matchedToken, replacement, UTF_8);
    }

    public static void replaceByToken(File file, String matchedToken, String replacement, String encoding) {
        String content = FileUtil.readFileText(file.getAbsolutePath(), encoding);
        String replaced = StringHelper.replaceAll(content, matchedToken, replacement);
        FileUtil.writeTextToFile(replaced, file, encoding, false);
    }

    public static boolean dirExists(String path) {
        if (StringHelper.isEmpty(path)) {
            return false;
        }
        return new File(path).exists();
    }

    public static String formatPath(File sourceFile) {
        if (sourceFile == null) {
            return null;
        }
        return FileUtil.formatPath(sourceFile.getAbsolutePath());
    }

    public static String formatPath(String physicalPath) {
        if (StringHelper.isEmpty(physicalPath)) {
            return null;
        }
        if (".".equals(physicalPath)) {
            physicalPath = FileUtil.getCurrentWorkingDir();
        } else if ("..".equals(physicalPath)) {
            physicalPath = FileUtil.getParentDir();
        }
        String formerPath = physicalPath.replace('\\', '/');
        File file = new File(formerPath);
        if (file.isDirectory() && !formerPath.endsWith(UNIVERSAL_SEPARATOR)) {
            formerPath = String.valueOf(formerPath) + UNIVERSAL_SEPARATOR;
        }
        return formerPath;
    }

    public static String toNativePath(String physicalPath) {
        String formattedPath = FileUtil.formatPath(physicalPath);
        if (formattedPath == null) {
            return null;
        }
        formattedPath = formattedPath.replace('/', File.separatorChar);
        formattedPath = formattedPath.replace('\\', File.separatorChar);
        return formattedPath;
    }

    public static List<File> listFilesInDir(File folder, boolean recursive) {
        FileUtil.assertDirExists(folder);
        File[] aryFiles = folder.listFiles();
        ArrayList<File> files = new ArrayList<File>();
        int i = 0;
        while (i < aryFiles.length) {
            if (aryFiles[i].isFile()) {
                files.add(aryFiles[i]);
            } else if (aryFiles[i].isDirectory() && recursive) {
                files.addAll(FileUtil.listFilesInDir(aryFiles[i], recursive));
            }
            ++i;
        }
        return files;
    }

    public static List<File> listFilesInDir(File folder, final String ... exts) {
        File[] arrFile = exts.length == 0 ? folder.listFiles() : folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String[] stringArray = exts;
                int n = exts.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    if (pathname.getName().endsWith(ext)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
        return Arrays.asList(arrFile);
    }

    public static List<IFile> listSamenameFiles(String dirLocation, String encoding, List<IFile> refs, String ... exts) {
        List<IFile> files = FileUtil.listFiles(dirLocation, encoding, exts);
        if (refs == null || refs.size() == 0) {
            return files;
        }
        ArrayList<IFile> result = new ArrayList<IFile>();
        for (IFile iFile : refs) {
            IFile silimarFile = FileUtil.findSilimarNameFile(files, iFile);
            if (silimarFile == null) continue;
            result.add(silimarFile);
        }
        return result;
    }

    private static IFile findSilimarNameFile(List<IFile> files, IFile refFile) {
        for (IFile iFile : files) {
            if (!FileUtil.sameNameExcludeSuffix(iFile, refFile)) continue;
            return iFile;
        }
        return null;
    }

    private static boolean sameNameExcludeSuffix(IFile iFile, IFile refFile) {
        if (iFile == null || refFile == null) {
            return false;
        }
        if (ObjectUtil.equals(iFile.getName(), refFile.getName())) {
            return false;
        }
        String mainName = FileUtil.getFileNameWithoutExt(iFile.getName());
        String refName = FileUtil.getFileNameWithoutExt(refFile.getName());
        return mainName.equals(refName);
    }

    public static List<IFile> listFiles(String dirLocation, String encoding, String ... exts) {
        URL url;
        AssertUtil.notNullOrEmpty(dirLocation, "dirLocation");
        if (FileUtil.dirExists(dirLocation)) {
            return LocalFile.listFiles(dirLocation, exts);
        }
        try {
            url = new URL(dirLocation);
        }
        catch (MalformedURLException e) {
            throw new WrappedException("the protocol unsupprted, url: " + dirLocation, e);
        }
        if (UrlUtil.isFtp(url)) {
            String host = UrlUtil.getHost(url);
            String remoteDir = UrlUtil.getRemoteDir(url);
            String userName = UrlUtil.getUserName(url);
            String passwd = UrlUtil.getPassword(url);
            int port = UrlUtil.getPort(url);
            return FTPUtil.list(host, port, userName, passwd, encoding, remoteDir, exts);
        }
        throw new WrappedException("the protocol " + url.getProtocol() + " unsupprted, url: " + dirLocation);
    }

    public static List<File> listSubFolder(File folder) {
        FileUtil.assertDirExists(folder);
        ArrayList<File> files = new ArrayList<File>();
        File[] aryFiles = folder.listFiles();
        int i = 0;
        while (i < aryFiles.length) {
            if (aryFiles[i].isDirectory()) {
                files.add(aryFiles[i]);
            }
            ++i;
        }
        return files;
    }

    public static void deleteFolder(String dirPath) {
        FileUtil.deleteFolder(new File(dirPath));
    }

    public static void deleteFolder(File file) {
        File[] childFiles;
        if (file == null) {
            throw new IllegalArgumentException("file object is null!");
        }
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("the file [ " + file + " ] is NOT a directory!");
        }
        File[] fileArray = childFiles = file.listFiles();
        int n = childFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File childFile = fileArray[n2];
            if (childFile.isFile()) {
                childFile.delete();
            } else {
                FileUtil.deleteFolder(childFile);
            }
            ++n2;
        }
        file.delete();
    }

    public static boolean rename(File file, String newName) {
        if (!file.exists()) {
            return false;
        }
        String dstPath = String.valueOf(file.getParent()) + File.separator + newName;
        return file.renameTo(new File(dstPath));
    }

    public static String getParentDirPath(String path, int floorNum) {
        if (!FileUtil.dirExists(path) && !FileUtil.fileExists(path)) {
            throw new WrappedException("path does not exist!path is:" + path);
        }
        try {
            path = URLDecoder.decode(path, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < floorNum) {
            path = FileUtil.getParentPath(new File(path));
            ++i;
        }
        return path;
    }

    public static String buildUniversalPath(String base, String ... parts) {
        if (StringHelper.isEmpty(base)) {
            return null;
        }
        base = base.trim();
        StringBuilder sb = new StringBuilder(base);
        if (!base.endsWith(UNIVERSAL_SEPARATOR) && !base.endsWith("\\")) {
            sb.append(UNIVERSAL_SEPARATOR);
        }
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!StringHelper.isEmpty(part)) {
                if ((part = part.trim()).endsWith(UNIVERSAL_SEPARATOR) || part.endsWith("\\")) {
                    sb.append(part);
                }
                sb.append(part).append(UNIVERSAL_SEPARATOR);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String getCurrentWorkingDir() {
        return System.getProperty("user.dir");
    }

    public static String getParentDir() {
        String currDir = System.getProperty("user.dir");
        File file = new File(currDir);
        return file.getParent();
    }

    public static String getOSUserHomeDir() {
        return System.getProperty("user.home");
    }

    public static String getOSTempDir() {
        return FileUtil.formatPath(System.getProperty("java.io.tmpdir"));
    }

    public static String getSubPath(String rootPath, File f) {
        if (rootPath == null || f == null) {
            return null;
        }
        File rootFile = new File(rootPath);
        if (!rootFile.isDirectory()) {
            return null;
        }
        if (!f.exists()) {
            return null;
        }
        String fullPath = FileUtil.getParentPath(f);
        fullPath = fullPath.replace('\\', '/');
        rootPath = rootPath.replace('\\', '/');
        return StringHelper.removeBeginPart(fullPath, rootPath);
    }

    public static boolean belongsTo(File file, String ancestorDirPath) {
        if (file == null || ancestorDirPath == null) {
            return false;
        }
        File ancestorDir = new File(ancestorDirPath);
        if (!ancestorDir.isDirectory()) {
            return false;
        }
        File parent = file.getParentFile();
        while (parent != null) {
            if (ancestorDir.equals(parent)) {
                return true;
            }
            parent = parent.getParentFile();
        }
        return false;
    }

    public static boolean pathBelongsTo(String fullPath, String ancestorDirPath) {
        if (fullPath == null || ancestorDirPath == null) {
            return false;
        }
        return fullPath.indexOf(ancestorDirPath) == 0;
    }

    public static long getFreeSpace(String physicalPath) {
        if (physicalPath == null) {
            return 0L;
        }
        File partition = new File(physicalPath);
        return partition.getFreeSpace();
    }

    public static long getTotalSpace(String physicalPath) {
        if (physicalPath == null) {
            return 0L;
        }
        File partition = new File(physicalPath);
        return partition.getTotalSpace();
    }

    public static void saveFile(String filePath, InputStream is) {
        block8: {
            FileOutputStream fos = null;
            try {
                try {
                    if (FileUtil.createNewFile(filePath)) {
                        fos = new FileOutputStream(filePath);
                        byte[] buffer = new byte[0x100000];
                        int byteRead = 0;
                        while ((byteRead = is.read(buffer)) != -1) {
                            fos.write(buffer, 0, byteRead);
                            fos.flush();
                        }
                    } else {
                        logger.error((Object)("file (" + filePath + ") can't created."));
                    }
                }
                catch (IOException ex) {
                    logger.error((Object)("file(" + filePath + ") save failed:" + ex.getMessage()), (Throwable)ex);
                    CloseUtil.closeOutputStream(fos);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                CloseUtil.closeOutputStream(fos);
                throw throwable;
            }
            CloseUtil.closeOutputStream(fos);
        }
    }

    public static void saveFile(String filePath, String textContent) {
        block6: {
            if (!FileUtil.fileExists(filePath)) {
                FileUtil.createNewFile(filePath);
            }
            FileWriter fw = null;
            try {
                try {
                    fw = new FileWriter(filePath);
                    fw.write(textContent);
                    fw.flush();
                }
                catch (IOException ex) {
                    logger.error((Object)("file save failed:" + ex.getMessage()), (Throwable)ex);
                    CloseUtil.closeWriter(fw);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                CloseUtil.closeWriter(fw);
                throw throwable;
            }
            CloseUtil.closeWriter(fw);
        }
    }

    public static String buildFullPath(String filePath, String fileName) {
        return String.valueOf(StringHelper.smartAppendSuffix(filePath, File.separator)) + fileName;
    }

    public static File getFile(String filePath) {
        return new File(filePath);
    }

    public static void saveFile(File file, String content, String encoding) throws IOException {
        if (StringHelper.isEmpty(content)) {
            content = "";
        }
        if (StringHelper.isEmpty(encoding)) {
            encoding = UTF_8;
        }
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            file.createNewFile();
            fos = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)fos, encoding);
            bw = new BufferedWriter(osw);
            bw.write(content);
        }
        catch (Throwable throwable) {
            CloseUtil.closeWriter(bw);
            CloseUtil.closeWriter(osw);
            CloseUtil.closeOutputStream(fos);
            throw throwable;
        }
        CloseUtil.closeWriter(bw);
        CloseUtil.closeWriter(osw);
        CloseUtil.closeOutputStream(fos);
    }

    public static void saveFile(String filePath, String content, String encoding) throws IOException {
        FileUtil.saveFile(new File(filePath), content, encoding);
    }

    public static String getFileExtention(String fileName) {
        if (fileName == null) {
            return null;
        }
        int pos = fileName.lastIndexOf(46);
        if (pos >= 0) {
            return fileName.substring(pos + 1);
        }
        return null;
    }

    public static String cleanFilePath(String path) {
        if (path == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(path.length() * 2);
        int i = 0;
        while (i < path.length()) {
            char c = path.charAt(i);
            if (c == '\\') {
                sb.append('/');
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static void writeFile(File targetFile, InputStream inputStream) throws IOException {
        FileOutputStream fos = null;
        try {
            int length;
            fos = new FileOutputStream(targetFile);
            targetFile.createNewFile();
            byte[] buff = new byte[4096];
            while ((length = inputStream.read(buff, 0, 4096)) > 0) {
                fos.write(buff, 0, length);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.closeOutputStream(fos);
            CloseUtil.closeInputStream(inputStream);
            throw throwable;
        }
        CloseUtil.closeOutputStream(fos);
        CloseUtil.closeInputStream(inputStream);
    }

    public static byte[] readBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream bos = null;
        try {
            int length;
            bos = new ByteArrayOutputStream();
            byte[] buff = new byte[4096];
            while ((length = inputStream.read(buff, 0, 4096)) > 0) {
                bos.write(buff, 0, length);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            CloseUtil.closeOutputStream(bos);
            CloseUtil.closeInputStream(inputStream);
        }
    }

    /*
     * Loose catch block
     */
    public static String readText(InputStream is, String encoding) throws IOException {
        String string;
        StringBuffer sb = new StringBuffer(4096);
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader(is, encoding);
            br = new BufferedReader(isr);
            boolean firstLine = true;
            String line = br.readLine();
            while (line != null) {
                if (!firstLine) {
                    sb.append(LINE_FEED);
                } else {
                    firstLine = false;
                }
                sb.append(line);
                line = br.readLine();
            }
            br.close();
            string = sb.toString();
        }
        catch (Exception e) {
            CloseUtil.closeReader(br);
            CloseUtil.closeReader(isr);
            CloseUtil.closeInputStream(is);
            return null;
            catch (Throwable throwable) {
                CloseUtil.closeReader(br);
                CloseUtil.closeReader(isr);
                CloseUtil.closeInputStream(is);
                throw throwable;
            }
        }
        CloseUtil.closeReader(br);
        CloseUtil.closeReader(isr);
        CloseUtil.closeInputStream(is);
        return string;
    }

    public static void writeFile(File file, byte[] bytes) throws IOException {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            file.createNewFile();
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        }
        catch (Throwable throwable) {
            CloseUtil.closeOutputStream(bos);
            CloseUtil.closeOutputStream(fos);
            throw throwable;
        }
        CloseUtil.closeOutputStream(bos);
        CloseUtil.closeOutputStream(fos);
    }

    public static void writeFile(File file, String content, String encoding) throws IOException {
        if (content == null) {
            content = "";
        }
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            file.createNewFile();
            fos = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)fos, encoding);
            bw = new BufferedWriter(osw);
            bw.write(content);
        }
        catch (Throwable throwable) {
            CloseUtil.closeWriter(bw);
            CloseUtil.closeWriter(osw);
            CloseUtil.closeOutputStream(fos);
            throw throwable;
        }
        CloseUtil.closeWriter(bw);
        CloseUtil.closeWriter(osw);
        CloseUtil.closeOutputStream(fos);
    }

    /*
     * Loose catch block
     */
    public static String readTextFile(File file, String encoding) throws IOException {
        block10: {
            String string;
            StringBuffer sb = new StringBuffer(4096);
            InputStreamReader isr = null;
            BufferedReader br = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                isr = new InputStreamReader((InputStream)fis, encoding);
                br = new BufferedReader(isr);
                boolean firstLine = true;
                String line = br.readLine();
                while (line != null) {
                    if (!firstLine) {
                        sb.append(LINE_FEED);
                    } else {
                        firstLine = false;
                    }
                    sb.append(line);
                    line = br.readLine();
                }
                br.close();
                string = sb.toString();
                CloseUtil.closeReader(br);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)e);
                break block10;
            }
            catch (Exception exception) {
                CloseUtil.closeReader(br);
                CloseUtil.closeReader(isr);
                CloseUtil.closeInputStream(fis);
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                CloseUtil.closeReader(br);
                CloseUtil.closeReader(isr);
                CloseUtil.closeInputStream(fis);
            }
            CloseUtil.closeReader(isr);
            CloseUtil.closeInputStream(fis);
            return string;
        }
        return null;
    }

    public static boolean isUTF8Encoding(File file) {
        String mostProbableCharset = EncodingDetector.getMostProbableCharset(file);
        return UTF_8.equals(mostProbableCharset);
    }

    public static void forceDeleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile()) {
                    files[i].delete();
                } else {
                    FileUtil.forceDeleteDirectory(files[i]);
                }
                ++i;
            }
        }
        directory.delete();
    }

    public static InputStream getInputStream(String fileUrl) {
        InputStream is = null;
        if (fileUrl.startsWith("classpath://")) {
            is = FileUtil.class.getClassLoader().getResourceAsStream(fileUrl.substring("classpath://".length()));
        } else {
            try {
                is = new FileInputStream(fileUrl);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("NotFound :" + fileUrl));
            }
        }
        return is;
    }
}

