/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.deployer.domain.impl.for1095;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.common.publish.widget.Master;
import com.trs.components.common.publish.widget.Masters;
import com.trs.deployer.domain.DeployerStatus;
import com.trs.deployer.domain.impl.BaseDeployerHandler;
import com.trs.deployer.domain.impl.DeployerStatusRecorder;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnzip;
import com.trs.infra.util.CMyZip;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.jazzlib.ZipEntry;
import java.io.File;
import java.util.Enumeration;
import java.util.Map;

public class VisualTemplateTitleTagVerifyHandler
extends BaseDeployerHandler {
    public void execute(Map map) throws CMyException {
        DeployerStatusRecorder deployerStatusRecorder = new DeployerStatusRecorder();
        String string = this.getClass().getName();
        DeployerStatus deployerStatus = deployerStatusRecorder.getDeployerStatus(string);
        if (deployerStatus == null) {
            deployerStatus = new DeployerStatus(string, false);
        }
        if (deployerStatus.isFinished()) {
            return;
        }
        User user = ContextHelper.getLoginUser();
        try {
            this.verifyVisualTemplatesTitleTag(user);
            this.verifyMastersTitleTag(user);
        }
        catch (Exception exception) {
            deployerStatus.setFinished(false);
            deployerStatusRecorder.setDeployerStatus(deployerStatus);
            throw new CMyException("\u8c03\u6574\u4e13\u9898\u6bcd\u7248\u548c\u53ef\u89c6\u5316\u6a21\u677f\u7684title\u6807\u8bb0\u4fe1\u606f", (Throwable)exception);
        }
        deployerStatus.setFinished(true);
        deployerStatusRecorder.setDeployerStatus(deployerStatus);
    }

    public String getDesc() {
        return "\u8c03\u6574\u4e13\u9898\u6bcd\u7248\u548c\u53ef\u89c6\u5316\u6a21\u677f\u7684title\u6807\u8bb0\u4fe1\u606f";
    }

    public int getVersionNumber() {
        return 4;
    }

    private int verifyVisualTemplatesTitleTag(User user) throws CMyException {
        WCMFilter wCMFilter = new WCMFilter("", "Visual=1", "");
        Templates templates = Templates.openWCMObjs((User)user, (WCMFilter)wCMFilter);
        int n = 0;
        int n2 = templates.size();
        for (int i = 0; i < n2; ++i) {
            String string;
            Template template = (Template)templates.getAt(i);
            if (template == null || CMyString.isEmpty((String)(string = template.getText()))) continue;
            string = string.replaceFirst("(?is)<title>.*?</title>", "<title><TRS_ObjTitle></TRS_ObjTitle></title>");
            template.setText(string);
            template.save(user);
        }
        return n;
    }

    private int verifyMastersTitleTag(User user) throws CMyException {
        WCMFilter wCMFilter = new WCMFilter("", "", "");
        Masters masters = Masters.openWCMObjs((User)user, (WCMFilter)wCMFilter);
        int n = 0;
        int n2 = masters.size();
        for (int i = 0; i < n2; ++i) {
            Master master = (Master)masters.getAt(i);
            if (master != null && this.verifyMasterTitleTag(master)) continue;
        }
        return n;
    }

    private boolean verifyMasterTitleTag(Master master) throws CMyException {
        if (master == null) {
            return false;
        }
        String string = master.getFileName();
        if (CMyString.isEmpty((String)string)) {
            return false;
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.mapFilePath(string, 0);
        string2 = CMyString.setStrEndWith((String)string2, (char)File.separatorChar);
        String string3 = string2 + string;
        CMyUnzip cMyUnzip = new CMyUnzip();
        String string4 = string2 + "unZip" + CMyFile.extractMainFileName((String)string) + File.separatorChar;
        System.out.println("sFullFileName:" + string3);
        System.out.println("sUnZipPath:" + string4);
        cMyUnzip.setZipFile(string3);
        cMyUnzip.unzip(string4, true);
        CMyZip cMyZip = new CMyZip();
        cMyZip.setZipFileName(string3);
        Enumeration enumeration = cMyUnzip.getItems();
        ZipEntry zipEntry = null;
        String string5 = null;
        block0 : switch (master.getMasterType()) {
            case 1: {
                while (enumeration.hasMoreElements()) {
                    zipEntry = (ZipEntry)enumeration.nextElement();
                    if (zipEntry.getName().toLowerCase().indexOf(".html") == -1) continue;
                    string5 = zipEntry.getName();
                    if (!zipEntry.getName().equalsIgnoreCase("index.html")) continue;
                    break block0;
                }
                break;
            }
            case 2: {
                while (enumeration.hasMoreElements()) {
                    zipEntry = (ZipEntry)enumeration.nextElement();
                    if (zipEntry.getName().toLowerCase().indexOf(".html") == -1) continue;
                    string5 = zipEntry.getName();
                    if (!zipEntry.getName().equalsIgnoreCase("detail.html")) continue;
                    break block0;
                }
                break;
            }
        }
        if (string5 == null) {
            System.out.println("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6bcd\u677f\u6587\u4ef6......");
            return true;
        }
        this.verifyMasterFile(string4 + string5);
        System.out.println(string4 + string5 + ":-->:" + string3);
        cMyZip.addToZip(string4 + string5, false);
        cMyZip.done();
        CMyFile.deleteDir((String)string4);
        return true;
    }

    private void verifyMasterFile(String string) throws CMyException {
        if (!CMyFile.fileExists((String)string)) {
            return;
        }
        String string2 = CharsetDetector.detect((String)string);
        String string3 = CMyFile.readFile((String)string, (String)string2);
        if (CMyString.isEmpty((String)string3)) {
            return;
        }
        string3 = string3.replaceFirst("(?is)<title>.*?</title>", "<title><TRS_TagCreator tag=\"TRS_ObjTitle\" /></title>");
        CMyFile.writeFile((String)string, (String)string3, (String)string2);
    }
}

