/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.gateway.view.util;

import com.trs.cis4.gateway.logic.util.GWSysApplication;
import com.trs.cis4.socket.config.RobotConfig;
import com.trs.cis4.util.ConstUtil;
import com.trs.cis4.util.GenerateUtil;
import com.trs.cis4.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrsagentServerExtend {
    private static List<RobotConfig> robotConfigs = new ArrayList<RobotConfig>();

    public static List<RobotConfig> getRobotConfigList() {
        if (robotConfigs.size() == 0) {
            robotConfigs = TrsagentServerExtend.readRobotConfigList();
        }
        return robotConfigs;
    }

    private static List<RobotConfig> readRobotConfigList() {
        String sep = ConstUtil.DIR_SEPERATOR;
        String filename = String.valueOf(GWSysApplication.getSysXmlFolder()) + sep + "serverExtend.xml";
        File file = new File(filename);
        if (!file.exists()) {
            return new ArrayList<RobotConfig>();
        }
        try {
            List robotConfigList = (List)XmlUtil.readObject((String)filename);
            return robotConfigList;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<RobotConfig>();
        }
    }

    public static void saveRobotConfigs(List<RobotConfig> _robotConfigs) {
        String sep = ConstUtil.DIR_SEPERATOR;
        String filename = String.valueOf(GWSysApplication.getSysXmlFolder()) + sep + "serverExtend.xml";
        try {
            XmlUtil.writeObject((String)filename, _robotConfigs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        robotConfigs = _robotConfigs;
    }

    public static RobotConfig getRobotConfig(String robotid) {
        if (robotConfigs != null) {
            for (RobotConfig tempRobotConfig : robotConfigs) {
                if (tempRobotConfig == null || !robotid.equals(tempRobotConfig.getRobotid())) continue;
                return tempRobotConfig;
            }
        }
        return null;
    }

    public static void saveRobotConfig(RobotConfig robotConfig) {
        String robotid = robotConfig.getRobotid();
        if (robotConfigs == null) {
            robotConfigs = new ArrayList<RobotConfig>();
        }
        if (robotid == null || robotid.equals("")) {
            robotConfig.setRobotid(String.valueOf(GenerateUtil.generate32()));
            robotConfigs.add(robotConfig);
        } else {
            for (RobotConfig rc : robotConfigs) {
                if (!robotid.equals(rc.getRobotid())) continue;
                BeanUtils.copyProperties((Object)robotConfig, (Object)rc);
            }
        }
        TrsagentServerExtend.saveRobotConfigs(robotConfigs);
    }
}

