/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.session;

import com.trs.infra.cluster.StreamReader;
import com.trs.infra.cluster.StreamType;
import com.trs.infra.cluster.StreamWriter;
import com.trs.infra.cluster.Streamable;
import com.trs.infra.cluster.session.ClusterSession;
import com.trs.infra.cluster.session.SessionManagerImpl;
import com.trs.infra.session.impl.StandardSessionBase;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClusterSessionImpl
extends StandardSessionBase
implements ClusterSession,
Streamable {
    private int calloverCount = 0;
    private boolean primarySession = false;

    public ClusterSessionImpl() {
        super(null);
    }

    public ClusterSessionImpl(SessionManagerImpl sessionContext) {
        super(sessionContext);
    }

    private final SessionManagerImpl getSessionManager() {
        return (SessionManagerImpl)this.getSessionContext();
    }

    public String _guid() {
        return this.getSessionID();
    }

    public StreamType _type() {
        return null;
    }

    public void _load(StreamReader is) throws IOException {
        this.sessionID = is.read_string();
        this.sessionNew = is.read_boolean();
        this.sessionState = is.read_int();
        this.userLevel = is.read_int();
        this.userName = is.read_string();
        this.maxInactiveInterval = is.read_int();
        this.createTime = is.read_long();
        this.createURI = is.read_string();
        this.clientAddress = is.read_string();
        this.routedProxies = is.read_string();
        this.clientBrowser = is.read_string();
        this.thisAccessTime = is.read_long();
        this.primarySession = is.read_boolean();
        boolean hasAttributes = is.read_boolean();
        if (hasAttributes) {
            try {
                List listNames = (List)is.read_object();
                List listValues = (List)is.read_object();
                int i = listNames.size() - 1;
                while (i >= 0) {
                    String name = (String)listNames.get(i);
                    Object value = listValues.get(i);
                    this.setAttributeInternal(name, value);
                    --i;
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Class not found:" + e.toString());
            }
        }
    }

    public void _save(StreamWriter os) throws IOException {
        os.write_string(this.sessionID);
        os.write_boolean(this.sessionNew);
        os.write_int(this.sessionState);
        os.write_int(this.userLevel);
        os.write_string(this.userName);
        os.write_int(this.maxInactiveInterval);
        os.write_long(this.createTime);
        os.write_string(this.createURI);
        os.write_string(this.clientAddress);
        os.write_string(this.routedProxies);
        os.write_string(this.clientBrowser);
        os.write_long(this.thisAccessTime);
        os.write_boolean(this.primarySession);
        if (this.attributes == null || this.attributes.size() <= 0) {
            os.write_boolean(false);
        } else {
            ArrayList<String> listNames = new ArrayList<String>();
            ArrayList listValues = new ArrayList();
            Iterator itr = this.attributes.keySet().iterator();
            while (itr.hasNext()) {
                Object value;
                String name = (String)itr.next();
                if (name == null || (value = this.attributes.get(name)) == null || !(value instanceof Serializable)) continue;
                listNames.add(name);
                listValues.add(value);
            }
            if (listNames.size() <= 0) {
                os.write_boolean(false);
            } else {
                os.write_boolean(true);
                os.write_object(listNames);
                os.write_object(listValues);
            }
        }
    }

    public final void setLevel(int newLevel) {
        this.setLevelInternal(newLevel);
        this.getSessionManager().sendSessionLevel(this);
    }

    public final void setLevelByCluster(int newLevel) {
        this.setLevelInternal(newLevel);
    }

    public final void setUserName(String userName) {
        this.setUserNameInternal(userName);
        this.getSessionManager().sendSessionUserName(this);
    }

    public final void setUserNameByCluster(String userName) {
        this.setUserNameInternal(userName);
    }

    public final void setMaxInactiveInterval(int maxInactiveInterval) {
        this.setMaxInactiveIntervalInternal(maxInactiveInterval);
        this.getSessionManager().sendMaxInactiveInterval(this);
    }

    public final void setMaxInactiveIntervalByCluster(int maxInactiveInterval) {
        this.setMaxInactiveIntervalInternal(maxInactiveInterval);
    }

    public final void setAttribute(String name, Object value) {
        this.setAttributeInternal(name, value);
        if (value instanceof Serializable) {
            this.getSessionManager().sendSessionAttribute(this, name, (Serializable)value);
        }
    }

    public final void setAttributeByCluster(String name, Object value) {
        this.setAttributeInternal(name, value);
    }

    public final void expire() {
        this.expireInternal();
        this.getSessionManager().sendSessionExpire(this);
    }

    public final void expireByCluster() {
        this.expireInternal();
    }

    public final void invalidate() {
        this.invalidateInternal();
        this.getSessionManager().sendSessionInvalidate(this);
    }

    public final void invalidateByCluster() {
        this.invalidateInternal();
    }

    public void clearCalloverCount() {
        this.calloverCount = 0;
    }

    public void incCalloverCount() {
        ++this.calloverCount;
    }

    public int getCalloverCount() {
        return this.calloverCount;
    }

    public boolean isPrimarySession() {
        return this.primarySession;
    }

    public void setPrimarySession(boolean primarySession) {
        this.primarySession = primarySession;
    }
}

