/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.io;

import java.io.IOException;
import java.io.InputStream;

public class ByteArrayInputStream
extends InputStream {
    byte[] buffer;
    int limit1 = 0;
    int limit2;
    int offset;

    public ByteArrayInputStream(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public ByteArrayInputStream(byte[] buf, int off, int len) {
        this.buffer = buf;
        this.offset = off;
        this.limit1 = off;
        this.limit2 = Math.min(off + len, buf.length);
    }

    public final byte[] getBuffer() {
        return this.buffer;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int available() {
        return this.limit2 - this.offset;
    }

    public final void close() throws IOException {
    }

    public final void mark(int readAheadLimit) {
        this.limit1 = this.offset;
    }

    public final boolean markSupported() {
        return true;
    }

    public final int read() {
        return this.offset < this.limit2 ? this.buffer[this.offset++] & 0xFF : -1;
    }

    public final int read(byte[] buf, int off, int len) {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > buf.length || len < 0 || off + len > buf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.offset >= this.limit2) {
            return -1;
        }
        if (this.offset + len > this.limit2) {
            len = this.limit2 - this.offset;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buffer, this.offset, buf, off, len);
        this.offset += len;
        return len;
    }

    public final void reset() {
        this.offset = this.limit1;
    }

    public final long skip(long n) {
        if (n > 0L && (long)this.offset + n > (long)this.limit2) {
            n = this.limit2 - this.offset;
        }
        if (n < 0L && (long)this.offset + n < (long)this.limit1) {
            n = this.limit1 - this.offset;
        }
        this.offset = (int)((long)this.offset + n);
        return n;
    }
}

